<table class="table table-borderless best-selling-courses best-instructor">
    <thead>
        <tr>
            <th><?php echo e(__('name')); ?></th>
            <th><?php echo e(__('total_spend')); ?></th>
            <th><?php echo e(__('started_at')); ?></th>
        </tr>
    </thead>
    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $best_clients ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client_id => $total): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php
                $client = App\Models\User::where('client_id', $client_id)->first();
                $total_spend = App\Models\Subscription::where('client_id', $client_id)->sum('price');
            ?>
            <tr>
                <td>
                    <div class="instructors-pro d-flex align-items-center">
                        <div class="inst-avtar">
                            <img src="<?php echo e(getFileLink('image', $client->image, 'users', '80x80')); ?>"
                                alt="<?php echo e($client->first_name.' '.$client->last_name ?? 'Client'); ?>">
                        </div>
                        <div class="inst-intro">
                            <h6><?php echo e($client->first_name.' '.$client->last_name ?? 'Client'); ?></h6>
                            <p><?php echo e($client->email ?? ''); ?></p>
                        </div>
                    </div>
                </td>
                <td><?php echo e(get_currency(number_format($total_spend, 2))); ?></td>
                <td><?php echo e($client->created_at->format('d M Y') ?? ''); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="3"><?php echo e(__('no_best_clients_found')); ?></td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>
<?php /**PATH /home/savadata/check.belovevn.com/public/resources/views/admin/dashboard/best_client_table.blade.php ENDPATH**/ ?>