<nav class="navbar navbar-top navbar-expand-lg bg-body-tertiary py-20 bg-white sticky-top">
    <div class="container-fluid g-5">
        <span class="sidebar-toggler">
            <span class="icon">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M16 6H3" stroke="#7E7F92" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    </path>
                    <path d="M21 12H3" stroke="#7E7F92" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    </path>
                    <path d="M18 18H3" stroke="#7E7F92" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    </path>
                </svg>
            </span>
        </span>
        <a class="navbar-brand ms-auto d-none" href="<?php echo e(url('/')); ?>">
            <img src="<?php echo e(($logo = json_decode(get_config('admin_mini_logo'), true)) && isset($logo['original_image']) && is_file_exists($logo['original_image']) ? get_media($logo['original_image']) : 'images/default/logo/logo.png'); ?>"
                alt="<?php echo e(__('image')); ?>">
        </a>
        <button class="navbar-toggler ms-auto" type="button" data-bs-toggle="collapse" data-bs-target="#navbarScroll"
            aria-controls="navbarScroll" aria-expanded="false" aria-label="Toggle navigation">
            <span class="las la-ellipsis-v"></span>
        </button>
        <div class="collapse navbar-collapse navbar-content px-lg-20 navbar-respons" id="navbarScroll">
            <div class="navbar-left-content me-lg-auto d-flex align-items-center gap-20">

                <ul class="dashboard-btn d-flex align-items-center gap-lg-20 gap-sm-2">
                    <li>
                        <a href="<?php echo e(route('cache.clear')); ?>"
                            class="d-flex align-items-center button-default default-circle-btn gap-2">
                            <i class="las la-hdd"></i>
                            <span><?php echo e(__('clear_cache')); ?></span>
                        </a>
                    </li>
                    <li class="dropdown add-new-page">
                        <a href="javascript:void(0)"
                            class="dropdown-toggle d-flex align-items-center button-default default-circle-btn gap-2"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="las la-plus"></i>
                            <span><?php echo e(__('add_new')); ?></span>
                        </a>
                        <ul class="dropdown-menu simplebar">
                            <li>
                                <a class="dropdown-item" href="<?php echo e(route('admin.movie.add')); ?>">
                                    <i class="las la-film"></i>
                                    <span><?php echo e(__('add_movie')); ?></span>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="<?php echo e(route('admin.tv.show.add')); ?>">
                                    <i class="las la-tv"></i>
                                    <span><?php echo e(__('add_tv_series')); ?></span>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="javascript:void(0)"
                                    onclick="ajaxModal('modal-md', '<?php echo e(route('admin.season.add')); ?>', '<?php echo e(__('season_add')); ?>')">
                                    <i class="lab la-chromecast"></i>
                                    <span><?php echo e(__('add_season')); ?></span>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="javascript:void(0)"
                                    onclick="ajaxModal('modal-xl', '<?php echo e(route('admin.episode.add')); ?>', '<?php echo e(__('episode_add')); ?>')">
                                    <i class="lab la-chromecast"></i>
                                    <span><?php echo e(__('add_episodes')); ?></span>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="<?php echo e(route('admin.live.tv.add')); ?>">
                                    <i class="lab la-chromecast"></i>
                                    <span><?php echo e(__('add_live_tv')); ?></span>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="javascript:void(0)"
                                    onclick="ajaxModal('modal-md', '<?php echo e(route('admin.interest.add')); ?>', '<?php echo e(__('interest_add')); ?>')">
                                    <i class="lar la-heart"></i>
                                    <span><?php echo e(__('add_interest')); ?></span>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="<?php echo e(route('admin.blog.add')); ?>">
                                    <i class="las la-rss"></i>
                                    <span><?php echo e(__('add_blog')); ?></span>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="<?php echo e(route('admin.staff.add')); ?>">
                                    <i class="las la-user-friends"></i>
                                    <span><?php echo e(__('add_staff')); ?></span>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="<?php echo e(route('roles.create')); ?>">
                                    <i class="las la-user"></i>
                                    <span><?php echo e(__('add_role')); ?></span>
                                </a>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>

            <div class="navbar-right-content">
                <ul class="d-flex align-items-center gap-lg-4 gap-sm-2">
                    <?php if(setting('disable_landing_page') != '1'): ?>
                        <li class="visit-website">
                            <a href="<?php echo e(url('/')); ?>" target="_blank">
                                <i class="las la-globe-americas"></i>
                                <span class="icon-hover"><?php echo e(__('visit_website')); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>
                   
                    <li class="select-language dropdown pe-lg-20">
                        <?php
                            $system_languages = App\Models\Language::where('status', 1)->get();
                            $default_language = App\Models\Language::where('id', get_config('default_language'))->value(
                                'locale',
                            );
                        ?>

                        <a href="javascript:void(0)" class="dropdown-toggle" data-bs-toggle="dropdown"
                            aria-expanded="false">
                            <?php echo e(strtoupper(session('locale') ?? $default_language)); ?>

                        </a>
                        <ul class="dropdown-menu popup-card">
                            <?php $__currentLoopData = $system_languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <a class="dropdown-item" href="<?php echo e(setLanguageRedirect($language->locale)); ?>">
                                        <img src="<?php echo e(static_asset('images/flags/' . $language->locale . '.png')); ?>"
                                            alt="<?php echo e($language->name); ?>">
                                        <?php echo e($language->name); ?>

                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </li>

                    <li class="dropdown pe-lg-20">
                        <a href="javascript:void(0)" class="dropdown-toggle d-flex gap-12" data-bs-toggle="dropdown"
                            aria-expanded="false">
                            <img src="<?php echo e(getFileLink('original_image', auth()->user()->image, 'users', '100x100')); ?>"
                                alt="<?php echo e(__('image')); ?>" class="user-avater">
                            <span class="user-name"><?php echo e(Auth::user()->first_name); ?>

                                <?php echo e(Auth::user()->last_name); ?></span>
                            <span class="active_status"></span>
                        </a>
                        <ul class="dropdown-menu popup-card">
                            <li>
                                <a class="dropdown-item" href="<?php echo e(route('admin.manage.profile')); ?>">
                                    <i class="lar la-user-circle"></i>
                                    <span><?php echo e(__('manage_profile')); ?></span>
                                </a>
                            </li>
                            <?php if(Auth::check()): ?>
                                <?php if(auth()->user()->role_id == 1): ?>
                                    <li>
                                        <a class="dropdown-item" href="<?php echo e(route('admin.change.password')); ?>">
                                            <i class="las la-shield-alt"></i>
                                            <span><?php echo e(__('change_password')); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            <?php endif; ?>
                            <li>
                                <a class="dropdown-item" href="<?php echo e(route('logout')); ?>">
                                    <i class="las la-sign-out-alt"></i>
                                    <span><?php echo e(__('sign_out')); ?></span>
                                </a>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</nav>
<?php /**PATH /home/savadata/check.belovevn.com/public/resources/views/admin/layouts/header.blade.php ENDPATH**/ ?>