<?php $__env->startSection('title', __('home_page')); ?>
<?php $__env->startSection('content'); ?>

    <!-- Banner Section Start -->
    <section class="banner__sliderSection p-0">
        <div class="swiper banner__slider">
            <div class="swiper-wrapper">
                <?php $__currentLoopData = $movie_sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <!-- Swiper Slide -->
                    <div class="swiper-slide" data-slide="0">
                        <div class="banner__video"
                            style="background-image: url(<?php echo e(getFileLink('original_image', $movie->poster, 'movies', '1920x1080', 'original')); ?>);">
                            <?php if($movie->trailler_youtube_source): ?>
                                <video id="video1" loop autoplay playsinline>
                                    <source src="<?php echo e($movie->trailler_youtube_source); ?>" type="video/mp4" />
                                </video>
                                <div class="Video__control">
                                    <button id="btn-mute1" class="btn-mute"></button>
                                    <button class="btn-play"><?php echo e(__('play')); ?></button>
                                </div>
                            <?php endif; ?>
                            <div class="bannerSlide__wrapper">
                                <div class="container-fluid">
                                    <div class="row align-items-center">
                                        <div class="col-lg-12">
                                            <div class="hero__text">
                                                <div class="video__tag">
                                                    <?php $__currentLoopData = json_decode($movie->genre); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $genre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <span><?php echo e(get_genre('name', $genre)); ?></span>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                                <h1 class="title"> <?php echo e($movie->title); ?> </h1>
                                                <p class="desc">
                                                    <?php echo e($movie->description); ?>

                                                </p>
                                                <div class="video__meta">
                                                    <div class="meta__item"><i
                                                            class="ri-star-fill"></i><?php echo e(number_format($movie->imdb_rating, 1)); ?>

                                                    </div>
                                                    <div class="meta__item"><i class="ri-time-fill"></i>
                                                        <?php echo e(runtime($movie->runtime)); ?> </div>
                                                    <div class="meta__item"><i
                                                            class="ri-calendar-2-fill"></i><?php echo e(date('Y', strtotime($movie->release))); ?>

                                                    </div>
                                                </div>
                                                <div class="btn__group">

                                                    <?php if(
                                                        (is_rent_expire('movie', $movie->id) && is_rental('movie', $movie->id)) ||
                                                            is_free('movie', $movie->id) ||
                                                            (check_subscription() && !is_rental('movie', $movie->id)) ||
                                                            is_admin()): ?>
                                                        <?php if(get_movie_url($movie->id)): ?>
                                                            <div class="dropdown__btn">
                                                                <div class="selected drop__action btn btn-primary selected">
                                                                    <i class="ri-play-fill"></i>
                                                                    <?php echo e(__('watch_now')); ?>

                                                                </div>
                                                                <ul class="dropdown__list">
                                                                    <?php $__currentLoopData = movie_files($movie->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $server): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <li>
                                                                            <a
                                                                                href="<?php echo e(route('watch.movie', ['slug' => $movie->slug, 'key' => $server->stream_key])); ?>">
                                                                                <?php echo e($server->label); ?> </a>
                                                                        </li>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </ul>
                                                            </div>
                                                        <?php endif; ?>
                                                    <?php else: ?>
                                                        <?php if(auth()->user() && !is_free('movie', $movie->id) && is_rental('movie', $movie->id)): ?>
                                                            <a class="btn btn-primary" href="javascript:void(0)"
                                                                onclick="ajaxModal('modal-md', '<?php echo e(route('payment.gateway.list', ['id' => $movie->id, 'type' => 'rental', 'video_type' => 'movie'])); ?>')">
                                                                <svg width="16" height="14" viewBox="0 0 16 14"
                                                                    fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                    <path
                                                                        d="M15.1773 2.04376C14.9337 1.94228 14.6654 1.91561 14.4066 1.96713C14.1478 2.01866 13.9102 2.14605 13.724 2.33309L12 4.05709L8.94267 0.999757C8.69263 0.749796 8.35355 0.609375 8 0.609375C7.64645 0.609375 7.30737 0.749796 7.05733 0.999757L4 4.05709L2.276 2.33309C2.08953 2.14668 1.85198 2.01974 1.59338 1.96831C1.33477 1.91689 1.06673 1.94329 0.823127 2.04419C0.579528 2.14508 0.37131 2.31593 0.224798 2.53515C0.0782854 2.75436 5.62991e-05 3.01209 0 3.27576L0 10.3331C0.00105857 11.2168 0.352588 12.0641 0.97748 12.6889C1.60237 13.3138 2.4496 13.6654 3.33333 13.6664H12.6667C13.5504 13.6654 14.3976 13.3138 15.0225 12.6889C15.6474 12.0641 15.9989 11.2168 16 10.3331V3.27576C16.0001 3.01207 15.9219 2.75428 15.7755 2.53499C15.6291 2.3157 15.4209 2.14475 15.1773 2.04376ZM14.6667 10.3331C14.6667 10.8635 14.456 11.3722 14.0809 11.7473C13.7058 12.1224 13.1971 12.3331 12.6667 12.3331H3.33333C2.8029 12.3331 2.29419 12.1224 1.91912 11.7473C1.54405 11.3722 1.33333 10.8635 1.33333 10.3331V3.27576L3.52867 5.47109C3.65369 5.59607 3.82322 5.66628 4 5.66628C4.17678 5.66628 4.34631 5.59607 4.47133 5.47109L8 1.94242L11.5287 5.47109C11.6537 5.59607 11.8232 5.66628 12 5.66628C12.1768 5.66628 12.3463 5.59607 12.4713 5.47109L14.6667 3.27576V10.3331Z"
                                                                        fill="white"></path>
                                                                </svg>
                                                                <span>
                                                                    <?php echo e(__('rent') . ' ' . get_currency($movie->rental_price)); ?>

                                                                </span>
                                                            </a>
                                                        <?php elseif(!auth()->user() && is_rental('movie', $movie->id)): ?>
                                                            <a class="btn btn-white active" href="javascript:void(0)"
                                                                onclick="ajaxModal('modal-md', '<?php echo e(route('login')); ?>')">
                                                                <svg width="16" height="14" viewBox="0 0 16 14"
                                                                    fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                    <path
                                                                        d="M15.1773 2.04376C14.9337 1.94228 14.6654 1.91561 14.4066 1.96713C14.1478 2.01866 13.9102 2.14605 13.724 2.33309L12 4.05709L8.94267 0.999757C8.69263 0.749796 8.35355 0.609375 8 0.609375C7.64645 0.609375 7.30737 0.749796 7.05733 0.999757L4 4.05709L2.276 2.33309C2.08953 2.14668 1.85198 2.01974 1.59338 1.96831C1.33477 1.91689 1.06673 1.94329 0.823127 2.04419C0.579528 2.14508 0.37131 2.31593 0.224798 2.53515C0.0782854 2.75436 5.62991e-05 3.01209 0 3.27576L0 10.3331C0.00105857 11.2168 0.352588 12.0641 0.97748 12.6889C1.60237 13.3138 2.4496 13.6654 3.33333 13.6664H12.6667C13.5504 13.6654 14.3976 13.3138 15.0225 12.6889C15.6474 12.0641 15.9989 11.2168 16 10.3331V3.27576C16.0001 3.01207 15.9219 2.75428 15.7755 2.53499C15.6291 2.3157 15.4209 2.14475 15.1773 2.04376ZM14.6667 10.3331C14.6667 10.8635 14.456 11.3722 14.0809 11.7473C13.7058 12.1224 13.1971 12.3331 12.6667 12.3331H3.33333C2.8029 12.3331 2.29419 12.1224 1.91912 11.7473C1.54405 11.3722 1.33333 10.8635 1.33333 10.3331V3.27576L3.52867 5.47109C3.65369 5.59607 3.82322 5.66628 4 5.66628C4.17678 5.66628 4.34631 5.59607 4.47133 5.47109L8 1.94242L11.5287 5.47109C11.6537 5.59607 11.8232 5.66628 12 5.66628C12.1768 5.66628 12.3463 5.59607 12.4713 5.47109L14.6667 3.27576V10.3331Z"
                                                                        fill="white"></path>
                                                                </svg>
                                                                <span>
                                                                    <?php echo e(__('rent') . ' ' . get_currency($movie->rental_price)); ?>

                                                                </span>
                                                            </a>
                                                        <?php else: ?>
                                                            <a href="<?php echo e(route('packages')); ?>" class="btn btn-primary">
                                                                <svg width="16" height="14" viewBox="0 0 16 14"
                                                                    fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                    <path
                                                                        d="M15.1773 2.04376C14.9337 1.94228 14.6654 1.91561 14.4066 1.96713C14.1478 2.01866 13.9102 2.14605 13.724 2.33309L12 4.05709L8.94267 0.999757C8.69263 0.749796 8.35355 0.609375 8 0.609375C7.64645 0.609375 7.30737 0.749796 7.05733 0.999757L4 4.05709L2.276 2.33309C2.08953 2.14668 1.85198 2.01974 1.59338 1.96831C1.33477 1.91689 1.06673 1.94329 0.823127 2.04419C0.579528 2.14508 0.37131 2.31593 0.224798 2.53515C0.0782854 2.75436 5.62991e-05 3.01209 0 3.27576L0 10.3331C0.00105857 11.2168 0.352588 12.0641 0.97748 12.6889C1.60237 13.3138 2.4496 13.6654 3.33333 13.6664H12.6667C13.5504 13.6654 14.3976 13.3138 15.0225 12.6889C15.6474 12.0641 15.9989 11.2168 16 10.3331V3.27576C16.0001 3.01207 15.9219 2.75428 15.7755 2.53499C15.6291 2.3157 15.4209 2.14475 15.1773 2.04376ZM14.6667 10.3331C14.6667 10.8635 14.456 11.3722 14.0809 11.7473C13.7058 12.1224 13.1971 12.3331 12.6667 12.3331H3.33333C2.8029 12.3331 2.29419 12.1224 1.91912 11.7473C1.54405 11.3722 1.33333 10.8635 1.33333 10.3331V3.27576L3.52867 5.47109C3.65369 5.59607 3.82322 5.66628 4 5.66628C4.17678 5.66628 4.34631 5.59607 4.47133 5.47109L8 1.94242L11.5287 5.47109C11.6537 5.59607 11.8232 5.66628 12 5.66628C12.1768 5.66628 12.3463 5.59607 12.4713 5.47109L14.6667 3.27576V10.3331Z"
                                                                        fill="white"></path>
                                                                </svg>
                                                                <span><?php echo e(__('subscribe')); ?></span>
                                                            </a>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                    
                                                    <a href="javascript:void(0)" data-movie-id="<?php echo e($movie->id); ?>"
                                                        class="open-save-playlist-modal solid__btn"
                                                        title="<?php echo e(__('add_playlist')); ?>"><i
                                                            class="ri-add-line"></i><?php echo e(__('add_playlist')); ?></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>
            <div class="banner__swiper__navigation swiper__navigation">
                <div class="banner-swipe-prev swiper-button-prev">
                    <i class="ri-arrow-left-s-line"></i>
                </div>
                <div class="banner-swipe-next swiper-button-next">
                    <i class="ri-arrow-right-s-line"></i>
                </div>
            </div>
            <div class="banner__pagination swiper__pagination">
                <div class="swiper-pagination"></div>
            </div>
        </div>
    </section>
    <!-- Banner Section End -->

    <?php if(count($genres)): ?>
        <!-- Category Section Start -->
        <section class="category__section pt-60 pb-30">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="section__title">
                            <h2 class="title"><?php echo e(__('explore_by_genre')); ?></h2>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="position-relative px-40">
                            <div class="swiper category__slider">
                                <div class="swiper-wrapper">
                                    <?php $__currentLoopData = $genres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $genre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="swiper-slide">
                                            <div class="category__item">
                                                <a
                                                    href="<?php echo e(route('genre.wise.movie', ['slug' => $genre->slug])); ?>"><?php echo e($genre->name); ?></a>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <div class="swiper__navigation">
                                <div class="category-swipe-prev swiper-button-prev">
                                    <i class="ri-arrow-left-s-line"></i>
                                </div>
                                <div class="category-swipe-next swiper-button-next">
                                    <i class="ri-arrow-right-s-line"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Category Section End -->
    <?php endif; ?>

    <?php if(count($watch_histories) && auth()->user()): ?>
        <section class="category__section pt-60 pb-30">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="section__title">
                            <h2 class="title"><?php echo e(__('continue_watching')); ?></h2>
                            <div class="view__btn">
                                <a
                                    href="<?php echo e(route('user.dashboard', ['tab' => 'watch-history'])); ?>"><?php echo e(__('view_all')); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="position-relative">
                            <div class="swiper movie__slider">
                                <div class="swiper-wrapper">
                                    <?php $__currentLoopData = $watch_histories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            if ($history->watchable_type == 'movie') {
                                                $thumbnail = $history->movie->thumbnail;
                                                $title = $history->movie->title;
                                                $movie_id = $history->movie->id;
                                                if (
                                                    (is_rent_expire('movie', $movie_id) &&
                                                        is_rental('movie', $movie_id)) ||
                                                    is_free('movie', $movie_id) ||
                                                    (check_subscription() && !is_rental('movie', $movie_id)) ||
                                                    is_admin()
                                                ) {
                                                    $video_url = route('watch.movie', [
                                                        'slug' => $history->movie->slug,
                                                    ]);
                                                }
                                            } else {
                                                $thumbnail = $history->episode->poster;
                                                $title = $history->episode->episode_name;
                                                $series_id = $history->episode->tv_show_id;
                                                $order = $history->episode->order;
                                                if (
                                                    (is_rent_expire('series', $series_id) &&
                                                        is_rental('series', $series_id)) ||
                                                    is_free('series', $series_id) ||
                                                    (check_subscription() && !is_rental('series', $series_id)) ||
                                                    is_admin()
                                                ) {
                                                    $video_url = route('watch.episode', [
                                                        'slug' => $history->episode->slug,
                                                    ]);
                                                }
                                            }
                                        ?>
                                        <div class="swiper-slide">
                                            <!-- Video Card -->
                                            <div class="video__card">
                                                <a href="<?php echo e(isset($video_url) ? $video_url : route('packages')); ?>"
                                                    class="video__thumb">
                                                    <div class="imageCard">
                                                        <img src="<?php echo e(getFileLink('thumbnail', $thumbnail, 'thumbnails', '500x750')); ?>"
                                                            alt="imageCard" />
                                                        <div class="video__btn">
                                                            <i class="ri-play-fill"></i>
                                                        </div>
                                                        <div class="imageCard__content">
                                                            <h4 class="title"> <?php echo e($title); ?> </h4>
                                                            <span class="duration">
                                                                <?php echo e(watch_history_duration($history->watchable_type, $history->duration, $history->watched_seconds, $order ?? 0)); ?>

                                                            </span>
                                                            <div class="bar">
                                                                <div class=" <?php echo e($history->completion_percentage > 0 ? 'bar__active' : ''); ?>"
                                                                    style="width: <?php echo e($history->completion_percentage > 0 ? $history->completion_percentage : 100); ?>%">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <div class="swiper__navigation">
                                <div class="movie-swipe-prev swiper-button-prev">
                                    <i class="ri-arrow-left-s-line"></i>
                                </div>
                                <div class="movie-swipe-next swiper-button-next">
                                    <i class="ri-arrow-right-s-line"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <?php if(count($latest_movies) > 0): ?>
        <!-- Video Section Start -->
        <section class="video__section">
            <div class="inner__section py-30">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="section__title">
                                <h2 class="title"><?php echo e(__('latest_movies')); ?></h2>
                                <div class="view__btn">
                                    <a href="<?php echo e(route('all.movies', ['type' => 'latest'])); ?>"><?php echo e(__('view_all')); ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class="position-relative">
                                <div class="swiper movie__slider">
                                    <div class="swiper-wrapper">
                                        <?php $__currentLoopData = $latest_movies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <!-- Slide -->
                                            <div class="swiper-slide">
                                                <div class="video__card">
                                                    <a href="<?php echo e(route('movie.details', ['slug' => $movie->slug])); ?>"
                                                        class="video__thumb">
                                                        <img src="<?php echo e(getFileLink('thumbnail', $movie->thumbnail, 'movies', '500x750')); ?>"
                                                            alt="movie" />
                                                        <div class="video__btn">
                                                            <i class="ri-play-fill"></i>
                                                        </div>
                                                    </a>
                                                    <?php if($movie->is_free == 1): ?>
                                                    <?php elseif($movie->is_rental == 1): ?>
                                                        <div class="badge bg-purple">
                                                            <?php echo e(__('rent:') . ' ' . get_currency($movie->rental_price)); ?>

                                                        </div>
                                                    <?php else: ?>
                                                        <div class="badge"> <?php echo e(__('premium')); ?> </div>
                                                    <?php endif; ?>
                                                    <div class="video__content">
                                                        <div class="content__left">
                                                            <a href="<?php echo e(route('movie.details', ['slug' => $movie->slug])); ?>"
                                                                class="title"><?php echo e($movie->title); ?></a>
                                                            <div class="video__meta">
                                                                <div class="meta__item">
                                                                    <?php echo e(date('Y', strtotime($movie->release))); ?>

                                                                </div>
                                                                <div class="meta__item">
                                                                    <?php echo e(get_rating($movie->imdb_rating)); ?></div>
                                                                <div class="meta__item"><?php echo e(runtime($movie->runtime)); ?>

                                                                </div>
                                                            </div>
                                                            <div class="video__tag">
                                                                <span><?php echo e(get_movie_genre($movie->genre)); ?></span>
                                                                <?php if(get_movie_category($movie->video_type)): ?>
                                                                    <span><?php echo e(get_movie_category($movie->video_type)); ?></span>
                                                                <?php endif; ?>
                                                                <span><?php echo e(get_movie_quality($movie->video_quality)); ?></span>
                                                            </div>
                                                        </div>
                                                        <div class="content__right">
                                                            <div class="action__btn">
                                                                <a href="javascript:void(0)" class="share__btn share-btn"
                                                                    data-bs-toggle="modal" data-bs-placement="bottom"
                                                                    data-url="<?php echo e(route('movie.details', ['slug' => $movie->slug])); ?>"
                                                                    data-bs-target="#shareModal"
                                                                    title="<?php echo e(__('share')); ?>"><i
                                                                        class="ri-share-line"></i></a>
                                                                <a href="javascript:void(0)"
                                                                    data-movie-id="<?php echo e($movie->id); ?>"
                                                                    class="open-save-playlist-modal add__btn"
                                                                    title="<?php echo e(__('add_playlist')); ?>"><i
                                                                        class="ri-add-line"></i></a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                                <div class="swiper__navigation">
                                    <div class="movie-swipe-prev swiper-button-prev">
                                        <i class="ri-arrow-left-s-line"></i>
                                    </div>
                                    <div class="movie-swipe-next swiper-button-next">
                                        <i class="ri-arrow-right-s-line"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Video Section End -->
    <?php endif; ?>

    <?php if(count($top_view_today) > 0): ?>
        <!-- Video Section Start -->
        <section class="video__section">
            <div class="inner__section py-30">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="section__title">
                                <h2 class="title"><?php echo e(__('top_view_today')); ?></h2>
                                <div class="view__btn">
                                    <a href="<?php echo e(route('all.movies', ['type' => 'top-view'])); ?>"> <?php echo e(__('view_all')); ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class="position-relative">
                                <div class="swiper movie__slider">
                                    <div class="swiper-wrapper">
                                        <?php $__currentLoopData = $top_view_today; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <!-- Slide -->
                                            <div class="swiper-slide">
                                                <div class="video__card">
                                                    <a href="<?php echo e(route('movie.details', ['slug' => $movie->slug])); ?>"
                                                        class="video__thumb">
                                                        <img src="<?php echo e(getFileLink('thumbnail', $movie->thumbnail, 'movies', '500x750')); ?>"
                                                            alt="movie" />
                                                        <div class="video__btn">
                                                            <i class="ri-play-fill"></i>
                                                        </div>
                                                    </a>
                                                    <?php if($movie->is_free == 1): ?>
                                                    <?php elseif($movie->is_rental == 1): ?>
                                                        <div class="badge bg-purple">
                                                            <?php echo e(__('rent:') . ' ' . get_currency($movie->rental_price)); ?>

                                                        </div>
                                                    <?php else: ?>
                                                        <div class="badge"> <?php echo e(__('premium')); ?> </div>
                                                    <?php endif; ?>
                                                    <div class="video__content">
                                                        <div class="content__left">
                                                            <a href="<?php echo e(route('movie.details', ['slug' => $movie->slug])); ?>"
                                                                class="title"><?php echo e($movie->title); ?></a>
                                                            <div class="video__meta">
                                                                <div class="meta__item">
                                                                    <?php echo e(date('Y', strtotime($movie->release))); ?>

                                                                </div>
                                                                <div class="meta__item">
                                                                    <?php echo e(get_rating($movie->imdb_rating)); ?></div>
                                                                <div class="meta__item"><?php echo e(runtime($movie->runtime)); ?>

                                                                </div>
                                                            </div>
                                                            <div class="video__tag">
                                                                <span><?php echo e(get_movie_genre($movie->genre)); ?></span>
                                                                <?php if(get_movie_category($movie->video_type)): ?>
                                                                    <span><?php echo e(get_movie_category($movie->video_type)); ?></span>
                                                                <?php endif; ?>
                                                                <span><?php echo e(get_movie_quality($movie->video_quality)); ?></span>
                                                            </div>
                                                        </div>
                                                        <div class="content__right">
                                                            <div class="action__btn">
                                                                <a href="javascript:void(0)" class="share__btn share-btn"
                                                                    data-bs-toggle="modal" data-bs-placement="bottom"
                                                                    data-url="<?php echo e(route('movie.details', ['slug' => $movie->slug])); ?>"
                                                                    data-bs-target="#shareModal"
                                                                    title="<?php echo e(__('share')); ?>"><i
                                                                        class="ri-share-line"></i></a>
                                                                <a href="javascript:void(0)"
                                                                    data-movie-id="<?php echo e($movie->id); ?>"
                                                                    class="open-save-playlist-modal add__btn"
                                                                    title="<?php echo e(__('add_playlist')); ?>"><i
                                                                        class="ri-add-line"></i></a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                                <div class="swiper__navigation">
                                    <div class="movie-swipe-prev swiper-button-prev">
                                        <i class="ri-arrow-left-s-line"></i>
                                    </div>
                                    <div class="movie-swipe-next swiper-button-next">
                                        <i class="ri-arrow-right-s-line"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Video Section End -->
    <?php endif; ?>

    <?php if(count($top_rating_movies) > 0): ?>
        <!-- Video Section Start -->
        <section class="video__section">
            <div class="inner__section py-30">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="section__title">
                                <h2 class="title"><?php echo e(__('top_rating')); ?></h2>
                                <div class="view__btn">
                                    <a
                                        href="<?php echo e(route('all.movies', ['type' => 'top-rating'])); ?>"><?php echo e(__('view_all')); ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class="position-relative">
                                <div class="swiper movie__slider">
                                    <div class="swiper-wrapper">
                                        <?php $__currentLoopData = $top_rating_movies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <!-- Slide -->
                                            <div class="swiper-slide">
                                                <div class="video__card">
                                                    <a href="<?php echo e(route('movie.details', ['slug' => $movie->slug])); ?>"
                                                        class="video__thumb">
                                                        <img src="<?php echo e(getFileLink('thumbnail', $movie->thumbnail, 'movies', '500x750')); ?>"
                                                            alt="movie" />
                                                        <div class="video__btn">
                                                            <i class="ri-play-fill"></i>
                                                        </div>
                                                    </a>
                                                    <?php if($movie->is_free == 1): ?>
                                                    <?php elseif($movie->is_rental == 1): ?>
                                                        <div class="badge bg-purple">
                                                            <?php echo e(__('rent:') . ' ' . get_currency($movie->rental_price)); ?>

                                                        </div>
                                                    <?php else: ?>
                                                        <div class="badge"> <?php echo e(__('premium')); ?> </div>
                                                    <?php endif; ?>
                                                    <div class="video__content">
                                                        <div class="content__left">
                                                            <a href="<?php echo e(route('movie.details', ['slug' => $movie->slug])); ?>"
                                                                class="title"><?php echo e($movie->title); ?></a>
                                                            <div class="video__meta">
                                                                <div class="meta__item">
                                                                    <?php echo e(date('Y', strtotime($movie->release))); ?>

                                                                </div>
                                                                <div class="meta__item">
                                                                    <?php echo e(get_rating($movie->imdb_rating)); ?></div>
                                                                <div class="meta__item"><?php echo e(runtime($movie->runtime)); ?>

                                                                </div>
                                                            </div>
                                                            <div class="video__tag">
                                                                <span><?php echo e(get_movie_genre($movie->genre)); ?></span>
                                                                <?php if(get_movie_category($movie->video_type)): ?>
                                                                    <span><?php echo e(get_movie_category($movie->video_type)); ?></span>
                                                                <?php endif; ?>
                                                                <span><?php echo e(get_movie_quality($movie->video_quality)); ?></span>
                                                            </div>
                                                        </div>
                                                        <div class="content__right">
                                                            <div class="action__btn">
                                                                <a href="javascript:void(0)" class="share__btn share-btn"
                                                                    data-bs-toggle="modal" data-bs-placement="bottom"
                                                                    data-url="<?php echo e(route('movie.details', ['slug' => $movie->slug])); ?>"
                                                                    data-bs-target="#shareModal"
                                                                    title="<?php echo e(__('share')); ?>"><i
                                                                        class="ri-share-line"></i></a>
                                                                <a href="javascript:void(0)"
                                                                    data-movie-id="<?php echo e($movie->id); ?>"
                                                                    class="open-save-playlist-modal add__btn"
                                                                    title="<?php echo e(__('add_playlist')); ?>"><i
                                                                        class="ri-add-line"></i></a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                                <div class="swiper__navigation">
                                    <div class="movie-swipe-prev swiper-button-prev">
                                        <i class="ri-arrow-left-s-line"></i>
                                    </div>
                                    <div class="movie-swipe-next swiper-button-next">
                                        <i class="ri-arrow-right-s-line"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Video Section End -->
    <?php endif; ?>

    <?php if(count($trending_movies)): ?>
        <!-- Video Section Start -->
        <section class="video__section">
            <div class="inner__section py-30">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="section__title">
                                <h2 class="title"><?php echo e(__('trending_movies')); ?></h2>
                                <div class="view__btn">
                                    <a href="<?php echo e(route('all.movies', ['type' => 'trending'])); ?>"><?php echo e(__('view_all')); ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class="position-relative">
                                <div class="swiper movie__slider">
                                    <div class="swiper-wrapper">
                                        <?php $__currentLoopData = $trending_movies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <!-- Slide -->
                                            <div class="swiper-slide">
                                                <div class="video__card">
                                                    <a href="<?php echo e(route('movie.details', ['slug' => $movie->slug])); ?>"
                                                        class="video__thumb">
                                                        <img src="<?php echo e(getFileLink('thumbnail', $movie->thumbnail, 'movies', '500x750')); ?>"
                                                            alt="movie" />
                                                        <div class="video__btn">
                                                            <i class="ri-play-fill"></i>
                                                        </div>
                                                    </a>
                                                    <?php if($movie->is_free == 1): ?>
                                                    <?php elseif($movie->is_rental == 1): ?>
                                                        <div class="badge bg-purple">
                                                            <?php echo e(__('rent:') . ' ' . get_currency($movie->rental_price)); ?>

                                                        </div>
                                                    <?php else: ?>
                                                        <div class="badge"> <?php echo e(__('premium')); ?> </div>
                                                    <?php endif; ?>
                                                    <div class="video__content">
                                                        <div class="content__left">
                                                            <a href="<?php echo e(route('movie.details', ['slug' => $movie->slug])); ?>"
                                                                class="title"><?php echo e($movie->title); ?></a>
                                                            <div class="video__meta">
                                                                <div class="meta__item">
                                                                    <?php echo e(date('Y', strtotime($movie->release))); ?>

                                                                </div>
                                                                <div class="meta__item">
                                                                    <?php echo e(get_rating($movie->imdb_rating)); ?></div>
                                                                <div class="meta__item"><?php echo e(runtime($movie->runtime)); ?>

                                                                </div>
                                                            </div>
                                                            <div class="video__tag">
                                                                <span><?php echo e(get_movie_genre($movie->genre)); ?></span>
                                                                <?php if(get_movie_category($movie->video_type)): ?>
                                                                    <span><?php echo e(get_movie_category($movie->video_type)); ?></span>
                                                                <?php endif; ?>
                                                                <span><?php echo e(get_movie_quality($movie->video_quality)); ?></span>
                                                            </div>
                                                        </div>
                                                        <div class="content__right">
                                                            <div class="action__btn">
                                                                <a href="javascript:void(0)" class="share__btn share-btn"
                                                                    data-bs-toggle="modal" data-bs-placement="bottom"
                                                                    data-url="<?php echo e(route('movie.details', ['slug' => $movie->slug])); ?>"
                                                                    data-bs-target="#shareModal"
                                                                    title="<?php echo e(__('share')); ?>"><i
                                                                        class="ri-share-line"></i></a>
                                                                <a href="javascript:void(0)"
                                                                    data-movie-id="<?php echo e($movie->id); ?>"
                                                                    class="open-save-playlist-modal add__btn"
                                                                    title="<?php echo e(__('add_playlist')); ?>"><i
                                                                        class="ri-add-line"></i></a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                                <div class="swiper__navigation">
                                    <div class="movie-swipe-prev swiper-button-prev">
                                        <i class="ri-arrow-left-s-line"></i>
                                    </div>
                                    <div class="movie-swipe-next swiper-button-next">
                                        <i class="ri-arrow-right-s-line"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Video Section End -->
    <?php endif; ?>

    <?php if(count($reality_shows)): ?>
        <!-- Video Section Start -->
        <section class="video__section">
            <div class="inner__section py-30">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="section__title">
                                <h2 class="title"><?php echo e(__('latest_reality_shows')); ?></h2>
                                <div class="view__btn">
                                    <a
                                        href="<?php echo e(route('all.tv.series', ['type' => 'recommended'])); ?>"><?php echo e(__('view_all')); ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class="position-relative">
                                <div class="swiper tvShow__slider">
                                    <div class="swiper-wrapper">
                                        <?php $__currentLoopData = $reality_shows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $show): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <!-- Slide -->
                                            <div class="swiper-slide">
                                                <div class="video__card">
                                                    <a href="<?php echo e(route('series.details', ['slug' => $show->slug])); ?>"
                                                        class="video__thumb">
                                                        <img src="<?php echo e(getFileLink('thumbnail', $show->thumbnail, 'tv_shows', '500x750')); ?>"
                                                            alt="movie" />
                                                        <div class="video__btn">
                                                            <i class="ri-play-fill"></i>
                                                        </div>
                                                    </a>
                                                    <?php if($show->is_free == 1): ?>
                                                    <?php elseif($show->is_rental == 1): ?>
                                                        <div class="badge bg-purple">
                                                            <?php echo e(__('rent:') . ' ' . get_currency($show->rental_price)); ?>

                                                        </div>
                                                    <?php else: ?>
                                                        <div class="badge"> <?php echo e(__('premium')); ?> </div>
                                                    <?php endif; ?>
                                                    <div class="video__content">
                                                        <div class="content__left">
                                                            <a href="<?php echo e(route('series.details', ['slug' => $show->slug])); ?>"
                                                                class="title"><?php echo e($show->title); ?></a>
                                                            <div class="video__meta">
                                                                <div class="meta__item">
                                                                    <?php echo e(date('Y', strtotime($show->release))); ?>

                                                                </div>
                                                                <?php if($show->rating): ?>
                                                                    <div class="meta__item">
                                                                        <?php echo e(get_rating($show->rating)); ?></div>
                                                                <?php endif; ?>
                                                                <div class="meta__item"><?php echo e(runtime($movie->runtime)); ?>

                                                                </div>
                                                            </div>
                                                            <div class="video__tag">
                                                                <span><?php echo e(get_movie_genre($show->genre)); ?></span>
                                                                <?php if(get_movie_category($show->video_type)): ?>
                                                                    <span><?php echo e(get_movie_category($show->video_type)); ?></span>
                                                                <?php endif; ?>
                                                                <span><?php echo e(get_movie_quality($show->video_quality)); ?></span>
                                                            </div>
                                                        </div>
                                                        <div class="content__right">
                                                            <div class="action__btn">
                                                                <a href="javascript:void(0)" class="share__btn share-btn"
                                                                    data-bs-toggle="modal" data-bs-placement="bottom"
                                                                    data-url="<?php echo e(route('series.details', ['slug' => $show->slug])); ?>"
                                                                    data-bs-target="#shareModal"
                                                                    title="<?php echo e(__('share')); ?>"><i
                                                                        class="ri-share-line"></i></a>
                                                                <a href="javascript:void(0)"
                                                                    data-movie-id="<?php echo e($show->id); ?>"
                                                                    class="open-save-playlist-modal add__btn"
                                                                    title="<?php echo e(__('add_playlist')); ?>"><i
                                                                        class="ri-add-line"></i></a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                                <div class="swiper__navigation">
                                    <div class="tvShow-swipe-prev swiper-button-prev">
                                        <i class="ri-arrow-left-s-line"></i>
                                    </div>
                                    <div class="tvShow-swipe-next swiper-button-next">
                                        <i class="ri-arrow-right-s-line"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Video Section Start -->
    <?php endif; ?>

    <?php if(count($feature_tv_channels)): ?>
        <!-- Channel Section Start -->
        <section class="channel__section py-30">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="section__title">
                            <h2 class="title"><?php echo e(__('featured_tv_channels')); ?></h2>
                            <div class="view__btn">
                                <a href="<?php echo e(route('tv.channels')); ?>"><?php echo e(__('view_all')); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="position-relative">
                            <div class="swiper channel__slider">
                                <div class="swiper-wrapper">
                                    <?php $__currentLoopData = $feature_tv_channels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $channel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <!-- Slide -->
                                        <div class="swiper-slide">
                                            <a href="<?php echo e(route('live.tv.details', ['slug' => $channel->slug])); ?>"
                                                class="channel__card">
                                                <div class="card__thumb">
                                                    <img src="<?php echo e(getFileLink('live_tv', $channel->thumbnail, 'live_tv_thumbs', '400x320')); ?>"
                                                        alt="channel" />
                                                </div>
                                            </a>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <div class="swiper__navigation">
                                <div class="channel-swipe-prev swiper-button-prev">
                                    <i class="ri-arrow-left-s-line"></i>
                                </div>
                                <div class="channel-swipe-next swiper-button-next">
                                    <i class="ri-arrow-right-s-line"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Channel Section End -->
    <?php endif; ?>

    <?php if(count($latest_tv_series)): ?>
        <!-- Series Section Start -->
        <section class="series__section py-30">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="section__title">
                            <h2 class="title"><?php echo e(__('latest_tv_series')); ?></h2>
                            <div class="view__btn">
                                <a href="<?php echo e(route('all.tv.series', ['type' => 'latest'])); ?>"><?php echo e(__('view_all')); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="grid-4">
                            <?php $__currentLoopData = $latest_tv_series; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tv_series): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    if ($key == 7) {
                                        break;
                                    }
                                ?>
                                <a href="<?php echo e(route('series.details', ['slug' => $tv_series->slug])); ?>"
                                    class="series__card <?php echo e($key == 0 ? 'featured' : ''); ?>">
                                    <?php if($tv_series->is_free == 1): ?>
                                    <?php elseif($tv_series->is_rental == 1): ?>
                                        <div class="badge bg-purple">
                                            <?php echo e(__('rent:') . ' ' . get_currency($tv_series->rental_price)); ?> </div>
                                    <?php else: ?>
                                        <div class="badge"> <?php echo e(__('premium')); ?> </div>
                                    <?php endif; ?>
                                    <div class="card__thumb">
                                        <img src="<?php echo e(str_replace('w342', 'w500', getFileLink('thumbnail', $key == 0 ? $tv_series->thumbnail : $tv_series->poster, 'tv_shows', '500x750'))); ?>" alt="series" />
                                    </div>
                                    <div class="card__content">
                                        <h4 class="title"><?php echo e($tv_series->title); ?></h4>
                                        <p class="desc"><?php echo e($tv_series->seo_title); ?></p>
                                    </div>
                                </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Series Section End -->
    <?php endif; ?>

    <!-- Feature Section Start -->
    <section class="feature__section"
        style="background-image: url(<?php echo e(getFileLink('original_image', get_config('promotion'), 'settingss', '1700x275')); ?>);">
        <div class="container-fluid">
            <div class="row justify-content-center align-items-center">
                <?php
                    $leftAd = get_ads('home_page_promotional_left', '300x250', 'object'); // Get the full ad object/array
                ?>

                <?php if($leftAd): ?>
                    <div class="col-xl-4 col-lg-12">
                        <div class="ads__area">
                            <?php if($leftAd->type == 'google'): ?>
                                
                                <div class="ads__google">
                                    <?php echo $leftAd->google_ads_code; ?>

                                </div>
                            <?php elseif($leftAd->type == 'mp4'): ?>
                                
                                <video class="ads__video" width="300" height="250" autoplay loop muted>
                                    <source src="<?php echo e($leftAd->video_link); ?>" type="video/mp4">
                                </video>
                            <?php elseif($leftAd->type == 'local'): ?>
                                
                                <a href="<?php echo e($leftAd->url ?? '#'); ?>" class="ads__square">
                                    <img src="<?php echo e($leftAd->image_url); ?>" alt="ads" />
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if(get_config('promo_movie')): ?>
                    <?php
                        $promo_movie = get_config('promo_movie');
                        $movie = App\Models\Movie::where('id', $promo_movie)->first();
                    ?>
                    <?php if($movie): ?>
                        <div class="col-xl-4 col-lg-12">
                            <div class="feature__wrapper">
                                <?php if($movie->is_free == 1): ?>
                                <?php elseif($movie->is_rental == 1): ?>
                                    <div class="badge bg-purple">
                                        <?php echo e(__('rent:') . ' ' . get_currency($movie->rental_price)); ?> </div>
                                <?php else: ?>
                                    <div class="badge"> <?php echo e(__('premium')); ?> </div>
                                <?php endif; ?>
                                <h4 class="subtitle"><?php echo e($movie->seo_title ?? $movie->title); ?></h4>
                                <h2 class="title"><?php echo e($movie->title); ?></h2>
                                <?php if($movie->season): ?>
                                    <p class="season"><?php echo e(__('season')); ?> - <?php echo e($movie->season); ?></p>
                                <?php endif; ?>
                                <a class="btn btn-white" href="<?php echo e(route('movie.details', ['slug' => $movie->slug])); ?>">
                                    <i class="ri-play-fill"></i><?php echo e(__('watch_now')); ?>

                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
                <?php
                    $rightAd = get_ads('home_page_promotional_right', '300x250', 'object'); // Get the full ad object/array
                ?>
                <?php if($rightAd): ?>
                    <div class="col-xl-4 col-lg-12">
                        <div class="ads__area">
                            <?php if($rightAd->type == 'google'): ?>
                                
                                <div class="ads__google">
                                    <?php echo $rightAd->google_ads_code; ?>

                                </div>
                            <?php elseif($rightAd->type == 'mp4'): ?>
                                
                                <video width="300" height="250" autoplay muted loop playsinline>
                                    <source src="<?php echo e($rightAd->video_link); ?>" type="video/mp4">
                                </video>
                            <?php elseif($rightAd->type == 'local'): ?>
                                
                                <a href="<?php echo e($rightAd->url ?? '#'); ?>" class="ads__square">
                                    <img src="<?php echo e($rightAd->image_url); ?>" alt="ads" />
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <!-- Feature Section End -->

    <?php if(count($artists) > 0): ?>
        <!-- Artist Section Start -->
        <section class="artist__section py-30">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="section__title">
                            <h2 class="title"><?php echo e(__('top_artists')); ?></h2>
                            
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="grid-7">
                            <?php $__currentLoopData = $artists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $artist): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a href="<?php echo e(route('artist.details',['slug'=>$artist->slug])); ?>" class="artist__card">
                                    <div class="card__thumb">
                                        <img src="<?php echo e(str_replace('w154', 'w500', getFileLink('original_image', $artist->star_image, 'stars', '500x500', 'original'))); ?>"
                                            alt="artist" />
                                    </div>
                                    <div class="card__content">
                                        <h4 class="title"><?php echo e($artist->star_name); ?></h4>
                                    </div>
                                </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Artist Section End -->
    <?php endif; ?>

    <?php if(count($recommended_movies) > 0): ?>
        <!-- Recommended Section Start -->
        <div class="recommended__section py-30">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="section__title">
                            <h2 class="title"><?php echo e(__('recommended_for_you')); ?></h2>
                            <div class="view__btn">
                                <a href="<?php echo e(route('all.movies', ['type' => 'recommended'])); ?>"><?php echo e(__('view_all')); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="position-relative grid-6">
                            <?php $__currentLoopData = $recommended_movies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <!-- Video Card -->
                                <div class="video__card">
                                    <a href="<?php echo e(route('movie.details', ['slug' => $movie->slug])); ?>"
                                        class="video__thumb">
                                        <img src="<?php echo e(getFileLink('thumbnail', $movie->thumbnail, 'movies', '500x750')); ?>"
                                            alt="movie" />
                                        <div class="video__btn">
                                            <i class="ri-play-fill"></i>
                                        </div>
                                    </a>
                                    <?php if($movie->is_free == 1): ?>
                                    <?php elseif($movie->is_rental == 1): ?>
                                        <div class="badge bg-purple">
                                            <?php echo e(__('rent:') . ' ' . get_currency($movie->rental_price)); ?> </div>
                                    <?php else: ?>
                                        <div class="badge"> <?php echo e(__('premium')); ?> </div>
                                    <?php endif; ?>

                                    <div class="video__content">
                                        <div class="content__left">
                                            <a href="<?php echo e(route('movie.details', ['slug' => $movie->slug])); ?>"
                                                class="title"><?php echo e($movie->title); ?></a>
                                            <div class="video__meta">
                                                <div class="meta__item"><?php echo e(date('Y', strtotime($movie->release))); ?></div>
                                                <div class="meta__item"><?php echo e(get_rating($movie->imdb_rating)); ?></div>
                                                <div class="meta__item"><?php echo e(runtime($movie->runtime)); ?></div>
                                            </div>
                                            <div class="video__tag">
                                                <span><?php echo e(get_movie_genre($movie->genre)); ?></span>
                                                <?php if(get_movie_category($movie->video_type)): ?>
                                                    <span><?php echo e(get_movie_category($movie->video_type)); ?></span>
                                                <?php endif; ?>
                                                <span><?php echo e(get_movie_quality($movie->video_quality)); ?></span>
                                            </div>
                                        </div>
                                        <div class="content__right">
                                            <div class="action__btn">
                                                <a href="javascript:void(0)" class="share__btn share-btn"
                                                    data-bs-toggle="modal" data-bs-placement="bottom"
                                                    data-url="<?php echo e(route('movie.details', ['slug' => $movie->slug])); ?>"
                                                    data-bs-target="#shareModal" title="<?php echo e(__('share')); ?>"><i
                                                        class="ri-share-line"></i></a>
                                                <a href="javascript:void(0)" data-movie-id="<?php echo e($movie->id); ?>"
                                                    class="open-save-playlist-modal add__btn"
                                                    title="<?php echo e(__('add_playlist')); ?>"><i class="ri-add-line"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Recommended Section End -->
    <?php endif; ?>

    <?php if(count($latest_blogs)): ?>
        <!-- Blog Section Start -->
        <section class="blog__section pb-80 pt-30">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="section__title">
                            <h2 class="title"><?php echo e(__('latest_blog')); ?></h2>
                            <div class="view__btn">
                                <a href="<?php echo e(route('blogs')); ?>"><?php echo e(__('view_all')); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="grid-5">
                            <?php $__currentLoopData = $latest_blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="blogCard">
                                    <div class="badge"> <?php echo e(__('top_news')); ?> </div>
                                    <a href="<?php echo e(route('blog.details', ['slug' => $blog->slug])); ?>"
                                        class="blogCard__thumb">
                                        <img src="<?php echo e(getFileLink('blog', $blog->image, 'blogs', '240x240')); ?>"
                                            alt="blog" />
                                    </a>
                                    <div class="blogCard__content">
                                        <h4 class="title">
                                            <a href="<?php echo e(route('blog.details', ['slug' => $blog->slug])); ?>">
                                                <?php echo e($blog->title); ?> </a>
                                        </h4>
                                        <p class="desc"> <?php echo e($blog->meta_description); ?> </p>
                                        <div class="blogCard__meta">
                                            <span><i class="ri-calendar-2-line"></i>
                                                <?php echo e(date('d M Y', strtotime($blog->created_at))); ?>

                                            </span>
                                            <a href="javascript:void(0)"><i class="ri-user-3-line"></i>
                                                <?php echo e(adminInfo('first_name') . ' ' . adminInfo('last_name')); ?> </a>
                                            <a href="javascript:void(0)"><i class="ri-film-line"></i>
                                                <?php echo e($blog->category?->title); ?>

                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Blog Section End -->
    <?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('website.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/savadata/check.belovevn.com/public/resources/views/website/index.blade.php ENDPATH**/ ?>