<?php
    // Determine if this is a detail page and get the meta source
    $isDetail = request()->is('movie-details/*') ||
                request()->is('tv-shows-details/*') ||
                request()->is('tv-season-details/*') ||
                request()->is('tv-episode-details/*') ||
                request()->is('blog-details/*');

    $meta = null;
    if ($isDetail) {
        if (isset($movie)) {
            $meta = $movie;
        } elseif (isset($tv_show)) {
            $meta = $tv_show;
        } elseif (isset($blog)) {
            $meta = $blog;
        } elseif (isset($tv_season)) {
            $meta = $tv_season;
        } elseif (isset($tv_episode)) {
            $meta = $tv_episode;
        } elseif (isset($tv_channel)) {
            $meta = $tv_channel;
        }
    }
?>

<?php if($isDetail && $meta): ?>
    <!-- SEO -->
    <meta name="title" content="<?php echo e($meta->seo_title ?? $meta->title ?? get_config('meta_title')); ?>" />
    <meta name="description" content="<?php echo e($meta->meta_description ?? get_config('meta_description')); ?>" />
    <meta name="keywords" content="<?php echo e($meta->focus_keyword ?? get_config('meta_keywords')); ?>" />
    <meta name="author" content="<?php echo e(get_config('author_name')); ?>">
    <!-- END SEO -->

    <!-- Open Graph -->
    <meta property="og:title" content="<?php echo e($meta->seo_title ?? $meta->title ?? get_config('og_title')); ?>" />
    <meta property="og:description" content="<?php echo e($meta->meta_description ?? get_config('meta_description')); ?>" />
    <meta property="og:url" content="<?php echo e(url()->current()); ?>" />
    <meta property="og:type" content="website" />
    <meta property="og:locale" content="<?php echo e(app()->getLocale()); ?>" />
    <meta property="og:site_name" content="<?php echo e(get_config('system_name')); ?>" />
    <meta property="og:image" content="
        <?php if(request()->is('blog-details/*')): ?>
            <?php echo e(getFileLink('original_image', $meta->image ?? '', 'blogs', '1200x630', 'original')); ?>

        <?php else: ?>
            <?php echo e(getFileLink('original_image', $meta->thumbnail ?? '', 'movies', '1200x630', 'original')); ?>

        <?php endif; ?>
    " />
    <meta property="og:image:width" content="1200" />
    <meta property="og:image:height" content="630" />
    <!-- END Open Graph -->

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:site" content="<?php echo e(get_config('system_name')); ?>" />
    <meta name="twitter:creator" content="<?php echo e(get_config('author_name')); ?>" />
    <meta name="twitter:title" content="<?php echo e($meta->seo_title ?? $meta->title ?? get_config('meta_title')); ?>" />
    <meta name="twitter:description" content="<?php echo e($meta->meta_description ?? get_config('meta_description')); ?>" />
    <meta name="twitter:image" content="
        <?php if(request()->is('blog-details/*')): ?>
            <?php echo e(getFileLink('original_image', $meta->image ?? '', 'blogs', '1200x630', 'original')); ?>

        <?php else: ?>
            <?php echo e(getFileLink('original_image', $meta->thumbnail ?? '', 'movies', '1200x630', 'original')); ?>

        <?php endif; ?>
    " />
<?php else: ?>
    <!-- SEO -->
    <meta name="title" content="<?php echo e(get_config('meta_title')); ?>" />
    <meta name="description" content="<?php echo e(get_config('meta_description')); ?>" />
    <meta name="keywords" content="<?php echo e(get_config('meta_keywords')); ?>" />
    <meta name="author" content="<?php echo e(get_config('author_name')); ?>">
    <!-- END SEO -->

    <!-- Open Graph -->
    <meta property="og:title" content="<?php echo e(get_config('og_title')); ?>" />
    <meta property="og:description" content="<?php echo e(get_config('meta_description')); ?>" />
    <meta property="og:url" content="<?php echo e(url('/')); ?>" />
    <meta property="og:type" content="website" />
    <meta property="og:locale" content="<?php echo e(app()->getLocale()); ?>" />
    <meta property="og:site_name" content="<?php echo e(get_config('system_name')); ?>" />
    <meta property="og:image" content="<?php echo e(getFileLink('original_image', get_config('og_image'), 'og_images', '80x80')); ?>" />
    <meta property="og:image:width" content="1200" />
    <meta property="og:image:height" content="630" />
    <!-- END Open Graph -->

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:site" content="<?php echo e(get_config('system_name')); ?>" />
    <meta name="twitter:creator" content="<?php echo e(get_config('author_name')); ?>" />
    <meta name="twitter:title" content="<?php echo e(get_config('meta_title')); ?>" />
    <meta name="twitter:description" content="<?php echo e(get_config('meta_description')); ?>" />
    <meta name="twitter:image" content="<?php echo e(getFileLink('original_image', get_config('og_image'), 'og_images', '80x80')); ?>" />
<?php endif; ?>
<?php /**PATH /home/savadata/check.belovevn.com/public/resources/views/website/component/meta.blade.php ENDPATH**/ ?>