<?php

use App\Http\Controllers\Admin\AiController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\Website\FrontendController;
use App\Http\Controllers\Website\MovieController;
use App\Http\Controllers\Website\ReviewController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\Admin\LanguageController;
use App\Http\Controllers\Website\PaymentController;
use App\Http\Controllers\Website\SubscriptionController;
use App\Http\Controllers\Website\TvSeriesController;
use App\Http\Controllers\Website\WatchHistoryController;
use App\Traits\OneSignalPushTrait;

Route::middleware(['xss', 'isInstalled'])->group(function () {

    Route::controller(FrontendController::class)->group(function () {
        Route::get('/', 'index')->name('home');

        // blog pages
        Route::get('/blogs', 'blogs')->name('blogs');
        Route::get('/post/{slug}', 'blog_details')->name('blog.details');

        // live tv channels
        Route::get('/live-tvs', 'tv_channels')->name('tv.channels');
        Route::get('/live-tv/{slug}', 'tv_channel_details')->name('live.tv.details');
        Route::get('/live-tv-category/{slug}', 'live_tv_category')->name('live.tv.category');


        Route::get('/episodes/{episode}/download-links', 'downloadLinks');

        // faq pages
        Route::get('/faqs', 'faqs')->name('faqs');
        Route::get('/contact-us', 'contactUs')->name('contact-us');
        Route::post('/contact-us', 'contactUsPost')->name('contact_us.store');

        Route::get('page/{link}', 'page')->name('page');

        Route::post('/load-player', 'loadPlayer')->name('load.player');

         // artist details
        Route::get('/artist-details/{slug?}', 'artist_details')->name('artist.details');
    });

    Route::controller(MovieController::class)->group(function () {
        Route::get('/movies', 'index')->name('movies');
        Route::get('/movie/{slug}', 'movie_details')->name('movie.details');

        // movie type wise listing page
        Route::get('/movies/{type?}', 'all_movies')->name('all.movies');
        // genre wise listing page
        Route::get('/genre/{slug?}', 'genre_wise_movie')->name('genre.wise.movie');
        // country wise listing page
        Route::get('/country/{slug?}', 'country_wise_movie')->name('country.wise.movie');
        
        // watch movie
        Route::get('/watch/movie/{slug}/{key?}', 'watch_movie')->name('watch.movie');        

    });
    Route::controller(TvSeriesController::class)->group(function () {

        // tv series type wise listing page
        Route::get('/tv-series', 'tv_series')->name('tv.series');
        Route::get('/tv-series/{type?}', 'all_tv_series')->name('all.tv.series');
        Route::get('/series/{slug}', 'series_details')->name('series.details');

        // watch movie
        Route::get('/watch/episode/{slug}', 'watch_episode')->name('watch.episode');

    });

    Route::controller(SubscriptionController::class)->group(function () {
        // payment page
        Route::get('/packages', 'packages')->name('packages');

        Route::middleware(['auth'])->group(function () {
            Route::get('/payment-gateway-list/{id}/{type?}/{video_type?}', 'payment_gateway_list')->name('payment.gateway.list');

            Route::post('stripe-redirect', [SubscriptionController::class, 'stripeRedirect'])->name('client.stripe.redirect');
            Route::get('stripe-success', [SubscriptionController::class, 'stripeSuccess'])->name('client.stripe.payment.success');
            
            Route::post('paypal-redirect', [SubscriptionController::class, 'paypalRedirect'])->name('client.paypal.redirect');
            Route::get('paypal-success', [SubscriptionController::class, 'paypalSuccess'])->name('paypal.payment.success');
            Route::post('paddle-redirect', [SubscriptionController::class, 'paddleRedirect'])->name('client.paddle.redirect');
            Route::match(['get', 'post'], 'paddle-success', [SubscriptionController::class, 'paddleSuccess'])->name('paddle.payment.success');
            Route::post('razor_pay-redirect', [SubscriptionController::class, 'razorPayRedirect'])->name('client.razor.pay.redirect');
            Route::match(['post', 'get'], 'client/razor_pay-success', [SubscriptionController::class, 'razorPaySuccess'])->name('razor.pay.payment.success');
            Route::post('mercadopago-redirect', [SubscriptionController::class, 'mercadopagoRedirect'])->name('client.mercadopago.redirect');
            Route::match(['post', 'get'], 'client.mercadopago-success', [SubscriptionController::class, 'client.mercadopagoSuccess']);

            Route::post('offline-claim', [SubscriptionController::class, 'offlineClaim'])->name('client.offline.claim');
        });

    });

});

    Route::middleware(['auth'])->group(function () {
        Route::post('/watch-history', [WatchHistoryController::class, 'store'])->name('watch.history.store');
        Route::get('/watch-history', [WatchHistoryController::class, 'index'])->name('watch.history.index');
        Route::get('/load-more-history', [WatchHistoryController::class, 'loadMore'])->name('load.more.history');
    });
    
    Route::post('/review/{id}/like', [ReviewController::class, 'toggleLike'])->name('review.like');
    
    Route::post('/movie-request', [FrontendController::class, 'storeMovieRequest'])->name('movie.request.store');
    Route::post('/movie-report', [FrontendController::class, 'movieReport'])->name('movie.report');
    
    Route::get('/cache-clear', function () {
        Artisan::call('cache:clear');
        Artisan::call('config:clear');
        Artisan::call('route:clear');
        Artisan::call('view:clear');
        return redirect()->back()->with('toastr_success', 'Cache Cleared Successfully!');
    })->name('cache.clear');
    
    Route::middleware(['auth'])->group(function () {
        Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
        Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
        Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    
        Route::post('/movies/{movie}/review', [ReviewController::class, 'storeMovieReview'])->name('review.store.movie');
        Route::post('/tvshows/{tvShow}/review', [ReviewController::class, 'storeTvShowReview'])->name('review.store.tvshow');
        Route::post('/tvchannel/{liveTv}/review', [ReviewController::class, 'storeTvChannelReview'])->name('review.store.tv_channel');
        Route::post('/blogs/{blog}/review', [ReviewController::class, 'storeBlogReview'])->name('review.store.blog');
    });
    Route::get('/change-language/{language}', [LanguageController::class, 'changeLanguage'])->name('admin.change.language');

    Route::get('/ai-content-generate', [AiController::class, 'content_generate'])->name('ai-helper');



require __DIR__ . '/auth.php';
