<?php

use App\Http\Controllers\User\FavoriteController;
use App\Http\Controllers\User\UserController;
use App\Http\Controllers\User\PlayListController;
use App\Http\Controllers\Website\SubscriptionController;
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'user', 'middleware' => ['auth', 'verified']], function () {
    Route::get('/dashboard/{tab?}', [UserController::class, 'index'])->name('user.dashboard');
    Route::resource('playlists', PlayListController::class)->except('index', 'edit');
    Route::get('playlists/{playlist}/{slug}', [PlayListController::class, 'show'])->name('playlist.movie');
    Route::post('playlist/add-movie', [PlayListController::class, 'addMovieToPlaylist'])->name('playlist.addmovie');
    Route::post('playlist/remove-movie', [PlayListController::class, 'removeMovieFromPlaylist'])->name('remove.move.from.playlist');
    Route::get('get-playlist-ids/{movie}', [PlayListController::class, 'getPlayListIds'])->name('get.playlist.ids');
    Route::post('/favorite/toggle', [FavoriteController::class, 'toggleFavorite'])->name('favorite.toggle');
    Route::get('favorites', [FavoriteController::class, 'getFavorites'])->name('favorite.list');
    Route::post('/update-user-details', [UserController::class, 'update'])->name('update.user.details');

    Route::get('cancel-subscription/{id}', [SubscriptionController::class, 'cancelSubscription'])->name('cancel.subscription');    
});