<?php

use App\Http\Controllers\Api\Mobile\AuthController;
use App\Http\Controllers\Api\Mobile\BlogController;
use App\Http\Controllers\Api\Mobile\FavoriteController;
use App\Http\Controllers\Api\Mobile\InterestController;
use App\Http\Controllers\Api\Mobile\LiveTvController;
use App\Http\Controllers\Api\Mobile\MovieController;
use App\Http\Controllers\Api\Mobile\PaymentController;
use App\Http\Controllers\Api\Mobile\PageController;
use App\Http\Controllers\Api\Mobile\PlayListController;
use App\Http\Controllers\Api\Mobile\RentController;
use App\Http\Controllers\Api\Mobile\ReviewController;
use App\Http\Controllers\Api\Mobile\SettingController;
use App\Http\Controllers\Api\Mobile\StarController;
use App\Http\Controllers\Api\Mobile\TvShowController;
use App\Http\Controllers\Api\Mobile\WatchHistoryController;
use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Http\Request;

RateLimiter::for('login', function (Request $request) {
    return Limit::perMinute(5)->by($request->ip());
});

Route::group(['middleware' => ['mobileApi']], function () {

    Route::controller(AuthController::class)->group(function () {
        Route::post('/signup', 'signup');
        Route::post('/login', 'login')->middleware(['throttle:3,1']);
        Route::post('/social-login', 'socialLogin');
        Route::post('/phone-login', 'phone_login');
        Route::post('/forgot-password', 'forgot_password');
        Route::post('/otp-verify', 'otp_verify');
        Route::post('/update-password', 'update_password');
    });
    Route::controller(InterestController::class)->group(function () {
        Route::get('/interest', 'interest');
        Route::post('/interest-store', 'store');
    });

    Route::controller(PageController::class)->group(function () {
        Route::get('/home', 'home');
        Route::get('/all-genre', 'allGenre');

        Route::post('contact-us', 'contactUsPost');
        Route::get('global-search', 'globalSearch');
        Route::get('faqs', 'faqs');
    });

    Route::controller(StarController::class)->group(function () {
        Route::get('/artists', 'artists');
        Route::get('/artist-details', 'artist_details');
        Route::post('/artist-filter', 'artist_filter');
    });

    Route::controller(BlogController::class)->group(function () {
        Route::get('/blogs', 'blogs');
        Route::get('/blog-categories', 'blog_categories');
        Route::get('/blog-details', 'blog_details');
        Route::get('/blog-filter', 'blog_filter');
    });
    Route::controller(MovieController::class)->group(function () {
        Route::get('/movies', 'movies');
        Route::get('/movie-details', 'movie_details');
        Route::get('/movie-filter', 'movie_filter');
    });
    Route::controller(TvShowController::class)->group(function () {
        Route::get('/tv-shows', 'tv_shows');
        Route::get('/tv-show-details', 'tv_show_details');
        Route::get('/tv-show-filter', 'tv_show_filter');
    });
    Route::controller(LiveTvController::class)->group(function () {
        Route::get('/live-tvs', 'liveTvLists');
        Route::get('/live-tv-details', 'liveTvDetails');
    });

    Route::controller(PaymentController::class)->group(function () {
        Route::get('/packages', 'packages');
        Route::any('/webhook-callback', 'webhook_callback');
        Route::get('/get-subscription', 'getSubscription');
    });

    Route::get('review-list', [ReviewController::class, 'reviewList']);


    Route::controller(SettingController::class)->group(function () {
        Route::get('/config', 'get_config');
        Route::get('/ads', 'get_ads');
    });

    Route::middleware(['auth:sanctum'])->group(function () {
        Route::controller(AuthController::class)->group(function () {
            Route::post('/logout', 'logout');
            Route::get('/user-details', 'get_user_details_by_id');
            Route::get('/change-account-status', 'change_account_status');
            Route::post('/update-profile', 'update_Profile');
            Route::post('/change-password', 'change_password');
            Route::get('/delete-account/{id}', 'delete_account');
        });

        //playlist
        Route::get('playlists', [PlayListController::class, 'all']);
        Route::post('create-playlist', [PlayListController::class, 'store']);
        Route::post('update-playlist/{playlist}', [PlayListController::class, 'update']);
        Route::delete('delete-playlist/{playlist}', [PlayListController::class, 'delete']);
        Route::get('get-play-list-movies/{playlist}', [PlayListController::class, 'getPlayListVideos']);
        Route::post('playlists/add-movie', [PlayListController::class, 'addMovieToPlaylist']);
        Route::post('playlists/remove-movie', [PlayListController::class, 'removeMovieFromPlaylist']);
        Route::post('playlists/remove-movie', [PlayListController::class, 'removeMovieFromPlaylist']);
        Route::get('get-playlist-ids/{movie}', [PlayListController::class, 'getPlayListIds']);

        //favorite
        Route::post('favorite/toggle', [FavoriteController::class, 'toggleFavorite'])->name('favorite.toggle');
        Route::get('favorites', [FavoriteController::class, 'getFavorites'])->name('favorite.list');


        Route::controller(PaymentController::class)->group(function () {
            Route::get('/payment-history', 'payment_history')->name('payment.history');
        });

        Route::controller(ReviewController::class)->group(function () {
            Route::post('/rating', 'ratingStore');
            Route::post('/like-toggle', 'LikeToggle');
        });

        Route::controller(RentController::class)->group(function () {
            Route::get('/rent-video-list', 'rentVideoList');
        });

        Route::controller(WatchHistoryController::class)->group(function () {
            Route::get('/watch-histories', 'watchHistory');
            Route::post('/watch-history-store', 'watchHistoryStore');
        });
    });

    Route::controller(PaymentController::class)->group(function () {
        Route::post('/offline-success', 'offline_success')->name('client.offline.success');
    });

    
});
