<?php

use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\BlogCategoryController;
use App\Http\Controllers\Admin\BlogController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\ConfigController;
use App\Http\Controllers\Admin\CountryController;
use App\Http\Controllers\Admin\CustomerQueryController;
use App\Http\Controllers\Admin\DownloadLinkController;
use App\Http\Controllers\Admin\Email\EmailController;
use App\Http\Controllers\Admin\EpisodeController;
use App\Http\Controllers\Admin\FaqController;
use App\Http\Controllers\Admin\GenreController;
use App\Http\Controllers\Admin\AdsController;
use App\Http\Controllers\Admin\ApiKeyController;
use App\Http\Controllers\Admin\FooterSettingController;
use App\Http\Controllers\Admin\ImportController;
use App\Http\Controllers\Admin\InterestController;
use App\Http\Controllers\Admin\LanguageController;
use App\Http\Controllers\Admin\LiveTvCategoryController;
use App\Http\Controllers\Admin\LiveTvController;
use App\Http\Controllers\Admin\MovieController;
use App\Http\Controllers\admin\MovieIndustryController;
use App\Http\Controllers\Admin\MovieRequestController;
use App\Http\Controllers\Admin\PackageController;
use App\Http\Controllers\Admin\PageController;
use App\Http\Controllers\Admin\PaymentController;
use App\Http\Controllers\Admin\ProfileController;
use App\Http\Controllers\Admin\ReportController;
use App\Http\Controllers\Admin\ReviewController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\SeasonController;
use App\Http\Controllers\Admin\StaffController;
use App\Http\Controllers\Admin\StarController;
use App\Http\Controllers\Admin\SubscriberController;
use App\Http\Controllers\Admin\SubscriptionController;
use App\Http\Controllers\Admin\TvShowController;
use App\Http\Controllers\Admin\UtilityController;
use App\Http\Controllers\Admin\VideoQualityController;
use App\Http\Controllers\Admin\WebsiteSettingController;
use App\Http\Requests\Admin\MovieRequest;
use App\Models\CustomerQuery;
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'admin', 'middleware' => ['auth', 'verified', 'admin', 'xss']], function () {
    Route::get('/dashboard', [AdminController::class, 'index'])->name('admin.dashboard');


    /*-----============ Email setting ========================= */
    Route::group(['as' => 'email.'], function () {
        Route::get('email/server-configuration', [EmailController::class, 'serverConfiguration'])->name('server-configuration');
        Route::put('email/server-configuration', [EmailController::class, 'serverConfigurationUpdate'])->name('server-configuration.update');
        Route::post('test/email', [EmailController::class, 'sendTestMail'])->name('test');
        Route::get('email/template', [EmailController::class, 'emailTemplate'])->name('template');
        Route::put('email-template/update', [EmailController::class, 'emailTemplateUpdate'])->name('template.update');
    });

    Route::controller(MovieController::class)->group(function () {
        Route::get('/movies', 'index')->name('admin.movies');
        Route::get('/movie-add', 'add')->name('admin.movie.add');
        Route::post('/movie-store', 'store')->name('admin.movie.store');
        Route::get('/movie-delete/{id}', 'delete')->name('admin.movie.delete');
        Route::get('/movie-edit/{id}', 'edit')->name('admin.movie.edit');
        Route::post('/movie-update/{id}', 'update')->name('admin.movie.update');

        Route::get('/movie-upload-downloads/{movie_id}', 'upload_download_list')->name('admin.movie.upload.downloads');
        Route::get('/movie-file-add/{movie_id}', 'file_add')->name('admin.movie.file.add');
        Route::post('/movie-file-store', 'file_store')->name('admin.movie.file.store');
        Route::get('/movie-file-delete/{id}', 'file_delete')->name('admin.movie.file.delete');
        Route::get('/movie-file-edit/{id}', 'file_edit')->name('admin.movie.file.edit');
        Route::post('/movie-file-update/{id}', 'file_update')->name('admin.movie.file.update');

        Route::get('/make-rental/{type}/{id}', 'make_rental')->name('admin.make.rental');
        Route::post('/make-rental-store', 'make_rental_store')->name('admin.make.rent.store');
    });

    Route::controller(DownloadLinkController::class)->group(function () {
        Route::get('/download-links/{type}/{videoId}', 'index')->name('admin.download.links');
        Route::get('/download-link-add/{type}/{videoId}', 'create')->name('admin.download.link.add');
        Route::post('/download-link-store/{type}/{movieId}', 'store')->name('admin.download_link.store');
        Route::get('/download-link-edit/{type}/{id}', 'edit')->name('admin.download_link.edit');
        Route::post('/download-link-update/{id}', 'update')->name('admin.download_link.update');
        Route::get('/download-link-delete/{id}', 'destroy')->name('admin.download_link.delete');
        Route::post('/download-link-status', 'status')->name('admin.download_link.status');
    });

    Route::controller(CategoryController::class)->group(function () {
        Route::get('/categories', 'index')->name('admin.categories');
        Route::get('/category-add', 'add')->name('admin.category.add');
        Route::post('/category-store', 'store')->name('admin.category.store');
        Route::get('/category-delete/{id}', 'delete')->name('admin.category.delete');
        Route::get('/category-edit/{id}', 'edit')->name('admin.category.edit');
        Route::post('/category-update/{id}', 'update')->name('admin.category.update');
        Route::post('/category-primary-status', 'primary_menu')->name('admin.category.primary.status');
        Route::post('/category-footer-status', 'footer_menu')->name('admin.category.footer.status');
    });

    Route::controller(TvShowController::class)->group(function () {
        Route::get('/tv-shows', 'index')->name('admin.tv.shows');
        Route::get('/tv-show-add', 'add')->name('admin.tv.show.add');
        Route::post('/tv-show-store', 'store')->name('admin.tv.show.store');
        Route::get('/tv-show-delete/{id}', 'delete')->name('admin.tv.show.delete');
        Route::get('/tv-show-edit/{id}', 'edit')->name('admin.tv.show.edit');
        Route::post('/tv-show-update/{id}', 'update')->name('admin.tv.show.update');
        Route::get('/tv-show-settings', 'settings')->name('admin.tv.show.settings');
        Route::post('/tv-show-config', 'config')->name('admin.tv.show.config');
    });

    Route::controller(LiveTvCategoryController::class)->group(function () {
        Route::get('/live-tv-categories', 'index')->name('admin.live.tv.categories');
        Route::get('/live-tv-category/add', 'add')->name('admin.live.tv.category.add');
        Route::post('/live-tv-category/store', 'store')->name('admin.live.tv.category.store');
        Route::get('/live-tv-category/delete/{id}', 'delete')->name('admin.live.tv.category.delete');
        Route::get('/live-tv-category/edit/{id}', 'edit')->name('admin.live.tv.category.edit');
        Route::post('/live-tv-category/update/{id}', 'update')->name('admin.live.tv.category.update');
        Route::post('/live-tv-category/status', 'status')->name('admin.live.tv.category.status');
    });

    Route::controller(LiveTvController::class)->group(function () {
        Route::get('/live-tvs-list', 'index')->name('admin.live.tvs');
        Route::get('/live-tv/add', 'add')->name('admin.live.tv.add');
        Route::post('/live-tv/store', 'store')->name('admin.live.tv.store');
        Route::get('/live-tv/delete/{id}', 'delete')->name('admin.live.tv.delete');
        Route::get('/live-tv/edit/{id}', 'edit')->name('admin.live.tv.edit');
        Route::post('/live-tv/update/{id}', 'update')->name('admin.live.tv.update');
        Route::post('/live-tv/status', 'status')->name('admin.live.tv.status');
        Route::post('/live-tv/feature', 'feature')->name('admin.live.tv.feature');
    });

    Route::controller(SeasonController::class)->group(function () {
        Route::get('/seasons', 'index')->name('admin.seasons');
        Route::get('/season-add', 'add')->name('admin.season.add');
        Route::post('/season-store', 'store')->name('admin.season.store');
        Route::get('/season-delete/{id}', 'delete')->name('admin.season.delete');
        Route::get('/season-edit/{id}', 'edit')->name('admin.season.edit');
        Route::post('/season-update/{id}', 'update')->name('admin.season.update');
    });

    Route::controller(EpisodeController::class)->group(function () {
        Route::get('/episodes', 'index')->name('admin.episodes');
        Route::get('/episode-add', 'add')->name('admin.episode.add');
        Route::post('/episode-store', 'store')->name('admin.episode.store');
        Route::get('/episode-delete/{id}', 'delete')->name('admin.episode.delete');
        Route::get('/episode-edit/{id}', 'edit')->name('admin.episode.edit');
        Route::post('/episode-update/{id}', 'update')->name('admin.episode.update');
    });

    Route::controller(StarController::class)->group(function () {
        Route::get('/stars', 'index')->name('admin.stars');
        Route::get('/star-add', 'add')->name('admin.star.add');
        Route::post('/star-store', 'store')->name('admin.star.store');
        Route::get('/star-delete/{id}', 'delete')->name('admin.star.delete');
        Route::get('/star-edit/{id}', 'edit')->name('admin.star.edit');
        Route::post('/star-update/{id}', 'update')->name('admin.star.update');
        Route::post('/star-status', 'status')->name('admin.star.status');
    });

    Route::controller(MovieIndustryController::class)->group(function () {
        Route::get('/movie-industries', 'index')->name('admin.movie_industries');
        Route::get('/movie-industry-add', 'add')->name('admin.movie_industry.add');
        Route::post('/movie-industry-store', 'store')->name('admin.movie_industry.store');
        Route::get('/movie-industry-delete/{id}', 'delete')->name('admin.movie_industry.delete');
        Route::get('/movie-industry-edit/{id}', 'edit')->name('admin.movie_industry.edit');
        Route::post('/movie-industry-update/{id}', 'update')->name('admin.movie_industry.update');
        Route::post('/movie-industry-status', 'status')->name('admin.movie_industry.status');
    });
    Route::controller(CustomerQueryController::class)->group(function () {
        Route::get('customer-queries', 'index')->name('admin.customer_queries.index');
        Route::get('customer-queries/{id}', 'show')->name('admin.customer_queries.show');
        Route::post('customer-queries/{id}/reply', 'reply')->name('admin.customer_queries.reply');
    });
    Route::controller(ReviewController::class)->group(function () {
        Route::get('reviews', 'index')->name('admin.reviews');
        Route::get('review-details/{id}', 'reviewDetails')->name('admin.review.details');
        Route::get('review-reply-view/{id}', 'replyView')->name('admin.review.reply.view');
        Route::post('review-reply/{id}', 'reply')->name('admin.review.reply');
        Route::get('/review-delete/{id}', 'delete')->name('admin.review.delete');
    });
    Route::controller(LanguageController::class)->group(function () {
        // movie language
        Route::get('/languages', 'index')->name('admin.languages');
        Route::get('/language-add', 'add')->name('admin.language.add');
        Route::post('/language-store', 'store')->name('admin.language.store');
        Route::get('/language-delete/{id}', 'delete')->name('admin.language.delete');
        Route::get('/language-edit/{id}', 'edit')->name('admin.language.edit');
        Route::post('/language-update/{id}', 'update')->name('admin.language.update');
        Route::post('/language-status', 'status')->name('admin.language.status');

        // system language
        Route::get('/system-languages', 'systemLanguage')->name('admin.system.languages');
        Route::get('/system-language-add', 'systemLanguageAdd')->name('admin.system.language.add');
        Route::post('/system-language-store', 'systemLanguageStore')->name('admin.system.language.store');
        Route::get('/system-language-edit/{id}', 'systemLanguageEdit')->name('admin.system.language.edit');
        Route::post('/system-language-update/{id}', 'systemLanguageUpdate')->name('admin.system.language.update');
        Route::get('/system-language-translation/{id}', 'translationPage')->name('admin.language.translations.page');
        Route::get('/system-language-delete/{id}', 'languageDelete')->name('admin.system.language.destroy');
        Route::post('system-language-status', 'statusChange')->name('system-language-status');
        Route::get('/system-language-translation-delete/{language?}/{key?}', 'translationDelete')->name('admin.language.translations.delete');
        Route::post('/language/{language}', 'updateTranslations')->name('admin.language.key.update');
        Route::get('translations/missing-keys/{id}', 'findMissingKeys')->name('admin.language.missing-keys');
        Route::get('languages/scan/{id}', 'scanAndStore')->name('admin.language.scan');
    });

    Route::controller(CountryController::class)->group(function () {
        Route::get('/countries', 'index')->name('admin.countries');
        Route::get('/country-add', 'add')->name('admin.country.add');
        Route::post('/country-store', 'store')->name('admin.country.store');
        Route::get('/country-delete/{id}', 'delete')->name('admin.country.delete');
        Route::get('/country-edit/{id}', 'edit')->name('admin.country.edit');
        Route::post('/country-update/{id}', 'update')->name('admin.country.update');
        Route::post('/country-status', 'status')->name('admin.country.status');
    });

    Route::controller(GenreController::class)->group(function () {
        Route::get('/genres', 'index')->name('admin.genres');
        Route::get('/genre-add', 'add')->name('admin.genre.add');
        Route::post('/genre-store', 'store')->name('admin.genre.store');
        Route::get('/genre-delete/{id}', 'delete')->name('admin.genre.delete');
        Route::get('/genre-edit/{id}', 'edit')->name('admin.genre.edit');
        Route::post('/genre-update/{id}', 'update')->name('admin.genre.update');
        Route::post('/genre-status', 'status')->name('admin.genre.status');
        Route::post('/genre-featured', 'featured')->name('admin.genre.featured');
    });

    Route::controller(StaffController::class)->group(function () {
        Route::get('/staffs', 'index')->name('admin.staffs');
        Route::get('/staff-add', 'add')->name('admin.staff.add');
        Route::post('/staff-store', 'store')->name('admin.staff.store');
        Route::get('/staff-delete/{id}', 'delete')->name('admin.staff.delete');
        Route::get('/staff-edit/{id}', 'edit')->name('admin.staff.edit');
        Route::post('/staff-update/{id}', 'update')->name('admin.staff.update');
        Route::post('/staff-status', 'status')->name('admin.staff.status');
        Route::get('change-role', 'changeRole')->name('staffs.change-role');
    });
    Route::resource('roles', RoleController::class)->except(['show']);

    Route::controller(SubscriberController::class)->group(function () {
        Route::get('/subscribers', 'index')->name('admin.subscribers');
        Route::get('/subscriber-add', 'add')->name('admin.subscriber.add');
        Route::post('/subscriber-store', 'store')->name('admin.subscriber.store');
        Route::get('/subscriber-delete/{id}', 'delete')->name('admin.subscriber.delete');
        Route::get('/subscriber-edit/{id}', 'edit')->name('admin.subscriber.edit');
        Route::post('/subscriber-update/{id}', 'update')->name('admin.subscriber.update');
        Route::post('/subscriber-status', 'status')->name('admin.subscriber.status');
    });

    Route::controller(PackageController::class)->group(function () {
        Route::get('/packages', 'index')->name('admin.packages');
        Route::get('/package-add', 'add')->name('admin.package.add');
        Route::post('/package-store', 'store')->name('admin.package.store');
        Route::get('/package-delete/{id}', 'delete')->name('admin.package.delete');
        Route::get('/package-edit/{id}', 'edit')->name('admin.package.edit');
        Route::post('/package-update/{id}', 'update')->name('admin.package.update');
        Route::post('/package-status', 'status')->name('admin.package.status');
    });

    Route::controller(VideoQualityController::class)->group(function () {
        Route::get('/video-qualities', 'index')->name('admin.video.qualities');
        Route::get('/video-quality-add', 'add')->name('admin.video.quality.add');
        Route::post('/video-quality-store', 'store')->name('admin.video.quality.store');
        Route::get('/video-quality-delete/{id}', 'delete')->name('admin.video.quality.delete');
        Route::get('/video-quality-edit/{id}', 'edit')->name('admin.video.quality.edit');
        Route::post('/video-quality-update/{id}', 'update')->name('admin.video.quality.update');
        Route::post('/video-quality-status', 'status')->name('admin.video.quality.status');
    });

    Route::controller(ImportController::class)->group(function () {
        Route::get('/importer', 'index')->name('admin.importer');
        Route::get('/movie/import', 'fetchMovies')->name('admin.fetch.movies');
        Route::get('/movie/import/{language}/{type}/{id}', 'importDb')->name('admin.import.db');
    });

    Route::controller(InterestController::class)->group(function () {
        Route::get('/interest', 'index')->name('admin.interest');
        Route::get('/interest-add', 'add')->name('admin.interest.add');
        Route::post('/interest-store', 'store')->name('admin.interest.store');
        Route::get('/interest-delete/{id}', 'delete')->name('admin.interest.delete');
        Route::get('/interest-edit/{id}', 'edit')->name('admin.interest.edit');
        Route::post('/interest-update/{id}', 'update')->name('admin.interest.update');
        Route::post('/interest-status', 'status')->name('admin.interest.status');
    });

    Route::controller(ConfigController::class)->group(function () {
        Route::get('/system-settings', 'systemSettings')->name('admin.system.settings');
        Route::get('/admin-settings', 'adminSettings')->name('admin.settings');
        Route::get('/tmdb-settings', 'tmdbSettings')->name('admin.tmdb.settings');
        Route::get('/social-settings', 'socialSettings')->name('admin.social.settings');
        Route::get('/recaptcha-settings', 'recaptchaSettings')->name('admin.recaptcha.settings');
        Route::post('/setting-update/{type?}', 'settingUpdate')->name('admin.setting.update');
        Route::get('/sms-gateway-settings', 'smsGatewaySettings')->name('admin.sms-gateway-settings');
        Route::post('setting-status-change', 'systemStatus')->name('setting.status.change');
    });

    Route::controller(ApiKeyController::class)->group(function () {
        Route::get('api-settings', 'apiSettings')->name('admin.api.settings');
        Route::get('mobile-ads-settings', 'adSettings')->name('admin.ads.settings');

        Route::get('/api-key-add', 'add')->name('admin.api.key.add');
        Route::post('/api-key-store', 'store')->name('admin.api.key.store');
        Route::get('/api-key-delete/{id}', 'delete')->name('admin.api.key.delete');
        Route::get('/api-key-edit/{id}', 'edit')->name('admin.api.key.edit');
        Route::post('/api-key-update/{id}', 'update')->name('admin.api.key.update');
        Route::get('/api-key-status/{id}/{status}', 'status')->name('admin.api.key.status');
    });

    Route::controller(BlogCategoryController::class)->group(function () {
        Route::get('/blog-categories', 'index')->name('admin.blog.categories');
        Route::get('/blog-category-add', 'add')->name('admin.blog.category.add');
        Route::post('/blog-category-store', 'store')->name('admin.blog.category.store');
        Route::get('/blog-category-delete/{id}', 'delete')->name('admin.blog.category.delete');
        Route::get('/blog-category-edit/{id}', 'edit')->name('admin.blog.category.edit');
        Route::post('/blog-category-update/{id}', 'update')->name('admin.blog.category.update');
        Route::post('/blog-category-status', 'status')->name('admin.blog.category.status');
    });

    Route::controller(BlogController::class)->group(function () {
        Route::get('/blogs', 'index')->name('admin.blogs');
        Route::get('/blog-add', 'add')->name('admin.blog.add');
        Route::post('/blog-store', 'store')->name('admin.blog.store');
        Route::get('/blog-delete/{id}', 'delete')->name('admin.blog.delete');
        Route::get('/blog-edit/{id}', 'edit')->name('admin.blog.edit');
        Route::post('/blog-update/{id}', 'update')->name('admin.blog.update');
        Route::post('/blog-status', 'status')->name('admin.blog.status');
    });

    Route::controller(FaqController::class)->group(function () {
        Route::get('/faqs', 'index')->name('admin.faqs');
        Route::get('/faq-add', 'add')->name('admin.faq.add');
        Route::post('/faq-store', 'store')->name('admin.faq.store');
        Route::get('/faq-delete/{id}', 'delete')->name('admin.faq.delete');
        Route::get('/faq-edit/{id}', 'edit')->name('admin.faq.edit');
        Route::post('/faq-update/{id}', 'update')->name('admin.faq.update');
        Route::post('/faq-status', 'status')->name('admin.faq.status');
    });
    Route::resource('pages', PageController::class)->except(['show', 'update']);
    Route::post('pages/update/{id}', [PageController::class, 'update'])->name('pages.update');
    Route::post('pages-status', [PageController::class, 'statusChange'])->name('page.status.change');
    Route::get('/page-delete/{id}', [PageController::class, 'destroy'])->name('page.delete');

    Route::controller(AdsController::class)->group(function () {
        Route::get('/ads', 'index')->name('admin.ads');
        Route::get('/ads/delete/{id}', 'delete')->name('admin.ads.delete');
        Route::get('/ads/edit/{id}', 'edit')->name('admin.ads.edit');
        Route::post('/ads/update/{id}', 'update')->name('admin.ads.update');
        Route::post('/ads-status', 'status')->name('admin.ads.status');

        // Pre-roll ads
        Route::get('/ads/pre-roll', 'preRollIndex')->name('admin.ads.pre_roll.index');
        Route::get('/ads/pre-roll/add', 'preRollAdd')->name('admin.ads.pre_roll.add');
        Route::get('/ads/pre-roll/edit/{id}', 'preRollEdit')->name('admin.ads.pre_roll.edit');
        Route::post('/ads/pre-roll/update/{id}', 'preRollUpdate')->name('admin.ads.pre_roll.update');
        Route::post('/ads/pre-roll/store', 'preRollStore')->name('admin.ads.pre_roll.store');

        // Mid-roll ads
        Route::get('/ads/mid-roll', 'midRollIndex')->name('admin.ads.mid_roll.index');
        Route::get('/ads/mid-roll/add', 'midRollAdd')->name('admin.ads.mid_roll.add');
        Route::post('/ads/mid-roll/update/{id}', 'midRollUpdate')->name('admin.ads.mid_roll.update');
        Route::get('/ads/mid-roll/edit/{id}', 'midRollEdit')->name('admin.ads.mid_roll.edit');
        Route::post('/ads/mid-roll/store', 'midRollStore')->name('admin.ads.mid_roll.store');

        // post-roll ads
        Route::get('/ads/post-roll', 'postRollIndex')->name('admin.ads.post_roll.index');
        Route::get('/ads/post-roll/add', 'postRollAdd')->name('admin.ads.post_roll.add');
        Route::post('/ads/post-roll/store', 'postRollStore')->name('admin.ads.post_roll.store');
        Route::get('/ads/post-roll/edit/{id}', 'postRollEdit')->name('admin.ads.post_roll.edit');
        Route::post('/ads/post-roll/update/{id}', 'postRollUpdate')->name('admin.ads.post_roll.update');

        // Route::get('/ads/roll/edit/{id}', 'adEdit')->name('admin.ad.edit');
        // Route::post('/ads/roll/update/{id}', 'adUpdate')->name('admin.ad.update');
    });

    // Route::controller(PaymentController::class)->group(function () {
    //     Route::get('/payment-settings', 'index')->name('admin.payment.settings');
    //     Route::get('/payment-gateway-status-change/{identifier}/{value}', 'payment_gateway_status')->name('admin.payment.gateway.status');
    //     Route::get('/payment-config/{identifier}', 'payment_config')->name('admin.payment.config');
    //     Route::post('/payment-config-update/{identifier}', 'payment_config_update')->name('admin.payment.config.update');
    // });

    // payment methods
    // Route::get('payment-gateway', [SubscriptionController::class, 'paymentGateways'])->name('payment.gateway');
    // Route::post('payment-gateway', [SubscriptionController::class, 'savePGSetting'])->name('payment.gateway');

    Route::controller(ProfileController::class)->group(function () {
        Route::get('manage-profile', 'index')->name('admin.manage.profile');
        Route::post('update-profile', 'update_profile')->name('admin.update.profile');
        Route::get('change-password', 'change_password')->name('admin.change.password');
        Route::post('password-update', 'password_update')->name('admin.password.update');
    });

    // website theme option
    Route::controller(SubscriptionController::class)->group(function () {
        Route::get('payment-gateway', 'paymentGateways')->name('payment.gateways');
        Route::post('payment-gateway', 'savePGSetting')->name('payment.gateway');

        Route::get('all-subscription', 'allSubscription')->name('all.subscription');
        Route::get('transaction-log', 'transactionLog')->name('transaction.log');
        Route::get('rental-history', 'rentalHistory')->name('rental.history');
        Route::get('subscription/status/{id}', 'subscribeListStatus')->name('subscribe-list.status');
        Route::get('subscription/add', 'addSubscription')->name('admin.add.subscription');
        Route::post('create-subscription', 'storeSubscription')->name('create.subscription');

        Route::get('rent/status/{id}/{status}', 'rentListStatus')->name('rent-list.status');
    });
    Route::delete('stop-recurring/{id}', [SubscriptionController::class, 'stopRecurring'])->name('stop.recurring');

    // website theme option
    Route::controller(WebsiteSettingController::class)->group(function () {
        Route::get('website/theme-options', 'themeOptions')->name('admin.theme.options');
        Route::post('website/theme-options', 'updateThemesOptions')->name('admin.theme.options.post');
        Route::get('website/seo', 'websiteSeo')->name('website.seo');
    });

    //server information
    Route::get('server-info', [UtilityController::class, 'serverInfo'])->name('server.info');
    Route::get('system-info', [UtilityController::class, 'serverInfo'])->name('system.info');
    Route::get('extension-library', [UtilityController::class, 'serverInfo'])->name('extension.library');
    Route::get('file-system-permission', [UtilityController::class, 'serverInfo'])->name('file.system.permission');
    //system update
    Route::get('system-update', [UtilityController::class, 'systemUpdate'])->name('system.update');
    Route::post('system-update', [UtilityController::class, 'downloadUpdate'])->name('download.system.update');

    //website hero
    // Route::get('website/hero-section', [WebsiteSettingController::class, 'heroSection'])->name('admin.hero.section');
    // Route::post('website/hero-section', [WebsiteSettingController::class, 'updateHeroSection'])->name('admin.hero.section');

    // website footer-content
    Route::controller(FooterSettingController::class)->group(function () {
        Route::get('website/footer-content', 'footerContent')->name('footer.content');
        Route::get('website/primary-content-setting', 'primaryContentSetting')->name('footer.primary-content');
        Route::post('website/primary-content-setting', 'saveSocialLinkSetting')->name('footer.primary-content');
        Route::get('website/payment-banner-setting', 'paymentbannerSetting')->name('footer.payment-banner-settings');
        Route::get('website/copyright-setting', 'copyrightSetting')->name('footer.copyright');
        Route::post('website/update-footer-setting', 'updateSetting')->name('footer.update-setting');
        Route::post('website/update-footer-menu', 'menuUpdate')->name('footer.update-menu');
        Route::get('website/social-link', 'socialLink')->name('footer.social-link');
        Route::get('website/app-links', 'appLinks')->name('footer.app_links');
        Route::get('website/legal-pages-link-setting', 'legalPagesLinkSetting')->name('footer.legal_pages_link_setting');
        Route::get('website/help-center-link-setting', 'helpCenterLinkSetting')->name('footer.help_center_link_setting');
    });

    Route::controller(MovieRequestController::class)->group(function () {
        Route::get('/request-movie', 'index')->name('admin.movie_requests');
        Route::get('/movie-request-delete/{id}', 'destroy')->name('admin.movie_request.delete');
        Route::post('/movie-request-update/{id}', 'update')->name('admin.movie_request.update');
    });

    Route::controller(ReportController::class)->group(function () {
        Route::get('/reports', 'index')->name('admin.reports');
        Route::get('/reports-delete/{id}', 'destroy')->name('admin.report.delete');
        Route::post('/reports-update/{id}', 'update')->name('admin.report.update');
    });
});
