@php
    $currentYear = now()->year;
    $startYear = 1975;
    $years = range($currentYear, $startYear);
@endphp

<!-- Sidebar Start -->
<div class="sidebar">
    <div class="widget">
        <form action="javascript:void(0)" class="header__search mw-100">
            <button type="submit"><i class="ri-search-line"></i></button>
            <input type="search" name="search" id="sidebar_search" value="{{ $search ?? ''}}" class="form-control" placeholder="{{ __('search') }}" />
        </form>
    </div>
    <div class="widget">
        <div class="rating__progress">
            <div class="content">{{ __('rating') }} <span class="mincount">0</span> - <span class="maxcount">10</span></div>
            <div id="slider-range"></div>
        </div>
    </div>

    <!-- genre -->
    @php
        $selectedGenre = request()->get('genre') ?? '';
    @endphp
    <div class="widget">
        <h4 class="widget__title">{{ __('explore_by_genre') }}</h4>
        <div class="widget__info">
            @foreach (get_all_genres() as $index => $genre)
                <div class="custom__checkbox{{ $index >= 10 ? ' extra-item extra-genre d-none' : '' }}">
                    <input type="checkbox" name="genres[]" id="genre-{{ $genre->id }}" value="{{ $genre->id }}" {{ $genre->slug == $selectedGenre ? 'checked' : '' }}>
                    <label for="genre-{{ $genre->id }}">{{ $genre->name }}</label>
                </div>
            @endforeach

            @if(count(get_all_genres()) > 10)
                <a href="javascript:void(0)" class="view__btn toggle-btn" data-toggle-group="genre">{{ __('view_all') }}</a>
            @endif
        </div>
    </div>
    @php
        $selectedCountry = request()->get('country') ?? '';
    @endphp
    <div class="widget">
        <h4 class="widget__title">{{ __('country') }}</h4>
        <div class="widget__info">
            @foreach (get_all_countries() as $index => $country)
                <div class="custom__checkbox{{ $index >= 10 ? ' extra-item extra-country d-none' : '' }}">
                    <input type="checkbox" name="countries[]" id="country-{{ $country->id }}" value="{{ $country->id }}" {{ $country->slug == $selectedCountry ? 'checked' : '' }}>
                    <label for="country-{{ $country->id }}">{{ $country->name }}</label>
                </div>
            @endforeach
            @if(count(get_all_countries()) > 10)
                <a href="javascript:void(0)" class="view__btn toggle-btn" data-toggle-group="country">{{ __('view_all') }}</a>
            @endif
        </div>
    </div>
    <!-- year -->
    <div class="widget">
        <h4 class="widget__title">{{ __('year') }}</h4>
        <div class="widget__info">
            @foreach ($years as $index => $year)
                <div class="custom__checkbox {{ $index >= 10 ? ' extra-item extra-year d-none' : '' }}">
                    <input type="checkbox" name="years[]" id="year_{{ $year }}" value="{{ $year }}" {{ $year == $currentYear ? 'checked' : '' }} />
                    <label for="year_{{ $year }}">{{ $year }}</label>
                </div>
            @endforeach
            @if(count($years) > 10)
                <a href="javascript:void(0)" class="view__btn toggle-btn" data-toggle-group="year">{{ __('view_all') }}</a>
            @endif
        </div>
    </div>

    <!-- language -->
    <div class="widget">
        <h4 class="widget__title">{{ __('language') }}</h4>
        <div class="widget__info">
            @foreach (getAllMovieLanguages() as $index => $language)
                <div class="custom__checkbox{{ $index >= 10 ? ' extra-item extra-language d-none' : '' }}">
                    <input type="checkbox" name="languages[]" id="languages{{ $language->id }}"
                        value="{{ $language->id }}" />
                    <label for="languages{{ $language->id  }}">{{$language->name}}</label>
                </div>
            @endforeach
            @if(count(getAllMovieLanguages()) > 10)
                <a href="javascript:void(0)" class="view__btn toggle-btn" data-toggle-group="language">{{ __('view_all') }}</a>
            @endif
        </div>
    </div>
</div>