@extends('website.layouts.master')
@section('title', __('latest_movies'))
@section('content')

    @php
        $selectedGenre = request()->get('genre') ?? '';

    @endphp

    <!-- All Section Wrapper Start -->
    <section class="section__Wrapper pt-120 pb-80">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Filter Flex Item -->
                    <div class="filter__flex d-flex align-items-start gap-5">

                        <!-- Main Wrapper Start -->
                        <div class="filter__inner flex-1">
                            <div class="filter__items mt-0">
                                <div class="section__title">
                                    <h2 class="title">
                                        {{ isset($country) ? __('tv_series_from') . ' ' . $type : ucwords($type) . ' ' . __('tv_series') }}
                                    </h2>
                                    <div class="all__filter mb-0">
                                        @include('website.tv_show.partials.filter')
                                    </div>
                                </div>
                                <div class="inner__section">
                                    <div class="grid-5 movies-list" id="movie-container">
                                        @include('website.tv_show.partials.tv_show_cards', [
                                            'videos' => $videos,
                                        ])
                                    </div>
                                    @if ($videos->isEmpty())
                                        <div class="no-data">
                                            <img src="{{ static_asset('images/default/no-data.png') }}" width="10" alt="{{__('image')}}">
                                            <p>{{ __('no_movies_found') }}</p>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <!-- Main Wrapper End -->
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12" id="pagination">
                    @include('website.movie.partials.pagination', ['videos' => $videos])
                </div>
            </div>
        </div>
    </section>
@endsection