@extends('website.layouts.master')
@section('title', $type . '-' . __('tv_channel'))
@section('content')
    <!-- Breadcrumb Start -->
    <div class="breadcrumb__area">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="breadcrumb__title">
                        <ul class="link">
                            <li><a href="javascript:void(0)"> {{ __('home') }} </a></li>
                            <li> {{ __('live_tv') }} </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- All Section Wrapper Start -->
    <section class="section__Wrapper pt-35 pb-80">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="all__filter">
                        <div class="showing">
                            <div class="icon"><i class="ri-apps-2-line"></i></div>
                            <span id="showing-count">{{ __('showing_live_tv') }}</span>
                        </div>
                        <div class="filter__wrapper">
                            <a href="javascript:void(0)" class="solid__btn" id="clear-filters">{{ __('clear') }}</a>

                            @php
                                $selectedCategory = request()->get('category_id') ?? '';
                            @endphp
                            <div class="filter__dropdown">
                                <div class="selected">{{ __('categories') }}</div>
                                <ul class="filter__list">
                                    @foreach (liveTvCategories() as $category)
                                        <li class="custom__checkbox  align-items-start">
                                            <input type="checkbox" name="categories[]" value="{{ $category->id }}"
                                                id="category-{{ $category->id }}"
                                                {{ $category->id == $selectedCategory ? 'checked' : '' }}
                                                class="filter-category">
                                            <label
                                                for="category-{{ $category->id }}">{{ $category->live_tv_category }}</label>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>

                            @php
                                $selectedCountry = request()->get('country') ?? '';
                            @endphp
                            <div class="filter__dropdown">
                                <div class="selected">{{ __('country') }}</div>
                                <ul class="filter__list">
                                    @foreach (get_all_countries() as $index => $country)
                                        <li class="custom__checkbox align-items-start">
                                            <input type="checkbox" name="countries[]" id="country-{{ $country->id }}"
                                                class="filter-country"
                                                {{ $country->slug == $selectedCountry ? 'checked' : '' }}
                                                value="{{ $country->id }}">
                                            <label for="country-{{ $country->id }}"> {{ $country->name }} </label>
                                        </li>
                                    @endforeach

                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="filter__inner">
                        <div class="filter__items">
                            <div class="section__title mb-25">
                                <h2 class="title text-sm">{{ $type ? $type : __('live_tv_all') }}</h2>
                            </div>
                            <div id="tv-channel-list" class="grid-6">
                                @include('website.tv_channel.partials.channel_cards')
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <nav class="pagination__wrapper justify-content-end" id="pagination-wrapper">
                    </nav>
                </div>
            </div>
        </div>
    </section>

@endsection

@push('js')
    <script>
        "use strict";
        $(document).ready(function() {

            function fetchTvChannels(page = 1) {
                let search = $('#search-input').val();
                let categories = [];
                let countries = [];

                $('.filter-category:checked').each(function() {
                    categories.push($(this).val());
                });

                $('.filter-country:checked').each(function() {
                    countries.push($(this).val());
                });

                $.ajax({
                    url: "{{ route('tv.channels') }}" + "?page=" + page,
                    type: 'GET',
                    data: {
                        search: search,
                        categories: categories,
                        countries: countries,
                        type: "{{ $type }}"
                    },
                    success: function(response) {
                        $('#tv-channel-list').html(response.html);
                        $('#pagination-wrapper').html(response.pagination);
                        $('#showing-count').html(response.showing);
                    }
                });
            }

            // Debounce function
            function debounce(func, delay) {
                let timeout;
                return function() {
                    clearTimeout(timeout);
                    timeout = setTimeout(func, delay);
                };
            }

            // Attach filter change events
            $('.filter-category, .filter-country').on('change', function() {
                fetchTvChannels();
            });

            // Debounced search
            $('#search-input').on('input', debounce(function() {
                fetchTvChannels();
            }, 500));

            // Clear filters
            $('#clear-filters').on('click', function() {
                $('#search-input').val('');
                $('.filter-category, .filter-country').prop('checked', false);
                fetchTvChannels();
            });
            // fetchTvChannels();
            // Handle pagination click
            $(document).on('click', '.pagination a', function(e) {
                e.preventDefault();
                let page = $(this).attr('href').split('page=')[1];
                fetchTvChannels(page);
            });
        });
    </script>
@endpush
