@extends('website.layouts.master')
@section('title', __('tv_show_details'))
@section('content')

    <!-- All Section Wrapper Start -->
    <section class="movieDetails__section pt-100 pb-80">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="movieDetails__wrapper">
                        <div class="movieDetails__inner">
                            <div class="video__wrapper">
                                <div id="playerContainer" class="videoCard">

                                    {{-- @include('website.player.tv_channel_player') --}}
                                    @if ($tv_channel->stream_from === 'youtube')
                                        <div id="plyr-player" data-plyr-provider="youtube"
                                            data-plyr-embed-id="{{ getYoutubeId($tv_channel->stream_url) }}"></div>
                                    @else
                                        <video id="plyr-player" class="plyr" controls playsinline autoplay>
                                            <source src="{{ $tv_channel->stream_url }}" type="application/x-mpegURL" />
                                        </video>
                                    @endif
                                </div>
                            </div>

                            <div class="movieDetails__info mb-4">
                                <div class="start__area">
                                    <span class="live__tag">{{ __('live') }}</span>
                                    <h6 class="channel__title">{{ __('channel_type') }}</h6>
                                    <h4 class="title">{{ $tv_channel->tv_name }}</h4>
                                    <div class="position-relative">
                                        <p class="desc">
                                            {!! $tv_channel->description !!}
                                        </p>
                                        <!-- <span class="more__btn">read more</span> -->
                                    </div>
                                </div>
                                <div class="end__area text-lg-end">
                                    <div class="video__meta">
                                        <div class="meta__item yellow"><i
                                                class="ri-star-fill"></i>{{ getLiveTvRating($tv_channel->id) }}</div>
                                        <div class="meta__item">{{ __('hd_quality') }}</div>
                                    </div>
                                    <div class="action__area justify-content-lg-end">
                                        <a href="javascript:void(0)"
                                            class="favorite-toggle-btn @if ($tv_channel->is_favorite) marked @endif"
                                            data-id="{{ $tv_channel->id }}" data-type="live_tv" data-bs-toggle="tooltip"
                                            data-bs-placement="bottom" title="{{ __('favorite') }}">
                                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0_930_3283)">
                                                    <path
                                                        d="M11.667 1.27783C10.9163 1.28951 10.1819 1.49907 9.53814 1.88535C8.89434 2.27162 8.36387 2.82094 8.0003 3.47783C7.63672 2.82094 7.10625 2.27162 6.46246 1.88535C5.81866 1.49907 5.08433 1.28951 4.33363 1.27783C3.13692 1.32983 2.00944 1.85333 1.19749 2.73399C0.385537 3.61464 -0.0448693 4.78085 0.000297715 5.97783C0.000297715 9.00917 3.19096 12.3198 5.86696 14.5645C6.46444 15.0666 7.21987 15.3418 8.0003 15.3418C8.78073 15.3418 9.53615 15.0666 10.1336 14.5645C12.8096 12.3198 16.0003 9.00917 16.0003 5.97783C16.0455 4.78085 15.6151 3.61464 14.8031 2.73399C13.9912 1.85333 12.8637 1.32983 11.667 1.27783ZM9.27696 13.5445C8.91962 13.8454 8.46747 14.0104 8.0003 14.0104C7.53313 14.0104 7.08098 13.8454 6.72363 13.5445C3.2983 10.6705 1.33363 7.91317 1.33363 5.97783C1.28806 5.13431 1.57788 4.30699 2.13987 3.6763C2.70187 3.04561 3.49045 2.66273 4.33363 2.61117C5.17681 2.66273 5.96539 3.04561 6.52739 3.6763C7.08939 4.30699 7.3792 5.13431 7.33363 5.97783C7.33363 6.15464 7.40387 6.32421 7.52889 6.44924C7.65392 6.57426 7.82349 6.6445 8.0003 6.6445C8.17711 6.6445 8.34668 6.57426 8.4717 6.44924C8.59673 6.32421 8.66696 6.15464 8.66696 5.97783C8.62139 5.13431 8.91121 4.30699 9.47321 3.6763C10.0352 3.04561 10.8238 2.66273 11.667 2.61117C12.5101 2.66273 13.2987 3.04561 13.8607 3.6763C14.4227 4.30699 14.7125 5.13431 14.667 5.97783C14.667 7.91317 12.7023 10.6705 9.27696 13.5418V13.5445Z"
                                                        fill="white" />
                                                </g>
                                            </svg>
                                        </a>

                                        <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-placement="bottom"
                                            data-url="{{ route('live.tv.details', ['slug' => $tv_channel->slug]) }}"
                                            data-bs-target="#shareModal" title="{{ __('share') }}" class="share-btn">
                                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0_892_4790)">
                                                    <path
                                                        d="M12.8888 9.77816C12.3847 9.77858 11.8883 9.90163 11.4425 10.1367C10.9966 10.3718 10.6146 10.7118 10.3295 11.1275L5.99012 9.16817C6.29833 8.42392 6.29952 7.58796 5.99345 6.84283L10.3268 4.8735C10.7494 5.48467 11.377 5.92414 12.0958 6.1122C12.8147 6.30025 13.5771 6.22443 14.2449 5.8985C14.9126 5.57256 15.4414 5.0181 15.7353 4.33568C16.0293 3.65325 16.0689 2.88808 15.847 2.17895C15.6251 1.46982 15.1564 0.863696 14.5259 0.470535C13.8954 0.0773743 13.1449 -0.0767867 12.4105 0.0360157C11.6761 0.148818 11.0064 0.521112 10.5229 1.08537C10.0395 1.64962 9.7743 2.36846 9.77545 3.1115C9.77828 3.28736 9.79612 3.46267 9.82878 3.6355L5.22212 5.72883C4.77968 5.31431 4.22579 5.03806 3.6285 4.93401C3.03121 4.82996 2.41654 4.90264 1.85999 5.14314C1.30344 5.38363 0.829268 5.78146 0.495715 6.28774C0.162163 6.79402 -0.0162385 7.38671 -0.0175706 7.993C-0.0189027 8.59928 0.156892 9.19275 0.488217 9.70049C0.819542 10.2082 1.29197 10.6081 1.84745 10.8511C2.40293 11.094 3.01728 11.1694 3.61502 11.068C4.21276 10.9666 4.76786 10.6927 5.21212 10.2802L9.83078 12.3655C9.7987 12.5382 9.78109 12.7132 9.77812 12.8888C9.77799 13.5043 9.96037 14.1059 10.3022 14.6176C10.644 15.1294 11.1299 15.5283 11.6985 15.7639C12.267 15.9994 12.8927 16.0611 13.4963 15.9411C14.0999 15.8211 14.6543 15.5247 15.0895 15.0895C15.5247 14.6544 15.821 14.0999 15.941 13.4963C16.0611 12.8927 15.9994 12.2671 15.7638 11.6985C15.5282 11.13 15.1294 10.6441 14.6176 10.3022C14.1058 9.96041 13.5042 9.77803 12.8888 9.77816ZM12.8888 1.3335C13.2405 1.33337 13.5843 1.43753 13.8768 1.63282C14.1692 1.82811 14.3972 2.10575 14.5319 2.43063C14.6666 2.7555 14.7019 3.11302 14.6334 3.45796C14.5648 3.8029 14.3956 4.11977 14.1469 4.3685C13.8983 4.61722 13.5815 4.78663 13.2366 4.85529C12.8917 4.92394 12.5341 4.88877 12.2092 4.75422C11.8843 4.61967 11.6065 4.39178 11.4111 4.09937C11.2157 3.80697 11.1115 3.46318 11.1115 3.1115C11.1118 2.64017 11.2992 2.18823 11.6324 1.85489C11.9656 1.52154 12.4175 1.33403 12.8888 1.3335ZM3.11145 9.77816C2.75977 9.7783 2.41594 9.67413 2.12347 9.47884C1.83099 9.28355 1.60299 9.00591 1.46832 8.68104C1.33364 8.35616 1.29834 7.99865 1.36687 7.6537C1.4354 7.30876 1.60468 6.99189 1.85331 6.74317C2.10194 6.49444 2.41875 6.32504 2.76367 6.25638C3.10859 6.18772 3.46612 6.22289 3.79104 6.35744C4.11597 6.492 4.39369 6.71989 4.58909 7.01229C4.78449 7.3047 4.88878 7.64848 4.88878 8.00016C4.88826 8.47144 4.70085 8.92327 4.36767 9.25658C4.03449 9.58989 3.58273 9.77746 3.11145 9.77816ZM12.8888 14.6668C12.5371 14.6668 12.1934 14.5626 11.901 14.3672C11.6086 14.1718 11.3807 13.8941 11.2461 13.5692C11.1116 13.2444 11.0763 12.8869 11.1449 12.542C11.2136 12.1971 11.3829 11.8803 11.6315 11.6316C11.8802 11.3829 12.197 11.2136 12.5419 11.145C12.8868 11.0764 13.2443 11.1116 13.5692 11.2462C13.8941 11.3807 14.1718 11.6086 14.3671 11.901C14.5625 12.1934 14.6668 12.5372 14.6668 12.8888C14.6664 13.3603 14.479 13.8123 14.1456 14.1457C13.8123 14.479 13.3602 14.6665 12.8888 14.6668Z"
                                                        fill="white" />
                                                </g>
                                            </svg>
                                        </a>
                                    </div>
                                </div>
                            </div>

                            <div class="server__group mt-3">
                                <button type="button" class="btn" id="stream_label"
                                    data-stream='@json(['url' => $tv_channel->stream_url, 'type' => $tv_channel->stream_from])'>
                                    {{ $tv_channel->stream_label }}
                                </button>


                                @if ($tv_channel->stream1?->url)
                                    <button type="button" class="btn" id="stream_label1"
                                        onclick="renderPlayer('{{ $tv_channel->stream1->url }}','{{ $tv_channel->stream1->source }}')"
                                        data-stream='@json(['url' => $tv_channel->stream1->url, 'type' => $tv_channel->stream1->type])'>
                                        {{ $tv_channel->stream1->label }}
                                    </button>
                                @endif

                                @if ($tv_channel->stream2?->url)
                                    <button type="button" class="btn" id="stream_label2"
                                        onclick="renderPlayer('{{ $tv_channel->stream2->url }}','{{ $tv_channel->stream2->source }}')"
                                        data-stream='@json(['url' => $tv_channel->stream2->url, 'type' => $tv_channel->stream2->type])'>
                                        {{ $tv_channel->stream2->label }}
                                    </button>
                                @endif
                            </div>

                            <div class="video__content mt-50">
                                <!-- Tab Header -->
                                <div class="tabHeader">
                                    <h4 class="title"> {{ __('video_deatils') }} </h4>
                                    <div class="tablist">
                                        <div class="custom__tabs text-center">
                                            <ul class="nav nav-pills" id="pills-tab" role="tablist">

                                                <li class="nav-item" role="presentation">
                                                    <button class="nav-link active" id="review-tab" data-bs-toggle="pill"
                                                        data-bs-target="#review" type="button" role="tab"
                                                        aria-controls="review" aria-selected="false" tabindex="-1">
                                                        {{ __('review_&_ratings') }}
                                                    </button>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <!-- Tab Content Start -->
                                <div class="tab-content">

                                    <div class="tab-pane fade active show" id="review" role="tabpanel">
                                        <!-- Single Wrapper -->
                                        <div class="blogSingle__wrapper">
                                            @if (!auth()->user()?->hasReviewed($tv_channel))
                                                <form action="{{ route('review.store.tv_channel', $tv_channel->id) }}"
                                                    method="POST" class="all__comments">
                                                    @csrf
                                                    <input type="hidden" name="reviewable_id"
                                                        value="{{ $tv_channel->id }}">
                                                    <input type="hidden" name="rating" id="rating-value"
                                                        value="">

                                                    <div class="commentsRating">
                                                        <h5 class="comments">{{ count($tv_channel->reviews ?? []) }}
                                                            {{ __('reviews') }}
                                                        </h5>
                                                        <div class="rating__inline">
                                                            <span class="title">{{ __('submit_rating') }} :</span>
                                                            <div class="rating" id="star-rating">
                                                                @for ($i = 1; $i <= 10; $i++)
                                                                    <a href="javascript:void(0)"
                                                                        data-value="{{ $i }}"><i
                                                                            class="ri-star-line"></i></a>
                                                                @endfor
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="form-group">
                                                        <textarea name="review" class="form-control" cols="30" rows="8" placeholder="Write Something"></textarea>
                                                    </div>

                                                    <div class="submit-btn">
                                                        <button type="submit"
                                                            class="btn btn-primary">{{ __('post') }}</button>
                                                    </div>
                                                </form>
                                            @endif
                                            <div class="clients__review">
                                                <!-- <h4 class="review__title">People Comments (03)</h4> -->
                                                <div class="review__wrapper">
                                                    @foreach ($tv_channel->reviews as $review)
                                                        <div class="review__item">
                                                            <div class="d-flex justify-content-between">
                                                                <div class="d-flex align-items-center gap-4">
                                                                    <div class="avatar">
                                                                        <img src="{{ getFileLink('user', $review->user->image, 'users', '80x80') }}"
                                                                            alt="avatar" />
                                                                    </div>
                                                                    <div class="review__content">
                                                                        <h5>{{ $review->user->first_name . ' ' . $review->user->last_name }}
                                                                        </h5>
                                                                        <span>{{ $review->created_at->format('d F, Y') }}</span>
                                                                    </div>
                                                                </div>
                                                                <div>
                                                                    @php
                                                                        $filled = $review->rating;
                                                                        $empty = 10 - $filled;
                                                                    @endphp

                                                                    <span class="text-white">
                                                                        <strong>{{ __('ratings') }}: </strong>
                                                                        {!! str_repeat('★', $filled) !!}{!! str_repeat('☆', $empty) !!}
                                                                    </span>

                                                                </div>
                                                            </div>
                                                            <p class="desc">
                                                                {{ $review->review }}
                                                            </p>

                                                            @if ($review->reply)
                                                                <div class="sub__replay">
                                                                    <div class="replay">
                                                                        <a href="javascript:void(0)"><i
                                                                                class="ri-corner-left-up-line"></i>{{ __('reply') }}</a>
                                                                    </div>
                                                                    <div class="review__item">
                                                                        <div class="d-flex align-items-center gap-4">
                                                                            <div class="avatar">
                                                                                <img src="{{ asset('assets/images/user.png') }}"
                                                                                    alt="avatar" />
                                                                            </div>
                                                                            <div class="review__content">
                                                                                <h5>{{ __('admin') }}</h5>
                                                                                <span>{{ $review->updated_at->format('d F, Y') }}</span>
                                                                            </div>
                                                                        </div>
                                                                        <p class="desc">
                                                                            {{ $review->reply }}
                                                                        </p>
                                                                    </div>
                                                                </div>
                                                            @endif

                                                            <!-- Reaction meta -->
                                                            <div class="reaction__meta">
                                                                <a href="javascript:void(0)"
                                                                    class="avarage__reaction like-btn"
                                                                    data-review-id="{{ $review->id }}"
                                                                    data-liked="{{ auth()->check() && $review->isLikedBy(auth()->user()) ? '1' : '0' }}">
                                                                    @if (auth()->check() && $review->isLikedBy(auth()->user()))
                                                                        <i class="ri-thumb-up-fill text-primary"></i>
                                                                    @else
                                                                        <i class="ri-thumb-up-line"></i>
                                                                    @endif
                                                                    <span
                                                                        class="like-count">{{ $review->likes()->count() }}</span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Single Wrapper -->
                                    </div>
                                </div>
                            </div>

                            <div class="related__section mb-40 mt-30">
                                <div class="section__title">
                                    <h2 class="title">{{ __('releated_tv_channels') }}</h2>
                                    <div class="view__btn">
                                        <a href="{{ route('tv.channels') }}">{{ __('view_all') }}</a>
                                    </div>
                                </div>
                                <div class="position-relative">
                                    <div class="swiper channel__slider">
                                        <div class="swiper-wrapper">
                                            @foreach ($related_tv_channels as $channel)
                                                <div class="swiper-slide">
                                                    <a href="{{ route('live.tv.details', ['slug' => $channel->slug]) }}"
                                                        class="channel__card">
                                                        <div class="card__thumb">
                                                            <img src="{{ getFileLink('thumbnail', $channel->thumbnail, 'live_tv_thumbs', '400x320') }}"
                                                                alt="channel" />
                                                        </div>
                                                    </a>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                    <div class="swiper__navigation">
                                        <div class="channel-swipe-prev swiper-button-prev">
                                            <i class="ri-arrow-left-s-line"></i>
                                        </div>
                                        <div class="channel-swipe-next swiper-button-next">
                                            <i class="ri-arrow-right-s-line"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="ads__wrapper">
                            @include('website.component.ads_sidebar')
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- All Section Wrapper End -->
        <script src="https://cdn.jsdelivr.net/npm/hls.js@latest"></script>

    @endsection
    @include('website.component.like_review')
    @push('js')
        <script>
            "use strict";
            $(document).ready(function() {
                // First remove 'active' class from all buttons
                $('.server__group .btn').removeClass('active');

                // Then handle the auto-trigger logic
                @if ($tv_channel->stream2?->url)
                    setTimeout(() => {
                        $('#stream_label2').addClass('active').trigger('click');
                    }, 300);
                @elseif ($tv_channel->stream1?->url)
                    setTimeout(() => {
                        $('#stream_label1').addClass('active').trigger('click');
                    }, 300);
                @else
                    setTimeout(() => {
                        $('#stream_label').addClass('active').trigger('click');
                    }, 300);
                @endif
            });

            // Make sure you have click handlers set up for these buttons
            $('.server__group .btn').on('click', function() {
                // Your button click handler logic here
                console.log('Button clicked:', $(this).attr('id'));
                // Example: load the stream based on data-stream attribute
            });

            let playerInstance;

            function extractYoutubeID(url) {
                var match = url.match(/[?&]v=([^&#]*)/) || url.match(/youtu\.be\/([^&#]*)/);
                return match ? match[1] : '';
            }

            function renderPlayer(url, type) {
                if (playerInstance) {
                    playerInstance.destroy();
                }

                let html = '';
                if (type === 'youtube') {
                    var videoId = extractYoutubeID(url);
                    html = `<div id="plyr-player" data-plyr-provider="youtube" data-plyr-embed-id="${videoId}"></div>`;
                    $('#playerContainer').html(html);
                    playerInstance = new Plyr('#plyr-player');
                } else if (type === 'hls') {
                    html = `<video id="plyr-player" class="plyr" controls autoplay></video>`;
                    $('#playerContainer').html(html);

                    const video = document.getElementById('plyr-player');
                    if (Hls.isSupported()) {
                        const hls = new Hls();
                        hls.loadSource(url);
                        hls.attachMedia(video);
                        hls.on(Hls.Events.MANIFEST_PARSED, function() {
                            playerInstance = new Plyr(video);
                        });
                    } else if (video.canPlayType('application/vnd.apple.mpegurl')) {
                        video.src = url;
                        playerInstance = new Plyr(video);
                    } else {
                        $('#playerContainer').html('<p>Your browser does not support HLS.</p>');
                    }
                } else {
                    // Fallback for other types (mp4, webm, etc.)
                    html = `
                                                                        <video id="plyr-player" class="plyr" controls autoplay>
                                                                            <source src="${url}">
                                                                        </video>`;
                    $('#playerContainer').html(html);
                    playerInstance = new Plyr('#plyr-player');
                }
            }

            $(document).ready(function() {
                playerInstance = new Plyr('#plyr-player');

                $('.server__group .btn').on('click', function() {
                    $('.server__group .btn').removeClass('active');
                    $(this).addClass('active');

                    var stream = $(this).data('stream');
                    if (stream && stream.url && stream.type) {
                        renderPlayer(stream.url, stream.type);
                    }
                });
            });
        </script>
    @endpush
