@extends('website.layouts.base')
@section('title', __('video_player'))
@section('base.content')

    <link rel="stylesheet" type="text/css" href="{{ static_asset('website/player/content/global.css') }}" />
    {{ $tv_channel->stream_url }}
    <div id="myDiv" class="m-auto"></div>

    <div id="player"></div>

    <!--  Playlists -->
    <ul id="playlists" class="d-none">
        <li data-source="playlist1" data-playlist-name="Related Videos"
            data-thumbnail-path="{{ getFileLink('thumbnail', $tv_channel->thumbnail, 'live_tv_thumbs', '400x320') }}">
            <p class="fwduvp-categories-title"><span class="fwduvp-header">{{ __('title') }}: </span><span
                    class="fwduvp-title"> {{ $tv_channel->tv_name }} </span></p>
            <p class="fwduvp-categories-description"><span class="fwduvp-header">{{ __('description') }}: </span>
                {{ $tv_channel->description }} </p>
        </li>
    </ul>

    <!--  HTML playlist -->
    <ul id="playlist1" class="d-none">
        <li data-thumb-source="{{ getFileLink('thumbnail', $tv_channel->thumbnail, 'live_tv_thumbs', '400x320') }}"
            data-video-source="[{source:'{{ $tv_channel->stream_url }}', label:'HD'}]" data-start-at-video="0"
            data-poster-source="{{ getFileLink('thumbnail', $tv_channel->thumbnail, 'live_tv_thumbs', '400x320') }}"
            data-start-at-subtitle="1" data-downloadable="no">
            <ul data-ads="">
                @if ($pre_roll_ad)
                    <li data-source="{{ $pre_roll_ad->video_link }}" data-time-start="00:00:02"
                        data-time-to-hold-ads={{ $pre_roll_ad->skip_after }} data-link="{{ $pre_roll_ad->redirect_url }}"
                        data-target="_blank"></li>
                @endif
                @if ($mid_roll_ad)
                    <li data-source="{{ $mid_roll_ad->video_link }}" data-time-start="{{ $mid_roll_ad->start_time }}"
                        data-time-to-hold-ads={{ $mid_roll_ad->skip_after }}
                        data-add-duration="{{ $mid_roll_ad->end_time }}" data-thumbnail-source=""
                        data-link="{{ $mid_roll_ad->video_link }}" data-target="_blank"></li>
                @endif
                @if ($post_roll_ad)
                    <li data-source="{{ $post_roll_ad->video_link }}"
                        data-time-start="{{ getVideoAdTimestamp($video->runtime, $post_roll_ad->ad_duration, 'start') }}"
                        data-time-to-hold-ads={{ $post_roll_ad->skip_after }}
                        data-add-duration="{{ getVideoAdTimestamp($video->runtime, $post_roll_ad->ad_duration, 'end') }}"
                        id="post_roll"></li>
                @endif
            </ul>
            <div data-video-short-description="">
                <div>
                    <p class="fwduvp-thumbnail-title"> {{ $tv_channel->tv_name }} </p>
                    <p class="fwduvp-thumbnail-description">{{ $tv_channel->description }}</p>
                </div>
            </div>
        </li>
    </ul>

    <!--  HTML mixed playlist -->
    <script src="https://code.jquery.com/jquery-3.2.0.min.js"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPData.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPlayer.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPVideoScreen.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPComplexButton.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPContextMenu.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPXConsole.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPController.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPDisplayObject.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPEventDispatcher.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPInfo.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDXAnimation.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPPreloader.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPVolumeButton.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPUtils.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPPoster.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPSimpleButton.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPTransformDisplayObject.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPHider.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPYoutubeScreen.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPYTBQButton.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPLogo.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPCategories.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPCategoriesThumb.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPToolTip.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPPlaylist.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPPlaylistThumb.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDXUVPDL.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPEmbedWindow.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPSimpleSizeButton.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPInfoWindow.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPAdsButton.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPAdsStart.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPSubtitle.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPShareWindow.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPVimeoScreen.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPOpener.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPPreloader2.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPLightBox.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPPupupAds.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPPopupAddButton.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPAnnotations.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPAnnotation.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPComboBox.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPComboBoxSelector.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPComboBoxButton.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPAudioScreen.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPPassword.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPOPWindow.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPScrubberToolip.js') }}"></script>
    <script type="text/javascript" src="{{ static_asset('website/player/js/FWDUVPContextMenuButton.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/hls.js@latest"></script>

    <!-- Setup video player-->
    <script type="text/javascript">
        FWDConsole.setPrototype();
        var logger;

        FWDUVPlayer.videoStartBehaviour = "stop";

        FWDUVPUtils.onReady(function() {
            setTimeout(() => {
                const player = new FWDUVPlayer({
                    //main settings
                    instanceName: "player1",
                    parentId: "myDiv",
                    playlistsId: "playlists",
                    mainFolderPath: "{{ static_asset('website/player/content/') }}",
                    skinPath: "minimal_skin_dark",
                    displayType: "responsive",
                    initializeOnlyWhenVisible: "no",
                    useVectorIcons: "yes",
                    fillEntireVideoScreen: "no",
                    fillEntireposterScreen: "yes",
                    goFullScreenOnButtonPlay: "no",
                    playsinline: "yes",
                    privateVideoPassword: "428c841430ea18a70f7b06525d4b748a",
                    youtubeAPIKey: "{{ get_config('google_api_key') }}",
                    useHEXColorsForSkin: "no",
                    normalHEXButtonsColor: "#FF0000",
                    useDeepLinking: "no",
                    googleAnalyticsMeasurementId: "G-842HPC3W6L",
                    useResumeOnPlay: "no",
                    showPreloader: "yes",
                    preloaderBackgroundColor: "#000000",
                    preloaderFillColor: "#FFFFFF",
                    addKeyboardSupport: "yes",
                    autoScale: "yes",
                    showButtonsToolTip: "yes",
                    stopVideoWhenPlayComplete: "no",
                    playAfterVideoStop: "no",
                    autoPlay: "no",
                    autoPlayText: "Click To Unmute",
                    loop: "no",
                    shuffle: "no",
                    showErrorInfo: "yes",
                    maxWidth: 1300,
                    maxHeight: 700,
                    buttonsToolTipHideDelay: 1.5,
                    volume: .03,
                    rewindTime: 10,
                    backgroundColor: "#000000",
                    videoBackgroundColor: "#000000",
                    posterBackgroundColor: "#000000",
                    buttonsToolTipFontColor: "#5a5a5a",
                    //logo settings
                    showLogo: "yes",
                    logoPath: "{{ getFileLink('original_image', get_config('player_logo'), 'player_logos', '130x50') }}",
                    hideLogoWithController: "yes",
                    logoPosition: "topRight",
                    logoLink: "{{ route('home') }}",
                    logoTarget: '_blank',
                    logoMargins: 10,

                    //playlists/categories settings
                    showPlaylistsSearchInput: "no",
                    usePlaylistsSelectBox: "yes",
                    showPlaylistsButtonAndPlaylists: "no",
                    showPlaylistsByDefault: "no",
                    thumbnailSelectedType: "opacity",
                    startAtPlaylist: 0,
                    buttonsMargins: 15,
                    thumbnailMaxWidth: 350,
                    thumbnailMaxHeight: 350,
                    horizontalSpaceBetweenThumbnails: 40,
                    verticalSpaceBetweenThumbnails: 40,
                    inputBackgroundColor: "#333333",
                    inputColor: "#999999",
                    //playlist settings
                    showPlaylistButtonAndPlaylist: "no",
                    playlistPosition: "right",
                    showPlaylistByDefault: "yes",
                    showPlaylistName: "yes",
                    showSearchInput: "yes",
                    showLoopButton: "no",
                    showShuffleButton: "no",
                    showPlaylistOnFullScreen: "no",
                    showNextAndPrevButtons: "no",
                    showThumbnail: "no",
                    showOnlyThumbnail: "no",
                    forceDisableDownloadButtonForFolder: "no",
                    addMouseWheelSupport: "no",
                    startAtRandomVideo: "no",
                    stopAfterLastVideoHasPlayed: "no",
                    addScrollOnMouseMove: "no",
                    randomizePlaylist: 'no',
                    folderVideoLabel: "VIDEO ",
                    playlistRightWidth: 310,
                    playlistBottomHeight: 380,
                    startAtVideo: 0,
                    maxPlaylistItems: 50,
                    thumbnailWidth: 71,
                    thumbnailHeight: 71,
                    spaceBetweenControllerAndPlaylist: 1,
                    spaceBetweenThumbnails: 1,
                    scrollbarOffestWidth: 8,
                    scollbarSpeedSensitivity: .5,
                    playlistBackgroundColor: "#000000",
                    playlistNameColor: "#FFFFFF",
                    thumbnailNormalBackgroundColor: "#1b1b1b",
                    thumbnailHoverBackgroundColor: "#313131",
                    thumbnailDisabledBackgroundColor: "#272727",
                    searchInputBackgroundColor: "#000000",
                    searchInputColor: "#999999",
                    youtubeAndFolderVideoTitleColor: "#FFFFFF",
                    folderAudioSecondTitleColor: "#999999",
                    youtubeOwnerColor: "#888888",
                    youtubeDescriptionColor: "#888888",
                    mainSelectorBackgroundSelectedColor: "#FFFFFF",
                    mainSelectorTextNormalColor: "#FFFFFF",
                    mainSelectorTextSelectedColor: "#000000",
                    mainButtonBackgroundNormalColor: "#212021",
                    mainButtonBackgroundSelectedColor: "#FFFFFF",
                    mainButtonTextNormalColor: "#FFFFFF",
                    mainButtonTextSelectedColor: "#000000",
                    //controller settings
                    showController: "yes",
                    showControllerWhenVideoIsStopped: "yes",
                    showNextAndPrevButtonsInController: "no",
                    showRewindButton: "yes",
                    showPlaybackRateButton: "yes",
                    showVolumeButton: "yes",
                    showTime: "yes",
                    showAudioTracksButton: "yes",
                    showQualityButton: "yes",
                    showInfoButton: "yes",
                    showDownloadButton: "no",
                    showShareButton: "yes",
                    showEmbedButton: "yes",
                    showChromecastButton: "yes",
                    show360DegreeVideoVrButton: "yes",
                    showFullScreenButton: "no",
                    disableVideoScrubber: "no",
                    showScrubberWhenControllerIsHidden: "yes",
                    showMainScrubberToolTipLabel: "yes",
                    showDefaultControllerForVimeo: "yes",
                    repeatBackground: "yes",
                    controllerHeight: 42,
                    controllerHideDelay: 3,
                    startSpaceBetweenButtons: 7,
                    spaceBetweenButtons: 8,
                    scrubbersOffsetWidth: 2,
                    mainScrubberOffestTop: 14,
                    timeOffsetLeftWidth: 5,
                    timeOffsetRightWidth: 3,
                    timeOffsetTop: 0,
                    volumeScrubberHeight: 80,
                    volumeScrubberOfsetHeight: 12,
                    timeColor: "#888888",
                    showYoutubeRelAndInfo: "no",
                    youtubeQualityButtonNormalColor: "#888888",
                    youtubeQualityButtonSelectedColor: "#FFFFFF",
                    scrubbersToolTipLabelBackgroundColor: "#FFFFFF",
                    scrubbersToolTipLabelFontColor: "#5a5a5a",
                    //advertisement on pause window
                    aopwTitle: "Advertisement",
                    aopwWidth: 400,
                    aopwHeight: 240,
                    aopwBorderSize: 6,
                    aopwTitleColor: "#FFFFFF",
                    //subtitle
                    subtitlesOffLabel: "Subtitle off",
                    showSubtitleButton: 'no',
                    //popup add windows
                    showPopupAdsCloseButton: "yes",
                    //embed window and info window
                    embedAndInfoWindowCloseButtonMargins: 15,
                    borderColor: "#333333",
                    mainLabelsColor: "#FFFFFF",
                    secondaryLabelsColor: "#a1a1a1",
                    shareAndEmbedTextColor: "#5a5a5a",
                    inputBackgroundColor: "#000000",
                    inputColor: "#FFFFFF",
                    //login
                    playIfLoggedIn: "no",
                    playIfLoggedInMessage: "Please <a href='https://google.com' target='_blank'>login</a> to play this video.",
                    defaultPlaybackRate: 1, //0.25, 0.5, 1, 1.25, 1.2, 2
                    //cuepoints
                    executeCuepointsOnlyOnce: "no",
                    //annotations
                    showAnnotationsPositionTool: "no",
                    //ads
                    openNewPageAtTheEndOfTheAds: "no",
                    playAdsOnlyOnce: "no",
                    adsButtonsPosition: "right",
                    skipToVideoText: "You can skip to video in: ",
                    skipToVideoButtonText: "Skip Ad",
                    adsTextNormalColor: "#888888",
                    adsTextSelectedColor: "#FFFFFF",
                    adsBorderNormalColor: "#666666",
                    adsBorderSelectedColor: "#FFFFFF",
                    //a to b loop
                    useAToB: "no",
                    atbTimeBackgroundColor: "transparent",
                    atbTimeTextColorNormal: "#888888",
                    atbTimeTextColorSelected: "#FFFFFF",
                    atbButtonTextNormalColor: "#888888",
                    atbButtonTextSelectedColor: "#FFFFFF",
                    atbButtonBackgroundNormalColor: "#FFFFFF",
                    atbButtonBackgroundSelectedColor: "#000000",

              
                });
            }, 100)
        });

        function goFullScreen() {
            player1.goFullScreen();
        }

        setTimeout(() => {
            player1.play();
            goFullScreen()
        }, 2000);
    </script>

@endsection
