@extends('website.layouts.master')
@section('title', __('contact_us'))
@section('content')

    <!-- Breadcrumb Start -->
    <div class="breadcrumb__area">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="breadcrumb__title">
                        <ul class="link">
                            <li><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                            <li>{{ __('subscription') }}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- All Section Wrapper Start -->
    <section class="pricing__Wrapper pt-50 pb-80">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="pricing__wrapper">
                        <div class="custom__tabs text-center">
                            <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="monthly-plan-tab" data-bs-toggle="pill"
                                        data-bs-target="#monthly-plan" type="button" role="tab"
                                        aria-controls="monthly-plan" aria-selected="false">
                                        {{ __('monthly') }}
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="annually" data-bs-toggle="pill"
                                        data-bs-target="#annually-plan" type="button" role="tab"
                                        aria-controls="annually-plan" aria-selected="false">
                                        {{ __('annually') }}
                                    </button>
                                </li>
                            </ul>
                            <!-- Tab Content Start -->
                            <div class="tab-content">
                                <div class="tab-pane fade active show" id="monthly-plan" role="tabpanel">
                                    <div class="pricing__grid">
                                        @foreach ($monthly_packages as $package)
                                            <!-- Pricing Item -->
                                            <div class="pricing__item">
                                                <div class="pricing__header">
                                                    @if ($package->discount)
                                                        <div class="badge badge-2">
                                                            {{ __('save') . ' ' . get_discount_percentage($package->price, $package->discount) }}
                                                        </div>
                                                    @endif
                                                    <h3 class="title"> {{ $package->name }} </h3>
                                                    <div class="pricing__tag">
                                                        <span
                                                            class="price">{{ get_currency($package->discount > 0 ? $package->price - $package->discount : $package->price) }}</span>
                                                        <sub>/{{ __('per_month') }}</sub>
                                                    </div>
                                                </div>

                                                <ul class="pricing__features">
                                                    <li>
                                                        <i class="ri-check-line"></i>
                                                        {{ __('validity') . ' ' . $package->day . ' ' . __('days') }}
                                                    </li>
                                                    <li>
                                                        <i class="ri-check-line"></i>
                                                        {{ __('ads_free_content') }}
                                                    </li>
                                                </ul>

                                                <div class="pricing__btn">
                                                    @if (auth()->user() || $token)
                                                        <a class="btn btn-outline w-100" href="javascript:void(0)"
                                                            onclick="ajaxModal('modal-md', '{{ route('payment.gateway.list', ['id' => $package->id]) }}')">{{ __('get_started') }}</a>
                                                    @else
                                                        <a class="btn btn-outline w-100" href="javascript:void(0)"
                                                            onclick="ajaxModal('modal-md', '{{ route('login') }}')">{{ __('login_required') }}</a>
                                                    @endif
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="annually-plan" role="tabpanel">
                                    <div class="pricing__grid">
                                        @foreach ($annually_packages as $package)
                                            <!-- Pricing Item -->
                                            <div class="pricing__item">
                                                <div class="pricing__header">
                                                    @if ($package->discount)
                                                        <div class="badge badge-2">
                                                            {{ __('save') . ' ' . get_discount_percentage($package->price, $package->discount) }}
                                                        </div>
                                                    @endif
                                                    <h3 class="title"> {{ $package->name }} </h3>
                                                    <div class="pricing__tag">
                                                        <span
                                                            class="price">{{ get_currency($package->discount > 0 ? $package->price - $package->discount : $package->price) }}</span>
                                                        <sub>/{{ __('per_month') }}</sub>
                                                    </div>
                                                </div>

                                                <ul class="pricing__features">
                                                    <li>
                                                        <i class="ri-check-line"></i>
                                                        {{ __('ads_free_content') }}
                                                    </li>
                                                </ul>
                                                <div class="pricing__btn">
                                                    @if (auth()->user() || $token)
                                                        <a class="btn btn-outline w-100" href="javascript:void(0)"
                                                            onclick="ajaxModal('modal-md', '{{ route('payment.gateway.list', ['id' => $package->id]) }}')">{{ __('get_started') }}</a>
                                                    @else
                                                        <a class="btn btn-outline w-100" href="javascript:void(0)"
                                                            onclick="ajaxModal('modal-md', '{{ route('login') }}')">{{ __('login') }}</a>
                                                    @endif
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- All Section Wrapper End -->

@endsection
