@extends('website.layouts.master')
@section('title', __('faq_page'))
@section('content')

    <!-- Breadcrumb Start -->
    <div class="breadcrumb__area">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="breadcrumb__title">
                        <ul class="link">
                            <li><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                            <li>{{ __('help_center') }}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- Contact Section Start -->
    <section class="contact__section pt-35 pb-80">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="tabHeader">
                        <h4 class="title"> {{__('frequently_asked_questions')}} </h4>
                        <div class="tablist">
                            <div class="custom__tabs text-center">
                                <ul class="nav">
                                    <li class="nav-item">
                                        <a class="btn btn-primary rounded-pill py-2" href="{{route('faqs')}}"> {{__('faqs')}} </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="btn btn-outline border-none rounded-pill text-white py-2" href="{{route('contact-us')}}"> {{__('contact_us')}} </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <!-- Tab Content Start -->
                    <div class="accordion__wrapper">
                        <h4 class="accordion__title"> {{__('purchase_&_payment')}} </h4>
                        <div class="accordion" id="accordionExample">
                            @foreach ($payment_faqs as $key => $faq)
                            <div class="accordion__item">
                                <div class="accordion__header" id="headingOne">
                                    <button class="accordion-button {{$key != 0 ? 'collapsed' : ''}}" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseOne{{$key}}" aria-expanded="true"
                                        aria-controls="collapseOne{{$key}}">
                                        {{$faq->question}}
                                    </button>
                                </div>
                                <div id="collapseOne{{$key}}" class="accordion-collapse collapse {{$key == 0 ? 'show' : ''}}"
                                    aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <div class="accordion__content">
                                            <p>
                                                {{$faq->answer}}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    <!-- Accordion -->
                    <div class="accordion__wrapper">
                        <h4 class="accordion__title"> {{__('order_&_return')}} </h4>
                        <div class="accordion" id="accordionExample2">
                            @foreach ($order_faqs as $key => $faq)  
                            <div class="accordion__item">
                                <div class="accordion__header" id="orderheadingOne{{$key}}">
                                    <button class="accordion-button {{$key != 0 ? 'collapsed' : ''}}" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#ordercollapseOne{{$key}}" aria-expanded="true"
                                        aria-controls="ordercollapseOne{{$key}}">
                                        {{$faq->question}}
                                    </button>
                                </div>
                                <div id="ordercollapseOne{{$key}}" class="accordion-collapse collapse {{$key == 0 ? 'show':''}}"
                                    aria-labelledby="orderheadingOne{{$key}}" data-bs-parent="#accordionExample2">
                                    <div class="accordion-body">
                                        <div class="accordion__content">
                                            <p>
                                                {{$faq->answer}}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Contact Section End -->

@endsection
