@extends('website.layouts.master')
@section('title', __('artist_details'))
@section('content')
    <!-- Breadcrumb Start -->
    <div class="breadcrumb__area">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="breadcrumb__title">
                        <ul class="link">
                            <li><a href="index.html">{{ __('home') }}</a></li>
                            <li>{{ __('actor_single_page') }}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- All Section Wrapper Start -->
    <section class="section__Wrapper pt-35 pb-80">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-4">
                    <div class="actor__profile">
                        <div class="thumbs">
                            <img src="{{ str_replace('w154', 'w500', getFileLink('original_image', $artist->star_image, 'stars', '500x500', 'original')) }}"
                                alt="actor" />
                            <div class="social__icon">
                                <ul class="social__list">
                                    <li>
                                        @if (get_star($artist->id, 'facebook'))
                                            <a href="{{ get_star($artist->id, 'facebook') }}" target="_blank"><i
                                                    class="ri-facebook-fill"></i></a>
                                        @endif
                                    </li>
                                    <li>
                                        @if (get_star($artist->id, 'twitter'))
                                            <a href="{{ get_star($artist->id, 'twitter') }}" target="_blank"><i
                                                    class="ri-twitter-x-line"></i></a>
                                        @endif
                                    </li>
                                    <li>
                                        @if (get_star($artist->id, 'instagram'))
                                            <a href="{{ get_star($artist->id, 'instagram') }}" target="_blank"><i
                                                    class="ri-instagram-line"></i></a>
                                        @endif
                                    </li>
                                </ul>

                            </div>
                        </div>
                        <div class="personal__info mt-30">
                            <div class="userDetails d-block">
                                <div class="title__area">
                                    <h4>{{ __('personal_information') }}</h4>
                                </div>

                                <ul class="list mt-20">
                                    <li><span>{{ __('full_name') }}:</span> {{ $artist->star_name }}
                                    </li>
                                    <li><span>{{ __('star_dob') }}:</span>
                                        {{ date('d M Y', strtotime($artist->date_of_birth)) ?? __('not_available') }}
                                    </li>
                                    <li>
                                        <span>{{ __('gender') }}:</span>
                                        @php
                                            $genderMap = [
                                                1 => __('male'),
                                                2 => __('female'),
                                                0 => __('rather_not_say'),
                                            ];
                                            $userGender = $artist->gender;
                                        @endphp
                                        {{ $genderMap[$userGender] ?? __('not_available') }}
                                    </li>
                                    <li><span>{{ __('description') }}:</span>
                                        {{ date($artist->star_desc) ?? __('not_available') }}
                                    </li>

                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-8">
                    <!-- User Tab Start -->
                    <div class="userTab__area ps-5">
                        <!-- Tab Header -->
                        <div class="tabHeader flex-sm-row">
                            <div class="tablist">
                                <div class="custom__tabs flex-wrap text-center">
                                    <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link active" id="tab-01-tab" data-bs-toggle="pill"
                                                data-bs-target="#tab-01" type="button" role="tab"
                                                aria-controls="tab-01" aria-selected="true">
                                                {{ __('all_videos') }}
                                            </button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" id="tab-02-tab" data-bs-toggle="pill"
                                                data-bs-target="#tab-02" type="button" role="tab"
                                                aria-controls="tab-02" aria-selected="false" tabindex="-1">
                                                {{ __('movies') }}
                                            </button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" id="tab-03-tab" data-bs-toggle="pill"
                                                data-bs-target="#tab-03" type="button" role="tab"
                                                aria-controls="tab-03" aria-selected="false" tabindex="-1">
                                                {{ __('tv_series') }}
                                            </button>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- Tab Content Start -->
                        <div class="tab-content">
                            <div class="tab-pane fade active show" id="tab-01" role="tabpanel">
                                @if (count($movies) > 0)
                                    <div class="watch__history">
                                        <div class="userInfo__header">
                                            <h4 class="title">{{ __('movies') }}</h4>
                                        </div>
                                        <div class="position-relative">
                                            <div class="swiper movie__slider2">
                                                <div class="swiper-wrapper">
                                                    @foreach ($movies as $movie)
                                                        <!-- Slide -->
                                                        <div class="swiper-slide">
                                                            <div class="video__card">
                                                                <a href="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                                    class="video__thumb">
                                                                    <img src="{{ getFileLink('thumbnail', $movie->thumbnail, 'movies', '500x750') }}"
                                                                        alt="movie" />
                                                                    <div class="video__btn">
                                                                        <i class="ri-play-fill"></i>
                                                                    </div>
                                                                </a>
                                                                @if ($movie->is_free == 1)
                                                                @elseif ($movie->is_rental == 1)
                                                                    <div class="badge bg-purple">
                                                                        {{ __('rent:') . ' ' . get_currency($movie->rental_price) }}
                                                                    </div>
                                                                @else
                                                                    <div class="badge"> {{ __('premium') }} </div>
                                                                @endif
                                                                <div class="video__content">
                                                                    <div class="content__left">
                                                                        <a href="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                                            class="title">{{ $movie->title }}</a>
                                                                        <div class="video__meta">
                                                                            <div class="meta__item">
                                                                                {{ date('Y', strtotime($movie->release)) }}
                                                                            </div>
                                                                            <div class="meta__item">
                                                                                {{ get_rating($movie->imdb_rating) }}</div>
                                                                            <div class="meta__item">
                                                                                {{ runtime($movie->runtime) }}
                                                                            </div>
                                                                        </div>
                                                                        <div class="video__tag">
                                                                            <span>{{ get_movie_genre($movie->genre) }}</span>
                                                                            @if (get_movie_category($movie->video_type))
                                                                                <span>{{ get_movie_category($movie->video_type) }}</span>
                                                                            @endif
                                                                            <span>{{ get_movie_quality($movie->video_quality) }}</span>
                                                                        </div>
                                                                    </div>
                                                                    <div class="content__right">
                                                                        <div class="action__btn">
                                                                            <a href="javascript:void(0)"
                                                                                class="share__btn share-btn"
                                                                                data-bs-toggle="modal"
                                                                                data-bs-placement="bottom"
                                                                                data-url="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                                                data-bs-target="#shareModal"
                                                                                title="{{ __('share') }}"><i
                                                                                    class="ri-share-line"></i></a>
                                                                            <a href="javascript:void(0)"
                                                                                data-movie-id="{{ $movie->id }}"
                                                                                class="open-save-playlist-modal add__btn"
                                                                                title="{{ __('add_playlist') }}"><i
                                                                                    class="ri-add-line"></i></a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <!-- Slide -->
                                                    @endforeach
                                                </div>
                                            </div>
                                            <div class="swiper__navigation">
                                                <div class="movie-swipe-prev swiper-button-prev">
                                                    <i class="ri-arrow-left-s-line"></i>
                                                </div>
                                                <div class="movie-swipe-next swiper-button-next">
                                                    <i class="ri-arrow-right-s-line"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                @if (count($tv_series) > 0)
                                    <div class="watch__history">
                                        <div class="userInfo__header">
                                            <h4 class="title">{{ __('tv_series') }}</h4>
                                        </div>
                                        <div class="position-relative">
                                            <div class="swiper drama__slider">
                                                <div class="swiper-wrapper">
                                                    @foreach ($tv_series as $series)
                                                        <!-- Slide -->
                                                        <div class="swiper-slide">
                                                            <div class="video__card">
                                                                <a href="{{ route('series.details', ['slug' => $series->slug]) }}"
                                                                    class="video__thumb">
                                                                    <img src="{{ getFileLink('thumbnail', $series->thumbnail, 'movies', '500x750') }}"
                                                                        alt="movie" />
                                                                    <div class="video__btn">
                                                                        <i class="ri-play-fill"></i>
                                                                    </div>
                                                                </a>
                                                                @if ($series->is_free == 1)
                                                                @elseif ($series->is_rental == 1)
                                                                    <div class="badge bg-purple">
                                                                        {{ __('rent:') . ' ' . get_currency($series->rental_price) }}
                                                                    </div>
                                                                @else
                                                                    <div class="badge"> {{ __('premium') }} </div>
                                                                @endif
                                                                <div class="video__content">
                                                                    <div class="content__left">
                                                                        <a href="{{ route('series.details', ['slug' => $series->slug]) }}"
                                                                            class="title">{{ $series->title }}</a>
                                                                        <div class="video__meta">
                                                                            <div class="meta__item">
                                                                                {{ date('Y', strtotime($series->release)) }}
                                                                            </div>
                                                                            <div class="meta__item">
                                                                                {{ get_rating($series->imdb_rating) }}
                                                                            </div>
                                                                            <div class="meta__item">
                                                                                {{ runtime($series->runtime) }}
                                                                            </div>
                                                                        </div>
                                                                        <div class="video__tag">
                                                                            <span>{{ get_movie_genre($series->genre) }}</span>
                                                                            @if (get_movie_category($series->video_type))
                                                                                <span>{{ get_movie_category($series->video_type) }}</span>
                                                                            @endif
                                                                            <span>{{ get_movie_quality($series->video_quality) }}</span>
                                                                        </div>
                                                                    </div>
                                                                    <div class="content__right">
                                                                        <div class="action__btn">
                                                                            <a href="javascript:void(0)"
                                                                                class="share__btn share-btn"
                                                                                data-bs-toggle="modal"
                                                                                data-bs-placement="bottom"
                                                                                data-url="{{ route('series.details', ['slug' => $series->slug]) }}"
                                                                                data-bs-target="#shareModal"
                                                                                title="{{ __('share') }}"><i
                                                                                    class="ri-share-line"></i></a>
                                                                            <a href="javascript:void(0)"
                                                                                data-movie-id="{{ $movie->id }}"
                                                                                class="open-save-playlist-modal add__btn"
                                                                                title="{{ __('add_playlist') }}"><i
                                                                                    class="ri-add-line"></i></a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <!-- Slide -->
                                                    @endforeach
                                                </div>
                                            </div>
                                            <div class="swiper__navigation">
                                                <div class="drama-swipe-prev swiper-button-prev">
                                                    <i class="ri-arrow-left-s-line"></i>
                                                </div>
                                                <div class="drama-swipe-next swiper-button-next">
                                                    <i class="ri-arrow-right-s-line"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            </div>
                            <div class="tab-pane fade" id="tab-02" role="tabpanel">
                                <div class="userInfo__header">
                                    <h4 class="title">{{ __('all_movies') }}</h4>
                                </div>
                                <div class="inner__section">
                                    <div class="grid-5">
                                        @foreach ($movies as $movie)
                                            <div class="video__card">
                                                <a href="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                    class="video__thumb">
                                                    <img src="{{ getFileLink('thumbnail', $movie->thumbnail, 'movies', '500x750') }}"
                                                        alt="movie" />
                                                    <div class="video__btn">
                                                        <i class="ri-play-fill"></i>
                                                    </div>
                                                </a>
                                                @if ($movie->is_free == 1)
                                                @elseif ($movie->is_rental == 1)
                                                    <div class="badge bg-purple">
                                                        {{ __('rent:') . ' ' . get_currency($movie->rental_price) }}
                                                    </div>
                                                @else
                                                    <div class="badge"> {{ __('premium') }} </div>
                                                @endif
                                                <div class="video__content">
                                                    <div class="content__left">
                                                        <a href="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                            class="title">{{ $movie->title }}</a>
                                                        <div class="video__meta">
                                                            <div class="meta__item">
                                                                {{ date('Y', strtotime($movie->release)) }}
                                                            </div>
                                                            <div class="meta__item">
                                                                {{ get_rating($movie->imdb_rating) }}</div>
                                                            <div class="meta__item">
                                                                {{ runtime($movie->runtime) }}
                                                            </div>
                                                        </div>
                                                        <div class="video__tag">
                                                            <span>{{ get_movie_genre($movie->genre) }}</span>
                                                            @if (get_movie_category($movie->video_type))
                                                                <span>{{ get_movie_category($movie->video_type) }}</span>
                                                            @endif
                                                            <span>{{ get_movie_quality($movie->video_quality) }}</span>
                                                        </div>
                                                    </div>
                                                    <div class="content__right">
                                                        <div class="action__btn">
                                                            <a href="javascript:void(0)" class="share__btn share-btn"
                                                                data-bs-toggle="modal" data-bs-placement="bottom"
                                                                data-url="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                                data-bs-target="#shareModal"
                                                                title="{{ __('share') }}"><i
                                                                    class="ri-share-line"></i></a>
                                                            <a href="javascript:void(0)"
                                                                data-movie-id="{{ $movie->id }}"
                                                                class="open-save-playlist-modal add__btn"
                                                                title="{{ __('add_playlist') }}"><i
                                                                    class="ri-add-line"></i></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="tab-03" role="tabpanel">
                                <div class="userInfo__header">
                                    <h4 class="title"> {{ __('all_series') }} </h4>
                                    <!-- <span class="meta">All</span> -->
                                </div>
                                <div class="inner__section">
                                    <div class="grid-5">
                                        <!-- Movies Item -->
                                        @foreach ($tv_series as $series)
                                            <div class="video__card">
                                                <a href="{{ route('series.details', ['slug' => $series->slug]) }}"
                                                    class="video__thumb">
                                                    <img src="{{ getFileLink('thumbnail', $series->thumbnail, 'movies', '500x750') }}"
                                                        alt="movie" />
                                                    <div class="video__btn">
                                                        <i class="ri-play-fill"></i>
                                                    </div>
                                                </a>
                                                @if ($series->is_free == 1)
                                                @elseif ($series->is_rental == 1)
                                                    <div class="badge bg-purple">
                                                        {{ __('rent:') . ' ' . get_currency($series->rental_price) }}
                                                    </div>
                                                @else
                                                    <div class="badge"> {{ __('premium') }} </div>
                                                @endif
                                                <div class="video__content">
                                                    <div class="content__left">
                                                        <a href="{{ route('series.details', ['slug' => $series->slug]) }}"
                                                            class="title">{{ $series->title }}</a>
                                                        <div class="video__meta">
                                                            <div class="meta__item">
                                                                {{ date('Y', strtotime($series->release)) }}
                                                            </div>
                                                            <div class="meta__item">
                                                                {{ get_rating($series->imdb_rating) }}</div>
                                                            <div class="meta__item">
                                                                {{ runtime($series->runtime) }}
                                                            </div>
                                                        </div>
                                                        <div class="video__tag">
                                                            <span>{{ get_movie_genre($series->genre) }}</span>
                                                            @if (get_movie_category($series->video_type))
                                                                <span>{{ get_movie_category($series->video_type) }}</span>
                                                            @endif
                                                            <span>{{ get_movie_quality($series->video_quality) }}</span>
                                                        </div>
                                                    </div>
                                                    <div class="content__right">
                                                        <div class="action__btn">
                                                            <a href="javascript:void(0)" class="share__btn share-btn"
                                                                data-bs-toggle="modal" data-bs-placement="bottom"
                                                                data-url="{{ route('series.details', ['slug' => $series->slug]) }}"
                                                                data-bs-target="#shareModal"
                                                                title="{{ __('share') }}"><i
                                                                    class="ri-share-line"></i></a>
                                                            <a href="javascript:void(0)"
                                                                data-movie-id="{{ $movie->id }}"
                                                                class="open-save-playlist-modal add__btn"
                                                                title="{{ __('add_playlist') }}"><i
                                                                    class="ri-add-line"></i></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                        <!-- Movies Item -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- User Tab End -->
                </div>
            </div>
        </div>
    </section>
    <!-- All Section Wrapper End -->

@endsection
