<div class="load-more-wrapper text-center mt-5" id="test">
    @if ($videos->hasMorePages())
        <button id="load-more" data-next-page="{{ $videos->currentPage() + 1 }}" class="btn btn-primary">
            {{ __('Load More') }}
        </button>
    @endif
</div>
@push('js')
    <script>
        "use strict";
        $(document).on('click', '#load-more', function() {
            let button = $(this);
            let nextPage = button.data('next-page');
            let url = new URL(window.location.href);
            url.searchParams.set('page', nextPage);

            $.ajax({
                url: url.toString(),
                type: 'GET',
                dataType: 'json',
                success: function(response) {
                    // Append the new movie HTML
                    $('#movie-container').append(response.html);
                    // Check if there's more to load
                    if (response.hasMore) {
                        button.data('next-page', response.nextPage);
                    } else {
                        button.remove(); // No more pages
                    }
                }
            });
        });
    </script>
@endpush
