@extends('website.layouts.master')
@section('title', __('home_page'))
@section('content')

    <!-- Feature Slider Start -->
    <section class="featureM__slider pt-120">
        <div class="swiper featureMovie__slider">
            <div class="swiper-wrapper">
                @foreach ($latest as $key => $movie)
                    <!-- Slide 1 -->
                    <div class="swiper-slide">
                        <!-- Video -->
                        <div class="video__container"
                            style="background-image: url({{ getFileLink('original_image', $movie->poster, 'movies', '1700x275', 'original') }});">
                            <div class="poster__thumb">
                                <img src="{{ getFileLink('original_image', $movie->poster, 'movies', '1700x275', 'original') }}"
                                    alt="poster" />
                            </div>
                            @if ($movie->trailler_youtube_source)
                                <video class="video__background" loop muted>
                                    <source src="{{ $movie->trailler_youtube_source }}" type="video/mp4" />
                                </video>
                            @endif
                            <div class="countdown__overlay"></div>
                        </div>
                        @if ($movie->trailler_youtube_source)
                            <div class="video__controls">
                                <button class="control__btn mute__btn"><i class="ri-volume-up-fill"></i></button>
                            </div>
                        @endif
                        <!-- Content -->
                        <div class="banner__text">
                            <div class="video__meta">
                                <div class="meta__item"><i class="ri-star-fill"></i>
                                    {{ number_format($movie->imdb_rating, 1) }} </div>
                                <div class="meta__item"><i class="ri-time-fill"></i> {{ runtime($movie->runtime) }} </div>
                                <div class="meta__item"><i class="ri-calendar-2-fill"></i>
                                    {{ date('Y', strtotime($movie->release)) }} </div>
                            </div>
                            <h1 class="title"> {{ $movie->title }} </h1>
                            <div class="btn__group">
                                <a class="btn btn-primary" href="{{ route('movie.details', ['slug' => $movie->slug]) }}">
                                    <i class="ri-play-fill"></i>{{ __('watch_now') }}
                                </a>
                                <div class="d-flex align-items-center gap-3">
                                    <a href="javascript:void(0)" data-movie-id="{{ $movie->id }}"
                                        class="open-save-playlist-modal solid__btn" title="{{ __('add_playlist') }}"><i
                                            class="ri-add-line"></i>{{ __('add_playlist') }}</a>
                                    <div class="checkbox__custom ms-3">
                                        <input type="checkbox" id="heart-toggle-{{ $key }}"
                                            @if ($movie->isFavoritedByLoggedInUser()) checked @endif
                                            class="heart-checkbox favorite-toggle-btn" data-id="{{ $movie->id }}"
                                            data-type="movie" data-bs-toggle="tooltip" data-bs-placement="bottom"
                                            title="{{ $movie->isFavoritedByLoggedInUser() ? __('remove_from_favorite') : __('add_to_favorites') }}" />
                                        <label for="heart-toggle-{{ $key }}" class="heart-label">
                                            <i class="ri-heart-line"></i>
                                            <i class="ri-heart-fill"></i>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="featureMovie__navigation swiper__navigation">
                <div class="featureMovie-swipe-prev swiper-button-prev">
                    <i class="ri-arrow-left-s-line"></i>
                </div>
                <div class="featureMovie-swipe-next swiper-button-next">
                    <i class="ri-arrow-right-s-line"></i>
                </div>
            </div>
            <div class="featureMovie__pagination swiper__pagination">
                <div class="featureMovie-pagination"></div>
            </div>
        </div>
    </section>
    <!-- Feature Slider End -->



    @if (count($top_rated))
        <!-- Video Section Start -->
        <section class="section__Wrapper pt-35">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="section__title">
                            <h2 class="title">{{ __('top_rating_movies') }}</h2>
                            <div class="view__btn">
                                <a href="{{ route('all.movies', ['type' => 'top-rating']) }}">{{ __('view_all') }}</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="position-relative">
                            <div class="swiper movie__slider">
                                <div class="swiper-wrapper">
                                    @foreach ($top_rated as $movie)
                                        <!-- Slide -->
                                        <div class="swiper-slide">
                                            <div class="video__card">
                                                <a href="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                    class="video__thumb">
                                                    <img src="{{ getFileLink('thumbnail', $movie->thumbnail, 'movies', '500x750') }}"
                                                        alt="movie" />
                                                    <div class="video__btn">
                                                        <i class="ri-play-fill"></i>
                                                    </div>
                                                </a>
                                                @if ($movie->is_free == 1)
                                                @elseif ($movie->is_rental == 1)
                                                    <div class="badge bg-purple"> {{ __('rent:').' '.get_currency($movie->rental_price) }} </div>
                                                @else
                                                    <div class="badge"> {{ __('premium') }} </div>
                                                @endif
                                                <div class="video__content">
                                                    <div class="content__left">
                                                        <a href="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                            class="title">{{ $movie->title }}</a>
                                                        <div class="video__meta">
                                                            <div class="meta__item">
                                                                {{ date('Y', strtotime($movie->release)) }}
                                                            </div>
                                                            <div class="meta__item">
                                                                {{ get_rating($movie->imdb_rating) }}</div>
                                                            <div class="meta__item">{{ runtime($movie->runtime) }}
                                                            </div>
                                                        </div>
                                                        <div class="video__tag">
                                                            <span>{{ get_movie_genre($movie->genre) }}</span>
                                                            @if (get_movie_category($movie->video_type))
                                                                <span>{{ get_movie_category($movie->video_type) }}</span>
                                                            @endif
                                                            <span>{{ get_movie_quality($movie->video_quality) }}</span>
                                                        </div>
                                                    </div>
                                                    <div class="content__right">
                                                        <div class="action__btn">
                                                            <a href="javascript:void(0)" class="share__btn share-btn"
                                                                data-bs-toggle="modal" data-bs-placement="bottom"
                                                                data-url="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                                data-bs-target="#shareModal" title="{{ __('share') }}"><i
                                                                    class="ri-share-line"></i></a>
                                                            <a href="javascript:void(0)"
                                                                data-movie-id="{{ $movie->id }}"
                                                                class="open-save-playlist-modal add__btn"
                                                                title="{{ __('add_playlist') }}"><i
                                                                    class="ri-add-line"></i></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                            <div class="swiper__navigation">
                                <div class="movie-swipe-prev swiper-button-prev">
                                    <i class="ri-arrow-left-s-line"></i>
                                </div>
                                <div class="movie-swipe-next swiper-button-next">
                                    <i class="ri-arrow-right-s-line"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </section>
        <!-- Video Section End -->
    @endif

    @if (count($latest))
        <!-- Video Section Start -->
        <section class="section__Wrapper pt-35">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="section__title">
                            <h2 class="title">{{ __('latest_movies') }}</h2>
                            <div class="view__btn">
                                <a href="{{ route('all.movies', ['type' => 'latest']) }}">{{ __('view_all') }}</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="position-relative">
                            <div class="swiper movie__slider">
                                <div class="swiper-wrapper">
                                    @foreach ($latest as $movie)
                                        <!-- Slide -->
                                        <div class="swiper-slide">
                                            <div class="video__card">
                                                <a href="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                    class="video__thumb">
                                                    <img src="{{ getFileLink('thumbnail', $movie->thumbnail, 'movies', '500x750') }}"
                                                        alt="movie" />
                                                    <div class="video__btn">
                                                        <i class="ri-play-fill"></i>
                                                    </div>
                                                </a>
                                                @if ($movie->is_free == 1)
                                                @elseif ($movie->is_rental == 1)
                                                    <div class="badge bg-purple"> {{ __('rent:').' '.get_currency($movie->rental_price) }} </div>
                                                @else
                                                    <div class="badge"> {{ __('premium') }} </div>
                                                @endif
                                                <div class="video__content">
                                                    <div class="content__left">
                                                        <a href="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                            class="title">{{ $movie->title }}</a>
                                                        <div class="video__meta">
                                                            <div class="meta__item">
                                                                {{ date('Y', strtotime($movie->release)) }}
                                                            </div>
                                                            <div class="meta__item">
                                                                {{ get_rating($movie->imdb_rating) }}</div>
                                                            <div class="meta__item">{{ runtime($movie->runtime) }}
                                                            </div>
                                                        </div>
                                                        <div class="video__tag">
                                                            <span>{{ get_movie_genre($movie->genre) }}</span>
                                                            @if (get_movie_category($movie->video_type))
                                                                <span>{{ get_movie_category($movie->video_type) }}</span>
                                                            @endif
                                                            <span>{{ get_movie_quality($movie->video_quality) }}</span>
                                                        </div>
                                                    </div>
                                                    <div class="content__right">
                                                        <div class="action__btn">
                                                            <a href="javascript:void(0)" class="share__btn share-btn"
                                                                data-bs-toggle="modal" data-bs-placement="bottom"
                                                                data-url="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                                data-bs-target="#shareModal"
                                                                title="{{ __('share') }}"><i
                                                                    class="ri-share-line"></i></a>
                                                            <a href="javascript:void(0)"
                                                                data-movie-id="{{ $movie->id }}"
                                                                class="open-save-playlist-modal add__btn"
                                                                title="{{ __('add_playlist') }}"><i
                                                                    class="ri-add-line"></i></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                            <div class="swiper__navigation">
                                <div class="movie-swipe-prev swiper-button-prev">
                                    <i class="ri-arrow-left-s-line"></i>
                                </div>
                                <div class="movie-swipe-next swiper-button-next">
                                    <i class="ri-arrow-right-s-line"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </section>
        <!-- Video Section End -->
    @endif

    @if (count($trending))
        <!-- Video Section Start -->
        <section class="section__Wrapper pt-35">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="section__title">
                            <h2 class="title">{{ __('trending_movies') }}</h2>
                            <div class="view__btn">
                                <a href="{{ route('all.movies', ['type' => 'trending']) }}">{{ __('view_all') }}</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="position-relative">
                            <div class="swiper movie__slider">
                                <div class="swiper-wrapper">
                                    @foreach ($trending as $movie)
                                        <!-- Slide -->
                                        <div class="swiper-slide">
                                            <div class="video__card">
                                                <a href="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                    class="video__thumb">
                                                    <img src="{{ getFileLink('thumbnail', $movie->thumbnail, 'movies', '500x750') }}"
                                                        alt="movie" />
                                                    <div class="video__btn">
                                                        <i class="ri-play-fill"></i>
                                                    </div>
                                                </a>
                                                @if ($movie->is_free == 1)
                                                @elseif ($movie->is_rental == 1)
                                                    <div class="badge bg-purple"> {{ __('rent:').' '.get_currency($movie->rental_price) }} </div>
                                                @else
                                                    <div class="badge"> {{ __('premium') }} </div>
                                                @endif
                                                <div class="video__content">
                                                    <div class="content__left">
                                                        <a href="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                            class="title">{{ $movie->title }}</a>
                                                        <div class="video__meta">
                                                            <div class="meta__item">
                                                                {{ date('Y', strtotime($movie->release)) }}
                                                            </div>
                                                            <div class="meta__item">
                                                                {{ get_rating($movie->imdb_rating) }}</div>
                                                            <div class="meta__item">{{ runtime($movie->runtime) }}
                                                            </div>
                                                        </div>
                                                        <div class="video__tag">
                                                            <span>{{ get_movie_genre($movie->genre) }}</span>
                                                            @if (get_movie_category($movie->video_type))
                                                                <span>{{ get_movie_category($movie->video_type) }}</span>
                                                            @endif
                                                            <span>{{ get_movie_quality($movie->video_quality) }}</span>
                                                        </div>
                                                    </div>
                                                    <div class="content__right">
                                                        <div class="action__btn">
                                                            <a href="javascript:void(0)" class="share__btn share-btn"
                                                                data-bs-toggle="modal" data-bs-placement="bottom"
                                                                data-url="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                                data-bs-target="#shareModal"
                                                                title="{{ __('share') }}"><i
                                                                    class="ri-share-line"></i></a>
                                                            <a href="javascript:void(0)"
                                                                data-movie-id="{{ $movie->id }}"
                                                                class="open-save-playlist-modal add__btn"
                                                                title="{{ __('add_playlist') }}"><i
                                                                    class="ri-add-line"></i></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                            <div class="swiper__navigation">
                                <div class="movie-swipe-prev swiper-button-prev">
                                    <i class="ri-arrow-left-s-line"></i>
                                </div>
                                <div class="movie-swipe-next swiper-button-next">
                                    <i class="ri-arrow-right-s-line"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </section>
        <!-- Video Section End -->
    @endif

    @if (count($blockbuster))
        <!-- Video Section Start -->
        <section class="section__Wrapper pt-35">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="section__title">
                            <h2 class="title">{{ __('blockbuster_movies') }}</h2>
                            <div class="view__btn">
                                <a href="{{ route('all.movies', ['type' => 'blockbuster']) }}">{{ __('view_all') }}</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="position-relative">
                            <div class="swiper movie__slider">
                                <div class="swiper-wrapper">
                                    @foreach ($blockbuster as $movie)
                                        <!-- Slide -->
                                        <div class="swiper-slide">
                                            <div class="video__card">
                                                <a href="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                    class="video__thumb">
                                                    <img src="{{ getFileLink('thumbnail', $movie->thumbnail, 'movies', '500x750') }}"
                                                        alt="movie" />
                                                    <div class="video__btn">
                                                        <i class="ri-play-fill"></i>
                                                    </div>
                                                </a>
                                                @if ($movie->is_free == 1)
                                                @elseif ($movie->is_rental == 1)
                                                    <div class="badge bg-purple"> {{ __('rent:').' '.get_currency($movie->rental_price) }} </div>
                                                @else
                                                    <div class="badge"> {{ __('premium') }} </div>
                                                @endif
                                                <div class="video__content">
                                                    <div class="content__left">
                                                        <a href="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                            class="title">{{ $movie->title }}</a>
                                                        <div class="video__meta">
                                                            <div class="meta__item">
                                                                {{ date('Y', strtotime($movie->release)) }}
                                                            </div>
                                                            <div class="meta__item">
                                                                {{ get_rating($movie->imdb_rating) }}</div>
                                                            <div class="meta__item">{{ runtime($movie->runtime) }}
                                                            </div>
                                                        </div>
                                                        <div class="video__tag">
                                                            <span>{{ get_movie_genre($movie->genre) }}</span>
                                                            @if (get_movie_category($movie->video_type))
                                                                <span>{{ get_movie_category($movie->video_type) }}</span>
                                                            @endif
                                                            <span>{{ get_movie_quality($movie->video_quality) }}</span>
                                                        </div>
                                                    </div>
                                                    <div class="content__right">
                                                        <div class="action__btn">
                                                            <a href="javascript:void(0)" class="share__btn share-btn"
                                                                data-bs-toggle="modal" data-bs-placement="bottom"
                                                                data-url="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                                data-bs-target="#shareModal"
                                                                title="{{ __('share') }}"><i
                                                                    class="ri-share-line"></i></a>
                                                            <a href="javascript:void(0)"
                                                                data-movie-id="{{ $movie->id }}"
                                                                class="open-save-playlist-modal add__btn"
                                                                title="{{ __('add_playlist') }}"><i
                                                                    class="ri-add-line"></i></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                            <div class="swiper__navigation">
                                <div class="movie-swipe-prev swiper-button-prev">
                                    <i class="ri-arrow-left-s-line"></i>
                                </div>
                                <div class="movie-swipe-next swiper-button-next">
                                    <i class="ri-arrow-right-s-line"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </section>
        <!-- Video Section End -->
    @endif

    @if (count($real_life_story))
        <!-- Video Section Start -->
        <section class="section__Wrapper pt-35">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="section__title">
                            <h2 class="title">{{ __('real_life_story') }}</h2>
                            <div class="view__btn">
                                <a
                                    href="{{ route('all.movies', ['type' => 'real-life-story']) }}">{{ __('view_all') }}</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="position-relative">
                            <div class="swiper movie__slider">
                                <div class="swiper-wrapper">
                                    @foreach ($real_life_story as $movie)
                                        <!-- Slide -->
                                        <div class="swiper-slide">
                                            <div class="video__card">
                                                <a href="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                    class="video__thumb">
                                                    <img src="{{ getFileLink('thumbnail', $movie->thumbnail, 'movies', '500x750') }}"
                                                        alt="movie" />
                                                    <div class="video__btn">
                                                        <i class="ri-play-fill"></i>
                                                    </div>
                                                </a>
                                                @if ($movie->is_free == 1)
                                                @elseif ($movie->is_rental == 1)
                                                    <div class="badge bg-purple"> {{ __('rent:').' '.get_currency($movie->rental_price) }} </div>
                                                @else
                                                    <div class="badge"> {{ __('premium') }} </div>
                                                @endif
                                                <div class="video__content">
                                                    <div class="content__left">
                                                        <a href="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                            class="title">{{ $movie->title }}</a>
                                                        <div class="video__meta">
                                                            <div class="meta__item">
                                                                {{ date('Y', strtotime($movie->release)) }}
                                                            </div>
                                                            <div class="meta__item">
                                                                {{ get_rating($movie->imdb_rating) }}</div>
                                                            <div class="meta__item">{{ runtime($movie->runtime) }}
                                                            </div>
                                                        </div>
                                                        <div class="video__tag">
                                                            <span>{{ get_movie_genre($movie->genre) }}</span>
                                                            @if (get_movie_category($movie->video_type))
                                                                <span>{{ get_movie_category($movie->video_type) }}</span>
                                                            @endif
                                                            <span>{{ get_movie_quality($movie->video_quality) }}</span>
                                                        </div>
                                                    </div>
                                                    <div class="content__right">
                                                        <div class="action__btn">
                                                            <a href="javascript:void(0)" class="share__btn share-btn"
                                                                data-bs-toggle="modal" data-bs-placement="bottom"
                                                                data-url="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                                data-bs-target="#shareModal"
                                                                title="{{ __('share') }}"><i
                                                                    class="ri-share-line"></i></a>
                                                            <a href="javascript:void(0)"
                                                                data-movie-id="{{ $movie->id }}"
                                                                class="open-save-playlist-modal add__btn"
                                                                title="{{ __('add_playlist') }}"><i
                                                                    class="ri-add-line"></i></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                            <div class="swiper__navigation">
                                <div class="movie-swipe-prev swiper-button-prev">
                                    <i class="ri-arrow-left-s-line"></i>
                                </div>
                                <div class="movie-swipe-next swiper-button-next">
                                    <i class="ri-arrow-right-s-line"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </section>
        <!-- Video Section End -->
    @endif

    @if (count($featured))
        <!-- Video Section Start -->
        <section class="section__Wrapper pt-35">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="section__title">
                            <h2 class="title">{{ __('featured_movies') }}</h2>
                            <div class="view__btn">
                                <a href="{{ route('all.movies', ['type' => 'featured']) }}">{{ __('view_all') }}</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="position-relative">
                            <div class="swiper movie__slider">
                                <div class="swiper-wrapper">
                                    @foreach ($featured as $movie)
                                        <!-- Slide -->
                                        <div class="swiper-slide">
                                            <div class="video__card">
                                                <a href="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                    class="video__thumb">
                                                    <img src="{{ getFileLink('thumbnail', $movie->thumbnail, 'movies', '500x750') }}"
                                                        alt="movie" />
                                                    <div class="video__btn">
                                                        <i class="ri-play-fill"></i>
                                                    </div>
                                                </a>
                                                @if ($movie->is_free == 1)
                                                @elseif ($movie->is_rental == 1)
                                                    <div class="badge bg-purple"> {{ __('rent:').' '.get_currency($movie->rental_price) }} </div>
                                                @else
                                                    <div class="badge"> {{ __('premium') }} </div>
                                                @endif
                                                <div class="video__content">
                                                    <div class="content__left">
                                                        <a href="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                            class="title">{{ $movie->title }}</a>
                                                        <div class="video__meta">
                                                            <div class="meta__item">
                                                                {{ date('Y', strtotime($movie->release)) }}
                                                            </div>
                                                            <div class="meta__item">
                                                                {{ get_rating($movie->imdb_rating) }}</div>
                                                            <div class="meta__item">{{ runtime($movie->runtime) }}
                                                            </div>
                                                        </div>
                                                        <div class="video__tag">
                                                            <span>{{ get_movie_genre($movie->genre) }}</span>
                                                            @if (get_movie_category($movie->video_type))
                                                                <span>{{ get_movie_category($movie->video_type) }}</span>
                                                            @endif
                                                            <span>{{ get_movie_quality($movie->video_quality) }}</span>
                                                        </div>
                                                    </div>
                                                    <div class="content__right">
                                                        <div class="action__btn">
                                                            <a href="javascript:void(0)" class="share__btn share-btn"
                                                                data-bs-toggle="modal" data-bs-placement="bottom"
                                                                data-url="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                                data-bs-target="#shareModal"
                                                                title="{{ __('share') }}"><i
                                                                    class="ri-share-line"></i></a>
                                                            <a href="javascript:void(0)"
                                                                data-movie-id="{{ $movie->id }}"
                                                                class="open-save-playlist-modal add__btn"
                                                                title="{{ __('add_playlist') }}"><i
                                                                    class="ri-add-line"></i></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                            <div class="swiper__navigation">
                                <div class="movie-swipe-prev swiper-button-prev">
                                    <i class="ri-arrow-left-s-line"></i>
                                </div>
                                <div class="movie-swipe-next swiper-button-next">
                                    <i class="ri-arrow-right-s-line"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </section>
        <!-- Video Section End -->
    @endif

    @if (count($popular))
        <!-- Video Section Start -->
        <section class="section__Wrapper pt-35">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="section__title">
                            <h2 class="title">{{ __('popular_movies') }}</h2>
                            <div class="view__btn">
                                <a href="{{ route('all.movies', ['type' => 'popular']) }}">{{ __('view_all') }}</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="position-relative">
                            <div class="swiper movie__slider">
                                <div class="swiper-wrapper">
                                    @foreach ($popular as $movie)
                                        <!-- Slide -->
                                        <div class="swiper-slide">
                                            <div class="video__card">
                                                <a href="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                    class="video__thumb">
                                                    <img src="{{ getFileLink('thumbnail', $movie->thumbnail, 'movies', '500x750') }}"
                                                        alt="movie" />
                                                    <div class="video__btn">
                                                        <i class="ri-play-fill"></i>
                                                    </div>
                                                </a>
                                                @if ($movie->is_free == 1)
                                                @elseif ($movie->is_rental == 1)
                                                    <div class="badge bg-purple"> {{ __('rent:').' '.get_currency($movie->rental_price) }} </div>
                                                @else
                                                    <div class="badge"> {{ __('premium') }} </div>
                                                @endif
                                                <div class="video__content">
                                                    <div class="content__left">
                                                        <a href="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                            class="title">{{ $movie->title }}</a>
                                                        <div class="video__meta">
                                                            <div class="meta__item">
                                                                {{ date('Y', strtotime($movie->release)) }}
                                                            </div>
                                                            <div class="meta__item">
                                                                {{ get_rating($movie->imdb_rating) }}</div>
                                                            <div class="meta__item">{{ runtime($movie->runtime) }}
                                                            </div>
                                                        </div>
                                                        <div class="video__tag">
                                                            <span>{{ get_movie_genre($movie->genre) }}</span>
                                                            @if (get_movie_category($movie->video_type))
                                                                <span>{{ get_movie_category($movie->video_type) }}</span>
                                                            @endif
                                                            <span>{{ get_movie_quality($movie->video_quality) }}</span>
                                                        </div>
                                                    </div>
                                                    <div class="content__right">
                                                        <div class="action__btn">
                                                            <a href="javascript:void(0)" class="share__btn share-btn"
                                                                data-bs-toggle="modal" data-bs-placement="bottom"
                                                                data-url="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                                data-bs-target="#shareModal"
                                                                title="{{ __('share') }}"><i
                                                                    class="ri-share-line"></i></a>
                                                            <a href="javascript:void(0)"
                                                                data-movie-id="{{ $movie->id }}"
                                                                class="open-save-playlist-modal add__btn"
                                                                title="{{ __('add_playlist') }}"><i
                                                                    class="ri-add-line"></i></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                            <div class="swiper__navigation">
                                <div class="movie-swipe-prev swiper-button-prev">
                                    <i class="ri-arrow-left-s-line"></i>
                                </div>
                                <div class="movie-swipe-next swiper-button-next">
                                    <i class="ri-arrow-right-s-line"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </section>
        <!-- Video Section End -->
    @endif

    @if (count($recommended))
        <!-- Video Section Start -->
        <section class="section__Wrapper pt-35">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="section__title">
                            <h2 class="title">{{ __('recommended_movies') }}</h2>
                            <div class="view__btn">
                                <a href="{{ route('all.movies', ['type' => 'recommended']) }}">{{ __('view_all') }}</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="position-relative">
                            <div class="swiper movie__slider">
                                <div class="swiper-wrapper">
                                    @foreach ($recommended as $movie)
                                        <!-- Slide -->
                                        <div class="swiper-slide">
                                            <div class="video__card">
                                                <a href="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                    class="video__thumb">
                                                    <img src="{{ getFileLink('thumbnail', $movie->thumbnail, 'movies', '500x750') }}"
                                                        alt="movie" />
                                                    <div class="video__btn">
                                                        <i class="ri-play-fill"></i>
                                                    </div>
                                                </a>
                                                @if ($movie->is_free == 1)
                                                @elseif ($movie->is_rental == 1)
                                                    <div class="badge bg-purple"> {{ __('rent:').' '.get_currency($movie->rental_price) }} </div>
                                                @else
                                                    <div class="badge"> {{ __('premium') }} </div>
                                                @endif
                                                <div class="video__content">
                                                    <div class="content__left">
                                                        <a href="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                            class="title">{{ $movie->title }}</a>
                                                        <div class="video__meta">
                                                            <div class="meta__item">
                                                                {{ date('Y', strtotime($movie->release)) }}
                                                            </div>
                                                            <div class="meta__item">
                                                                {{ get_rating($movie->imdb_rating) }}</div>
                                                            <div class="meta__item">{{ runtime($movie->runtime) }}
                                                            </div>
                                                        </div>
                                                        <div class="video__tag">
                                                            <span>{{ get_movie_genre($movie->genre) }}</span>
                                                            @if (get_movie_category($movie->video_type))
                                                                <span>{{ get_movie_category($movie->video_type) }}</span>
                                                            @endif
                                                            <span>{{ get_movie_quality($movie->video_quality) }}</span>
                                                        </div>
                                                    </div>
                                                    <div class="content__right">
                                                        <div class="action__btn">
                                                            <a href="javascript:void(0)" class="share__btn share-btn"
                                                                data-bs-toggle="modal" data-bs-placement="bottom"
                                                                data-url="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                                                data-bs-target="#shareModal"
                                                                title="{{ __('share') }}"><i
                                                                    class="ri-share-line"></i></a>
                                                            <a href="javascript:void(0)"
                                                                data-movie-id="{{ $movie->id }}"
                                                                class="open-save-playlist-modal add__btn"
                                                                title="{{ __('add_playlist') }}"><i
                                                                    class="ri-add-line"></i></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                            <div class="swiper__navigation">
                                <div class="movie-swipe-prev swiper-button-prev">
                                    <i class="ri-arrow-left-s-line"></i>
                                </div>
                                <div class="movie-swipe-next swiper-button-next">
                                    <i class="ri-arrow-right-s-line"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </section>
        <!-- Video Section End -->
    @endif

@endsection
