    <!-- Rent Video Section Start -->
    <section class="rentVideo__section"
        style="background: url('{{ getFileLink('poster', $movie->poster, 'movies', '1920x1080', 'original') }}')">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-lg-6 col-md-6">
                    <div class="rentVideo__wrapper">
                        <div class="hero__text text-start">
                            <div class="video__meta">
                                <div class="meta__item"><i class="ri-star-fill"></i>{{ get_rating($movie->imdb_rating) }}
                                </div>
                                <div class="meta__item"><i class="ri-time-fill"></i>
                                    {{ runtime($movie->runtime) }} </div>
                                <div class="meta__item"><i
                                        class="ri-calendar-2-fill"></i>{{ date('Y', strtotime($movie->release)) }}
                                </div>
                            </div>

                            <div class="video__tag d-flex">
                                <span>{{ get_video_quality($movie->video_quality, 'quality') }}</span>
                                <span>{{ get_genre($movie->genre, 0, 'name') }}</span>
                                @if ($movie->video_type)
                                    <span> {{ get_video_type($movie->video_type, 'video_type') }} </span>
                                @endif
                                @if ($movie->is_blockbuster)
                                    <span> {{ __('block_buster') }} </span>
                                @endif
                            </div>
                            <h1 class="title"> {{ $movie->title }} </h1>
                            <p class="desc">
                                {{ $movie->description }}
                            </p>

                            <div class="btn__group justify-content-start flex-wrap">
                               
                                @if (
                                    (is_rent_expire('movie', $movie->id) && is_rental('movie', $movie->id)) ||
                                        is_free('movie', $movie->id) ||
                                        (check_subscription() && !is_rental('movie', $movie->id)) ||
                                        is_admin())
                                    @if (get_movie_url($movie->id))
                                        <div class="dropdown__btn">
                                            <div class="selected drop__action btn btn-primary selected">
                                                <i class="ri-play-fill"></i>
                                                {{ __('watch_now') }}
                                            </div>
                                            <ul class="dropdown__list">
                                                @foreach (movie_files($movie->id) as $key => $server)
                                                    <li>
                                                        <a
                                                            href="{{ route('watch.movie', ['slug' => $movie->slug, 'key' => $server->stream_key]) }}">
                                                            {{ $server->label }} </a>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @endif
                                @else
                                    @if (auth()->user() && !is_free('movie', $movie->id) && is_rental('movie', $movie->id))
                                        <a class="btn btn-primary" href="javascript:void(0)"
                                            onclick="ajaxModal('modal-md', '{{ route('payment.gateway.list', ['id' => $movie->id, 'type' => 'rental', 'video_type' => 'movie']) }}')">
                                            <svg width="16" height="14" viewBox="0 0 16 14" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M15.1773 2.04376C14.9337 1.94228 14.6654 1.91561 14.4066 1.96713C14.1478 2.01866 13.9102 2.14605 13.724 2.33309L12 4.05709L8.94267 0.999757C8.69263 0.749796 8.35355 0.609375 8 0.609375C7.64645 0.609375 7.30737 0.749796 7.05733 0.999757L4 4.05709L2.276 2.33309C2.08953 2.14668 1.85198 2.01974 1.59338 1.96831C1.33477 1.91689 1.06673 1.94329 0.823127 2.04419C0.579528 2.14508 0.37131 2.31593 0.224798 2.53515C0.0782854 2.75436 5.62991e-05 3.01209 0 3.27576L0 10.3331C0.00105857 11.2168 0.352588 12.0641 0.97748 12.6889C1.60237 13.3138 2.4496 13.6654 3.33333 13.6664H12.6667C13.5504 13.6654 14.3976 13.3138 15.0225 12.6889C15.6474 12.0641 15.9989 11.2168 16 10.3331V3.27576C16.0001 3.01207 15.9219 2.75428 15.7755 2.53499C15.6291 2.3157 15.4209 2.14475 15.1773 2.04376ZM14.6667 10.3331C14.6667 10.8635 14.456 11.3722 14.0809 11.7473C13.7058 12.1224 13.1971 12.3331 12.6667 12.3331H3.33333C2.8029 12.3331 2.29419 12.1224 1.91912 11.7473C1.54405 11.3722 1.33333 10.8635 1.33333 10.3331V3.27576L3.52867 5.47109C3.65369 5.59607 3.82322 5.66628 4 5.66628C4.17678 5.66628 4.34631 5.59607 4.47133 5.47109L8 1.94242L11.5287 5.47109C11.6537 5.59607 11.8232 5.66628 12 5.66628C12.1768 5.66628 12.3463 5.59607 12.4713 5.47109L14.6667 3.27576V10.3331Z"
                                                    fill="white"></path>
                                            </svg>
                                            <span> {{ __('rent') . ' ' . get_currency($movie->rental_price) }} </span>
                                        </a>
                                    @elseif (!auth()->user() && is_rental('movie', $movie->id))
                                        <a class="btn btn-white active" href="javascript:void(0)"
                                            onclick="ajaxModal('modal-md', '{{ route('login') }}')">
                                            <svg width="16" height="14" viewBox="0 0 16 14" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M15.1773 2.04376C14.9337 1.94228 14.6654 1.91561 14.4066 1.96713C14.1478 2.01866 13.9102 2.14605 13.724 2.33309L12 4.05709L8.94267 0.999757C8.69263 0.749796 8.35355 0.609375 8 0.609375C7.64645 0.609375 7.30737 0.749796 7.05733 0.999757L4 4.05709L2.276 2.33309C2.08953 2.14668 1.85198 2.01974 1.59338 1.96831C1.33477 1.91689 1.06673 1.94329 0.823127 2.04419C0.579528 2.14508 0.37131 2.31593 0.224798 2.53515C0.0782854 2.75436 5.62991e-05 3.01209 0 3.27576L0 10.3331C0.00105857 11.2168 0.352588 12.0641 0.97748 12.6889C1.60237 13.3138 2.4496 13.6654 3.33333 13.6664H12.6667C13.5504 13.6654 14.3976 13.3138 15.0225 12.6889C15.6474 12.0641 15.9989 11.2168 16 10.3331V3.27576C16.0001 3.01207 15.9219 2.75428 15.7755 2.53499C15.6291 2.3157 15.4209 2.14475 15.1773 2.04376ZM14.6667 10.3331C14.6667 10.8635 14.456 11.3722 14.0809 11.7473C13.7058 12.1224 13.1971 12.3331 12.6667 12.3331H3.33333C2.8029 12.3331 2.29419 12.1224 1.91912 11.7473C1.54405 11.3722 1.33333 10.8635 1.33333 10.3331V3.27576L3.52867 5.47109C3.65369 5.59607 3.82322 5.66628 4 5.66628C4.17678 5.66628 4.34631 5.59607 4.47133 5.47109L8 1.94242L11.5287 5.47109C11.6537 5.59607 11.8232 5.66628 12 5.66628C12.1768 5.66628 12.3463 5.59607 12.4713 5.47109L14.6667 3.27576V10.3331Z"
                                                    fill="white"></path>
                                            </svg>
                                            <span> {{ __('rent') . ' ' . get_currency($movie->rental_price) }} </span>
                                        </a>
                                    @else
                                        <a href="{{ route('packages') }}" class="btn btn-primary">
                                            <svg width="16" height="14" viewBox="0 0 16 14" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M15.1773 2.04376C14.9337 1.94228 14.6654 1.91561 14.4066 1.96713C14.1478 2.01866 13.9102 2.14605 13.724 2.33309L12 4.05709L8.94267 0.999757C8.69263 0.749796 8.35355 0.609375 8 0.609375C7.64645 0.609375 7.30737 0.749796 7.05733 0.999757L4 4.05709L2.276 2.33309C2.08953 2.14668 1.85198 2.01974 1.59338 1.96831C1.33477 1.91689 1.06673 1.94329 0.823127 2.04419C0.579528 2.14508 0.37131 2.31593 0.224798 2.53515C0.0782854 2.75436 5.62991e-05 3.01209 0 3.27576L0 10.3331C0.00105857 11.2168 0.352588 12.0641 0.97748 12.6889C1.60237 13.3138 2.4496 13.6654 3.33333 13.6664H12.6667C13.5504 13.6654 14.3976 13.3138 15.0225 12.6889C15.6474 12.0641 15.9989 11.2168 16 10.3331V3.27576C16.0001 3.01207 15.9219 2.75428 15.7755 2.53499C15.6291 2.3157 15.4209 2.14475 15.1773 2.04376ZM14.6667 10.3331C14.6667 10.8635 14.456 11.3722 14.0809 11.7473C13.7058 12.1224 13.1971 12.3331 12.6667 12.3331H3.33333C2.8029 12.3331 2.29419 12.1224 1.91912 11.7473C1.54405 11.3722 1.33333 10.8635 1.33333 10.3331V3.27576L3.52867 5.47109C3.65369 5.59607 3.82322 5.66628 4 5.66628C4.17678 5.66628 4.34631 5.59607 4.47133 5.47109L8 1.94242L11.5287 5.47109C11.6537 5.59607 11.8232 5.66628 12 5.66628C12.1768 5.66628 12.3463 5.59607 12.4713 5.47109L14.6667 3.27576V10.3331Z"
                                                    fill="white"></path>
                                            </svg>
                                            <span>{{ __('subscribe') }}</span>
                                        </a>
                                    @endif
                                @endif

                                <div class="movieDetails__info d-block m-0">
                                    <div class="action__area mt-0 justify-content-lg-end">
                                        <a href="javascript:void(0)"
                                            style="background-color: @if ($movie->isFavoritedByLoggedInUser()) #D50055 @endif;"
                                            class="favorite-toggle-btn" data-id="{{ $movie->id }}" data-type="movie"
                                            data-bs-toggle="tooltip" data-bs-placement="bottom"
                                            title="{{ $movie->isFavoritedByLoggedInUser() ? __('remove_from_favorite') : __('add_to_favorites') }}">
                                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0_930_3283)">
                                                    <path
                                                        d="M11.667 1.27783C10.9163 1.28951 10.1819 1.49907 9.53814 1.88535C8.89434 2.27162 8.36387 2.82094 8.0003 3.47783C7.63672 2.82094 7.10625 2.27162 6.46246 1.88535C5.81866 1.49907 5.08433 1.28951 4.33363 1.27783C3.13692 1.32983 2.00944 1.85333 1.19749 2.73399C0.385537 3.61464 -0.0448693 4.78085 0.000297715 5.97783C0.000297715 9.00917 3.19096 12.3198 5.86696 14.5645C6.46444 15.0666 7.21987 15.3418 8.0003 15.3418C8.78073 15.3418 9.53615 15.0666 10.1336 14.5645C12.8096 12.3198 16.0003 9.00917 16.0003 5.97783C16.0455 4.78085 15.6151 3.61464 14.8031 2.73399C13.9912 1.85333 12.8637 1.32983 11.667 1.27783ZM9.27696 13.5445C8.91962 13.8454 8.46747 14.0104 8.0003 14.0104C7.53313 14.0104 7.08098 13.8454 6.72363 13.5445C3.2983 10.6705 1.33363 7.91317 1.33363 5.97783C1.28806 5.13431 1.57788 4.30699 2.13987 3.6763C2.70187 3.04561 3.49045 2.66273 4.33363 2.61117C5.17681 2.66273 5.96539 3.04561 6.52739 3.6763C7.08939 4.30699 7.3792 5.13431 7.33363 5.97783C7.33363 6.15464 7.40387 6.32421 7.52889 6.44924C7.65392 6.57426 7.82349 6.6445 8.0003 6.6445C8.17711 6.6445 8.34668 6.57426 8.4717 6.44924C8.59673 6.32421 8.66696 6.15464 8.66696 5.97783C8.62139 5.13431 8.91121 4.30699 9.47321 3.6763C10.0352 3.04561 10.8238 2.66273 11.667 2.61117C12.5101 2.66273 13.2987 3.04561 13.8607 3.6763C14.4227 4.30699 14.7125 5.13431 14.667 5.97783C14.667 7.91317 12.7023 10.6705 9.27696 13.5418V13.5445Z"
                                                        fill="white" />
                                                </g>
                                            </svg>
                                        </a>
                                        <a href="javascript:void(0)" data-movie-id="{{ $movie->id }}"
                                            class="open-save-playlist-modal" title="{{ __('add_playlist') }}">
                                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0_892_4811)">
                                                    <path
                                                        d="M15.3333 7.33333H8.66667V0.666667C8.66667 0.489856 8.59643 0.320286 8.47141 0.195262C8.34638 0.0702379 8.17681 0 8 0C7.82319 0 7.65362 0.0702379 7.5286 0.195262C7.40357 0.320286 7.33333 0.489856 7.33333 0.666667V7.33333H0.666667C0.489856 7.33333 0.320286 7.40357 0.195262 7.5286C0.0702379 7.65362 0 7.82319 0 8C0 8.17681 0.0702379 8.34638 0.195262 8.47141C0.320286 8.59643 0.489856 8.66667 0.666667 8.66667H7.33333V15.3333C7.33333 15.5101 7.40357 15.6797 7.5286 15.8047C7.65362 15.9298 7.82319 16 8 16C8.17681 16 8.34638 15.9298 8.47141 15.8047C8.59643 15.6797 8.66667 15.5101 8.66667 15.3333V8.66667H15.3333C15.5101 8.66667 15.6797 8.59643 15.8047 8.47141C15.9298 8.34638 16 8.17681 16 8C16 7.82319 15.9298 7.65362 15.8047 7.5286C15.6797 7.40357 15.5101 7.33333 15.3333 7.33333Z"
                                                        fill="white" />
                                                </g>
                                            </svg>
                                        </a>
                                        <a href="javascript:void(0)" data-bs-toggle="modal"
                                            data-bs-target="#downloadModal" title="{{ __('download') }}"
                                            class="download-btn">
                                            <svg xmlns="http://www.w3.org/2000/svg" id="Outline" viewBox="0 0 24 24"
                                                width="512" height="512">
                                                <path
                                                    d="M9.878,18.122a3,3,0,0,0,4.244,0l3.211-3.211A1,1,0,0,0,15.919,13.5l-2.926,2.927L13,1a1,1,0,0,0-1-1h0a1,1,0,0,0-1,1l-.009,15.408L8.081,13.5a1,1,0,0,0-1.414,1.415Z" />
                                                <path
                                                    d="M23,16h0a1,1,0,0,0-1,1v4a1,1,0,0,1-1,1H3a1,1,0,0,1-1-1V17a1,1,0,0,0-1-1H1a1,1,0,0,0-1,1v4a3,3,0,0,0,3,3H21a3,3,0,0,0,3-3V17A1,1,0,0,0,23,16Z" />
                                            </svg>
                                        </a>
                                        <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-placement="bottom"
                                            data-url="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                            data-bs-target="#shareModal" title="{{ __('share') }}" class="share-btn">
                                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0_892_4790)">
                                                    <path
                                                        d="M12.8888 9.77816C12.3847 9.77858 11.8883 9.90163 11.4425 10.1367C10.9966 10.3718 10.6146 10.7118 10.3295 11.1275L5.99012 9.16817C6.29833 8.42392 6.29952 7.58796 5.99345 6.84283L10.3268 4.8735C10.7494 5.48467 11.377 5.92414 12.0958 6.1122C12.8147 6.30025 13.5771 6.22443 14.2449 5.8985C14.9126 5.57256 15.4414 5.0181 15.7353 4.33568C16.0293 3.65325 16.0689 2.88808 15.847 2.17895C15.6251 1.46982 15.1564 0.863696 14.5259 0.470535C13.8954 0.0773743 13.1449 -0.0767867 12.4105 0.0360157C11.6761 0.148818 11.0064 0.521112 10.5229 1.08537C10.0395 1.64962 9.7743 2.36846 9.77545 3.1115C9.77828 3.28736 9.79612 3.46267 9.82878 3.6355L5.22212 5.72883C4.77968 5.31431 4.22579 5.03806 3.6285 4.93401C3.03121 4.82996 2.41654 4.90264 1.85999 5.14314C1.30344 5.38363 0.829268 5.78146 0.495715 6.28774C0.162163 6.79402 -0.0162385 7.38671 -0.0175706 7.993C-0.0189027 8.59928 0.156892 9.19275 0.488217 9.70049C0.819542 10.2082 1.29197 10.6081 1.84745 10.8511C2.40293 11.094 3.01728 11.1694 3.61502 11.068C4.21276 10.9666 4.76786 10.6927 5.21212 10.2802L9.83078 12.3655C9.7987 12.5382 9.78109 12.7132 9.77812 12.8888C9.77799 13.5043 9.96037 14.1059 10.3022 14.6176C10.644 15.1294 11.1299 15.5283 11.6985 15.7639C12.267 15.9994 12.8927 16.0611 13.4963 15.9411C14.0999 15.8211 14.6543 15.5247 15.0895 15.0895C15.5247 14.6544 15.821 14.0999 15.941 13.4963C16.0611 12.8927 15.9994 12.2671 15.7638 11.6985C15.5282 11.13 15.1294 10.6441 14.6176 10.3022C14.1058 9.96041 13.5042 9.77803 12.8888 9.77816ZM12.8888 1.3335C13.2405 1.33337 13.5843 1.43753 13.8768 1.63282C14.1692 1.82811 14.3972 2.10575 14.5319 2.43063C14.6666 2.7555 14.7019 3.11302 14.6334 3.45796C14.5648 3.8029 14.3956 4.11977 14.1469 4.3685C13.8983 4.61722 13.5815 4.78663 13.2366 4.85529C12.8917 4.92394 12.5341 4.88877 12.2092 4.75422C11.8843 4.61967 11.6065 4.39178 11.4111 4.09937C11.2157 3.80697 11.1115 3.46318 11.1115 3.1115C11.1118 2.64017 11.2992 2.18823 11.6324 1.85489C11.9656 1.52154 12.4175 1.33403 12.8888 1.3335ZM3.11145 9.77816C2.75977 9.7783 2.41594 9.67413 2.12347 9.47884C1.83099 9.28355 1.60299 9.00591 1.46832 8.68104C1.33364 8.35616 1.29834 7.99865 1.36687 7.6537C1.4354 7.30876 1.60468 6.99189 1.85331 6.74317C2.10194 6.49444 2.41875 6.32504 2.76367 6.25638C3.10859 6.18772 3.46612 6.22289 3.79104 6.35744C4.11597 6.492 4.39369 6.71989 4.58909 7.01229C4.78449 7.3047 4.88878 7.64848 4.88878 8.00016C4.88826 8.47144 4.70085 8.92327 4.36767 9.25658C4.03449 9.58989 3.58273 9.77746 3.11145 9.77816ZM12.8888 14.6668C12.5371 14.6668 12.1934 14.5626 11.901 14.3672C11.6086 14.1718 11.3807 13.8941 11.2461 13.5692C11.1116 13.2444 11.0763 12.8869 11.1449 12.542C11.2136 12.1971 11.3829 11.8803 11.6315 11.6316C11.8802 11.3829 12.197 11.2136 12.5419 11.145C12.8868 11.0764 13.2443 11.1116 13.5692 11.2462C13.8941 11.3807 14.1718 11.6086 14.3671 11.901C14.5625 12.1934 14.6668 12.5372 14.6668 12.8888C14.6664 13.3603 14.479 13.8123 14.1456 14.1457C13.8123 14.479 13.3602 14.6665 12.8888 14.6668Z"
                                                        fill="white" />
                                                </g>
                                            </svg>
                                        </a>
                                        <a href="javascript:void(0)" data-bs-toggle="modal"
                                            data-bs-target="#reportModal" title="{{ __('report_movie') }}"
                                            class="report-btn" data-id="{{ $movie->id }}"
                                            data-type="{{ get_class($movie) }}">
                                            <svg xmlns="http://www.w3.org/2000/svg" id="Layer_1"
                                                data-name="Layer 1" viewBox="0 0 24 24" width="512"
                                                height="512">
                                                <path
                                                    d="M20.358,7.5l3.237-4.297c.459-.609,.533-1.413,.192-2.096s-1.026-1.107-1.79-1.107H4C1.794,0,0,1.794,0,4V23c0,.553,.448,1,1,1s1-.447,1-1V15H21.998c.764,0,1.449-.425,1.79-1.107s.267-1.486-.192-2.096l-3.237-4.297ZM2,13V4c0-1.103,.897-2,2-2H21.998l-3.69,4.898c-.268,.356-.268,.847,0,1.203l3.69,4.898H2Z" />
                                            </svg>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6">
                    <div class="rentsVideo__thumb">
                        <img class=" m-auto"
                            src="{{ getFileLink('thumbnail', $movie->thumbnail, 'movies', '500x750', 'w500') }}"
                            alt="{{__('image')}}">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Rent Video Section End -->
