<!-- Header Start -->
<header class="header">
    <div class="container-fluid">
        <div class="header__wrapper">
            <div class="header__left">
                <!-- Header Logo End -->
                <div class="header__logo">
                    <a href="{{ route('home') }}">
                        <img src="{{ getFileLink('original_image', get_config('light_logo'), 'logos', '360x95', 'original') }}"
                            alt="logo">
                    </a>
                </div>
                <!-- Header Logo End -->
                <!-- Header Menu Start -->
                <div class="header__menu">
                    <ul class="main__menu">
                        <li><a href="{{ route('home') }}"> {{ __('home') }} </a></li>
                        <li class="has__dropdown position-statics">
                            <a href="{{ route('movies') }}"> {{ __('movies') }} </a>
                            <div class="sub__menu mega__menu">
                                <div class="mega__menu-wrapper">
                                    <div class="inner__wrapper">
                                        <div class="">
                                            <a href="javascript:void(0)" class="title"> {{ __('popular') }} </a>
                                        </div>
                                        <ul class="">
                                            <li><a href="{{ route('all.movies', ['type' => 'trending']) }}">
                                                    {{ __('trending_movies') }} </a>
                                            </li>
                                            <li><a href="{{ route('all.movies', ['type' => 'latest']) }}">{{ __('new_released') }}
                                                </a></li>
                                            <li><a
                                                    href="{{ route('all.movies', ['type' => 'recommended']) }}">{{ __('recommended') }}</a>
                                            </li>
                                            <li><a
                                                    href="{{ route('all.movies', ['type' => 'featured']) }}">{{ __('featured') }}</a>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="inner__wrapper">
                                        <div class="">
                                            <a href="javascript:void(0)" class="title"> {{ __('explore_by_genre') }}
                                            </a>
                                        </div>
                                        @php
                                            $genres = get_all_genres();
                                            $firstColumn = $genres->take(6);
                                            $secondColumn = $genres->slice(6, 5); // next 5
                                            $remaining = $genres->slice(11); // the rest
                                        @endphp

                                        <div class="inner__grid">
                                            <ul>
                                                @foreach ($firstColumn as $item)
                                                    <li><a
                                                            href="{{ route('genre.wise.movie', ['slug' => $item->slug]) }}">{{ $item->name }}</a>
                                                    </li>
                                                @endforeach
                                                {{-- Hidden items for full view --}}
                                                <div class="more-genres d-none">
                                                    @if ($remaining && $remaining->isNotEmpty())

                                                        @foreach ($remaining->chunk(2)->first() as $item)
                                                            <li><a
                                                                    href="{{ route('genre.wise.movie', ['slug' => $item->slug]) }}">{{ $item->name }}</a>
                                                            </li>
                                                        @endforeach
                                                    @endif
                                                </div>
                                            </ul>
                                            <ul>
                                                @foreach ($secondColumn as $item)
                                                    <li><a
                                                            href="{{ route('genre.wise.movie', ['slug' => $item->slug]) }}">{{ $item->name }}</a>
                                                    </li>
                                                @endforeach
                                                {{-- Hidden items for full view --}}
                                                <div class="more-genres pb-3 d-none">
                                                    @if ($remaining && $remaining->isNotEmpty())

                                                        @foreach ($remaining->chunk(2)->last() as $item)
                                                            <li><a
                                                                    href="{{ route('genre.wise.movie', ['slug' => $item->slug]) }}">{{ $item->name }}</a>
                                                            </li>
                                                        @endforeach
                                                    @endif
                                                </div>
                                                <li>
                                                    <a href="javascript:void(0);"
                                                        onclick=" document.querySelectorAll('.more-genres').forEach(el => el.classList.toggle('d-none'));
                                                            let btn = this; btn.textContent = btn.textContent.trim() === '{{ __('view_all') }}' ? '{{ __('show_less') }}' : '{{ __('view_all') }}';"
                                                        class="btn btn-gray">
                                                        {{ __('view_all') }}
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>

                                    </div>
                                    <div class="inner__wrapper">
                                        <div class="">
                                            <a href="javascript:void(0)" class="title"> {{ __('explore_by_country') }}
                                            </a>
                                        </div>
                                        @php
                                            $countries = get_all_countries();
                                            $firstColumn = $countries->take(6);
                                            $secondColumn = $countries->slice(6, 5); // next 5
                                            $remaining = $countries->slice(11); // the rest
                                        @endphp

                                        <div class="inner__grid">
                                            <ul>
                                                @foreach ($firstColumn as $item)
                                                    <li><a
                                                            href="{{ route('country.wise.movie', ['slug' => $item->slug]) }}">{{ $item->name }}</a>
                                                    </li>
                                                @endforeach
                                                {{-- Hidden items for full view --}}
                                                <div class="more-countries d-none">
                                                    @if ($remaining && $remaining->isNotEmpty())

                                                        @foreach ($remaining->chunk(2)->first() as $item)
                                                            <li><a
                                                                    href="{{ route('country.wise.movie', ['slug' => $item->slug]) }}">{{ $item->name }}</a>
                                                            </li>
                                                        @endforeach
                                                    @endif
                                                </div>
                                            </ul>
                                            <ul>
                                                @foreach ($secondColumn as $item)
                                                    <li><a
                                                            href="{{ route('country.wise.movie', ['slug' => $item->slug]) }}">{{ $item->name }}</a>
                                                    </li>
                                                @endforeach
                                                {{-- Hidden items for full view --}}
                                                <div class="more-countries pb-3 d-none">
                                                    @if ($remaining && $remaining->isNotEmpty())

                                                        @foreach ($remaining->chunk(2)->last() as $item)
                                                            <li><a
                                                                    href="{{ route('country.wise.movie', ['slug' => $item->slug]) }}">{{ $item->name }}</a>
                                                            </li>
                                                        @endforeach
                                                    @endif
                                                </div>
                                                <li>
                                                    <a href="javascript:void(0);"
                                                        onclick=" document.querySelectorAll('.more-countries').forEach(el => el.classList.toggle('d-none'));
                                                            let btn = this; btn.textContent = btn.textContent.trim() === '{{ __('view_all') }}' ? '{{ __('show_less') }}' : '{{ __('view_all') }}';"
                                                        class="btn btn-gray">
                                                        {{ __('view_all') }}
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                @if (count(trending_movies()) > 0)
                                    <!-- Feature Movies Slider -->
                                    <div class="mega__slider">
                                        <a href="javascript:void(0)" class="title">{{ __('feature_movies') }}</a>
                                        <div class="position-relative">
                                            <div class="swiper megaMovie__slider">
                                                <div class="swiper-wrapper">
                                                    @foreach (trending_movies() as $item)
                                                        <!-- Slide -->
                                                        <div class="swiper-slide">
                                                            <div class="video__card">
                                                                <a href="{{ route('movie.details', ['slug' => $item->slug]) }}"
                                                                    class="video__thumb">
                                                                    <img src="{{ getFileLink('thumbnail', $item->thumbnail, 'movies', '500x750') }}"
                                                                        alt="movie" />
                                                                    <div class="video__btn">
                                                                        <i class="ri-play-fill"></i>
                                                                    </div>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                            <div class="swiper__navigation">
                                                <div class="megMovie-swipe-prev swiper-button-prev">
                                                    <i class="ri-arrow-left-s-line"></i>
                                                </div>
                                                <div class="megMovie-swipe-next swiper-button-next">
                                                    <i class="ri-arrow-right-s-line"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </li>
                        <li class="has__dropdown position-statics">
                            <a href="{{ route('tv.series') }}">{{ __('tv_series') }}</a>
                            <div class="sub__menu mega__menu">
                                <div class="mega__menu-wrapper">
                                    <div class="">
                                        <div class="inner__wrapper">
                                            <div class="">
                                                <a href="javascript:void(0)" class="title">{{ __('tv_series') }}</a>
                                            </div>
                                            <ul class="">
                                                <li><a href="{{ route('all.tv.series', ['type' => 'blockbuster']) }}">
                                                        {{ __('blockbuster_tv_shows') }} </a></li>
                                                <li><a
                                                        href="{{ route('all.tv.series', ['type' => 'new-release']) }}">{{ __('new_release') }}</a>
                                                </li>
                                                <li><a
                                                        href="{{ route('all.tv.series', ['type' => 'recommended']) }}">{{ __('recommended') }}</a>
                                                </li>
                                                <li><a
                                                        href="{{ route('all.tv.series', ['type' => 'featured']) }}">{{ __('featured') }}</a>
                                                </li>
                                                <li><a
                                                        href="{{ route('all.tv.series', ['type' => 'real-life-story']) }}">{{ __('real_life_story') }}</a>
                                                </li>
                                            </ul>
                                        </div>
                                        
                                    </div>
                                    <div class="slider__width">
                                        @if (count(new_tv_shows()) > 0)
                                            <!-- Feature Movies Slider -->
                                            <div class="mega__slider">
                                                <a href="javascript:void(0)" class="title">{{ __('new_tv_shows') }}</a>
                                                <div class="position-relative">
                                                    <div class="swiper megaTvShow__slider">
                                                        <div class="swiper-wrapper">
                                                            <!-- Slide -->
                                                            @forelse(new_tv_shows() as $item)
                                                                <div class="swiper-slide">
                                                                    <div class="video__card">
                                                                        <a href="{{ route('series.details', ['slug' => $item->slug]) }}"
                                                                            class="video__thumb">
                                                                            <img src="{{ getFileLink('thumbnail', $item->thumbnail, 'tv_shows', '500x750') }}"
                                                                                alt="movie" />
                                                                            <div class="video__btn">
                                                                                <i class="ri-play-fill"></i>
                                                                            </div>
                                                                        </a>
                                                                    </div>
                                                                </div>
                                                            @empty
                                                                <p>{{ __('no_data_available') }}!!</p>
                                                            @endforelse
                                                        </div>
                                                    </div>
                                                    <div class="swiper__navigation">
                                                        <div class="megaTvShow-swipe-prev swiper-button-prev">
                                                            <i class="ri-arrow-left-s-line"></i>
                                                        </div>
                                                        <div class="megaTvShow-swipe-next swiper-button-next">
                                                            <i class="ri-arrow-right-s-line"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                        @if (count(blockbuster_tv_shows()) > 0)
                                            <!-- Mega Trending Slider -->
                                            <div class="mega__slider">
                                                <a href="javascript:void(0)" class="title">{{ __('blockbuster_tv_shows') }}</a>
                                                <div class="position-relative">
                                                    <div class="swiper megaTrending__slider">
                                                        <div class="swiper-wrapper">
                                                            @forelse(blockbuster_tv_shows() as $item)
                                                                <div class="swiper-slide">
                                                                    <div class="video__card">
                                                                        <a href="{{ route('series.details', ['slug' => $item->slug]) }}"
                                                                            class="video__thumb">
                                                                            <img src="{{ getFileLink('thumbnail', $item->thumbnail, 'tv_shows', '500x750') }}"
                                                                                alt="movie" />
                                                                            <div class="video__btn">
                                                                                <i class="ri-play-fill"></i>
                                                                            </div>
                                                                        </a>
                                                                    </div>
                                                                </div>
                                                            @empty
                                                                <p>{{ __('no_data_available') }}!!</p>
                                                            @endforelse
                                                        </div>
                                                    </div>
                                                    <div class="swiper__navigation">
                                                        <div class="megaTrending-swipe-prev swiper-button-prev">
                                                            <i class="ri-arrow-left-s-line"></i>
                                                        </div>
                                                        <div class="megaTrending-swipe-next swiper-button-next">
                                                            <i class="ri-arrow-right-s-line"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </li>
                        <li class="has__dropdown position-statics">
                            <a href="{{route('tv.channels')}}"> {{ __('live_tv') }} <span> {{ __('live') }} </span></a>
                            <div class="sub__menu mega__menu">
                                <div class="mega__menu-wrapper">
                                    <div class="">
                                        <div class="inner__wrapper">
                                            <div class="">
                                                <a href="javascript:void(0)"
                                                    class="title">{{ __('popular_tv_categories') }}</a>
                                            </div>
                                            <ul>
                                                @foreach (liveTvCategories() as $key => $category)
                                                    <li>
                                                        <a
                                                            href="{{route('live.tv.category', ['slug' => $category->slug])}}">
                                                            {{ $category->live_tv_category }}
                                                        </a>
                                                    </li>
                                                @endforeach
                                                <li>
                                                    <a href="{{route('tv.channels')}}" class="btn btn-gray w-auto d-inline-block"> {{__('see_all')}} </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="slider__width">
                                        @if (count(liveTvs()) > 0)
                                            <!-- liveTv__slider Slider -->
                                            <div class="mega__slider">
                                                <a href="javascript:void(0)" class="title"> {{ __('best_live_tv') }} </a>
                                                <div class="position-relative">
                                                    <div class="swiper liveTv__slider">
                                                        <div class="swiper-wrapper">
                                                            <!-- Slide -->
                                                            @forelse(liveTvs() as $liveTv)
                                                                <div class="swiper-slide">
                                                                    <a href="{{ route('live.tv.details', ['slug' => $liveTv->slug]) }}"
                                                                        class="channel__card">
                                                                        <div class="card__thumb">
                                                                            <img src="{{ getFileLink('live_tv', $liveTv->thumbnail, 'live_tv_thumbs', '400x320') }}"
                                                                                alt="channel" />
                                                                        </div>
                                                                    </a>
                                                                </div>
                                                            @empty
                                                                <p>{{ __('no_data_available') }}!!</p>
                                                            @endforelse
                                                        </div>
                                                    </div>
                                                    <div class="swiper__navigation">
                                                        <div class="liveTv-swipe-prev swiper-button-prev">
                                                            <i class="ri-arrow-left-s-line"></i>
                                                        </div>
                                                        <div class="liveTv-swipe-next swiper-button-next">
                                                            <i class="ri-arrow-right-s-line"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </li>
                        <li><a href="{{ route('blogs') }}"> {{ __('blogs') }} </a></li>
                        <li>
                            <a href="javascript:void(0)" class="active" data-bs-toggle="modal"
                                data-bs-target="#movieRequestModal">{{ __('movie_request') }}</a>
                        </li>
                    </ul>
                </div>
                <!-- Header Menu End -->
            </div>
            <!-- Header Meta Start -->
            <div class="header__meta">

                <form action="{{ isset($is_tv_series) ? route('all.tv.series') : route('movies') }}" method="get"
                    class="header__search d-xxl-block d-none">
                    <button type="submit"><i class="ri-search-line"></i></button>
                    <input type="search" name="search" value="{{ $search ?? '' }}" class="form-control"
                        placeholder="{{ __('search_movies,_tv_&_more') }}" />
                </form>
                <div class="flex__wrap">
                    <div class="language__dropdown dropdown__btn">
                        @php
                            $system_languages = App\Models\Language::where('status', 1)->get();
                            $default_language = App\Models\Language::where('id', get_config('default_language'))->value(
                                'locale',
                            );
                        @endphp
                        <div class="selected drop__action">
                            <i class="ri-global-line"></i>
                            {{ strtoupper(session('locale') ?? $default_language) }}
                        </div>
                        <ul class="dropdown__list">
                            @foreach ($system_languages as $language)
                                <li>
                                    <a href="{{ setLanguageRedirect($language->locale) }}">
                                        <img src="{{ static_asset('images/flags/' . $language->locale . '.png') }}"
                                            width="100%" alt="{{__('image')}}">
                                        {{ $language->name }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>

                    @if (auth()->user())
                        <div class="dropdown__btn">
                            <a href="javascript:void(0)" class="user__profile drop__action">
                                <div class="profile__content text-end">
                                    <h4 class="name">
                                        {{ auth()->user()->first_name . ' ' . auth()->user()->last_name }}
                                    </h4>
                                </div>
                                <div class="profile__avatar">
                                    <img src="{{ getFileLink('original_image', auth()->user()->image, 'users', '100x100') }}"
                                        alt="avatar" />
                                </div>
                            </a>
                            <ul class="user__list dropdown__list">
                                <li>
                                    <a href="{{ route('admin.dashboard') }}">
                                        <div class="icon">
                                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M8 0C3.58867 0 0 3.58867 0 8C0 12.4113 3.58867 16 8 16C12.4113 16 16 12.4113 16 8C16 3.58867 12.4113 0 8 0ZM5.33333 14.1093V14C5.33333 12.5293 6.52933 11.3333 8 11.3333C9.47067 11.3333 10.6667 12.5293 10.6667 14V14.1093C9.84933 14.4673 8.948 14.6667 8 14.6667C7.052 14.6667 6.15067 14.4673 5.33333 14.1093ZM11.95 13.3673C11.646 11.4613 9.99067 10 8 10C6.00933 10 4.35467 11.4613 4.05 13.3673C2.40333 12.152 1.33333 10.1987 1.33333 8C1.33333 4.324 4.324 1.33333 8 1.33333C11.676 1.33333 14.6667 4.324 14.6667 8C14.6667 10.1987 13.5967 12.152 11.95 13.3673ZM8 3.33333C6.52933 3.33333 5.33333 4.52933 5.33333 6C5.33333 7.47067 6.52933 8.66667 8 8.66667C9.47067 8.66667 10.6667 7.47067 10.6667 6C10.6667 4.52933 9.47067 3.33333 8 3.33333ZM8 7.33333C7.26467 7.33333 6.66667 6.73533 6.66667 6C6.66667 5.26467 7.26467 4.66667 8 4.66667C8.73533 4.66667 9.33333 5.26467 9.33333 6C9.33333 6.73533 8.73533 7.33333 8 7.33333Z"
                                                    fill="#A4A4A4" />
                                            </svg>
                                        </div>
                                        {{ __('my_account') }}
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ route('user.dashboard', ['tab' => 'subscription']) }}">
                                        <div class="icon">
                                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0_333_8664)">
                                                    <path
                                                        d="M15.1773 3.044C14.9337 2.94252 14.6654 2.91585 14.4066 2.96738C14.1478 3.0189 13.9102 3.1463 13.724 3.33333L12 5.05733L8.94267 2C8.69263 1.75004 8.35355 1.60962 8 1.60962C7.64645 1.60962 7.30737 1.75004 7.05733 2L4 5.05733L2.276 3.33333C2.08953 3.14692 1.85198 3.01998 1.59338 2.96856C1.33477 2.91713 1.06673 2.94354 0.823127 3.04443C0.579528 3.14532 0.37131 3.31618 0.224798 3.53539C0.0782854 3.7546 5.62991e-05 4.01233 0 4.276L0 11.3333C0.00105857 12.2171 0.352588 13.0643 0.97748 13.6892C1.60237 14.3141 2.4496 14.6656 3.33333 14.6667H12.6667C13.5504 14.6656 14.3976 14.3141 15.0225 13.6892C15.6474 13.0643 15.9989 12.2171 16 11.3333V4.276C16.0001 4.01231 15.9219 3.75453 15.7755 3.53523C15.6291 3.31594 15.4209 3.14499 15.1773 3.044ZM14.6667 11.3333C14.6667 11.8638 14.456 12.3725 14.0809 12.7475C13.7058 13.1226 13.1971 13.3333 12.6667 13.3333H3.33333C2.8029 13.3333 2.29419 13.1226 1.91912 12.7475C1.54405 12.3725 1.33333 11.8638 1.33333 11.3333V4.276L3.52867 6.47133C3.65369 6.59632 3.82322 6.66653 4 6.66653C4.17678 6.66653 4.34631 6.59632 4.47133 6.47133L8 2.94267L11.5287 6.47133C11.6537 6.59632 11.8232 6.66653 12 6.66653C12.1768 6.66653 12.3463 6.59632 12.4713 6.47133L14.6667 4.276V11.3333Z"
                                                        fill="#A4A4A4" />
                                                </g>
                                            </svg>
                                        </div>
                                        {{ __('subscription') }}
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ route('user.dashboard', ['tab' => 'playlist']) }}">
                                        <div class="icon">
                                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0_333_8675)">
                                                    <path
                                                        d="M10.666 10.3333C10.5407 10.3333 10.4133 10.298 10.3007 10.224L7.634 8.472C7.44667 8.348 7.33333 8.13933 7.33333 7.91467V4.66667C7.33333 4.298 7.63133 4 8 4C8.36867 4 8.66667 4.298 8.66667 4.66667V7.55533L11.0327 9.10933C11.3407 9.312 11.426 9.72533 11.224 10.0327C11.096 10.228 10.8827 10.3333 10.666 10.3333ZM8.476 14.65C8.31867 14.6613 8.16 14.6667 8 14.6667C4.324 14.6667 1.33333 11.676 1.33333 8C1.33333 4.324 4.324 1.33333 8 1.33333C10.1007 1.33333 12.0747 2.34133 13.3253 4H11.3333C10.9647 4 10.6667 4.298 10.6667 4.66667C10.6667 5.03533 10.9647 5.33333 11.3333 5.33333H14C14.7353 5.33333 15.3333 4.73533 15.3333 4V1.33333C15.3333 0.964667 15.0353 0.666667 14.6667 0.666667C14.298 0.666667 14 0.964667 14 1.33333V2.736C12.4953 1.02867 10.3153 0 8 0C3.58867 0 0 3.58867 0 8C0 12.4113 3.58867 16 8 16C8.192 16 8.382 15.9927 8.57067 15.9793C8.938 15.9533 9.21467 15.634 9.188 15.2673C9.162 14.9007 8.84667 14.6173 8.476 14.65ZM15.3333 7.33333C14.9647 7.33333 14.6667 7.63133 14.6667 8C14.6667 8.30333 14.646 8.60867 14.6053 8.90667C14.556 9.272 14.812 9.608 15.176 9.65733C15.2067 9.66133 15.2367 9.66333 15.2667 9.66333C15.5953 9.66333 15.8813 9.42067 15.9267 9.08667C15.9747 8.72933 15.9993 8.36333 15.9993 8C15.9993 7.63133 15.702 7.33333 15.3333 7.33333ZM14.758 10.9307C14.4353 10.752 14.0293 10.872 13.8533 11.1947C13.7087 11.4587 13.544 11.716 13.3633 11.96C13.1447 12.256 13.208 12.6733 13.5033 12.8927C13.6233 12.9807 13.762 13.0227 13.8993 13.0227C14.104 13.0227 14.3053 12.9287 14.4367 12.7527C14.652 12.46 14.85 12.1513 15.0233 11.8347C15.2007 11.512 15.082 11.1067 14.7593 10.93L14.758 10.9307ZM11.604 13.6107C11.3487 13.7747 11.082 13.922 10.81 14.048C10.476 14.2033 10.3307 14.5993 10.486 14.9333C10.5993 15.1767 10.8393 15.3193 11.0913 15.3193C11.1853 15.3193 11.2807 15.3 11.3713 15.2573C11.6987 15.1047 12.02 14.9287 12.326 14.7313C12.636 14.532 12.7253 14.12 12.526 13.81C12.3267 13.5013 11.914 13.412 11.6047 13.61L11.604 13.6107Z"
                                                        fill="#A4A4A4" />
                                                </g>
                                            </svg>
                                        </div>
                                        {{ __('playlists') }}
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ route('user.dashboard', ['tab' => 'watch-history']) }}">
                                        <div class="icon">
                                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M16 8C16 8.368 15.702 8.66667 15.3333 8.66667C14.9647 8.66667 14.6667 8.368 14.6667 8C14.6667 4.324 11.676 1.33333 8 1.33333C5.89733 1.33333 3.92333 2.34 2.67267 4H4.66667C5.03533 4 5.33333 4.29867 5.33333 4.66667C5.33333 5.03467 5.03533 5.33333 4.66667 5.33333H2C1.26467 5.33333 0.666667 4.73533 0.666667 4V1.33333C0.666667 0.965333 0.964667 0.666667 1.33333 0.666667C1.702 0.666667 2 0.965333 2 1.33333V2.736C3.504 1.02867 5.68267 0 8 0C12.4113 0 16 3.58867 16 8ZM14 10.6667H11.3333C10.9647 10.6667 10.6667 10.9653 10.6667 11.3333C10.6667 11.7013 10.9647 12 11.3333 12H13.3273C12.076 13.66 10.1027 14.6667 8 14.6667C4.324 14.6667 1.33333 11.676 1.33333 8C1.33333 7.632 1.03533 7.33333 0.666667 7.33333C0.298 7.33333 0 7.632 0 8C0 12.4113 3.58867 16 8 16C10.3173 16 12.496 14.972 14 13.264V14.6667C14 15.0347 14.298 15.3333 14.6667 15.3333C15.0353 15.3333 15.3333 15.0347 15.3333 14.6667V12C15.3333 11.2647 14.7353 10.6667 14 10.6667Z"
                                                    fill="#A4A4A4" />
                                            </svg>
                                        </div>
                                        {{ __('watch_history') }}
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ route('logout') }}">
                                        <div class="icon">
                                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0_333_8672)">
                                                    <path
                                                        d="M7.66667 10.6667C7.40145 10.6667 7.1471 10.772 6.95956 10.9596C6.77202 11.1471 6.66667 11.4015 6.66667 11.6667V12.2C6.66667 12.6774 6.47702 13.1352 6.13946 13.4728C5.80189 13.8104 5.34406 14 4.86667 14H3.8C3.32261 14 2.86477 13.8104 2.52721 13.4728C2.18964 13.1352 2 12.6774 2 12.2V3.8C2 3.32261 2.18964 2.86477 2.52721 2.52721C2.86477 2.18964 3.32261 2 3.8 2H4.86667C5.34406 2 5.80189 2.18964 6.13946 2.52721C6.47702 2.86477 6.66667 3.32261 6.66667 3.8V4.33333C6.66667 4.59855 6.77202 4.8529 6.95956 5.04044C7.1471 5.22798 7.40145 5.33333 7.66667 5.33333C7.93188 5.33333 8.18624 5.22798 8.37377 5.04044C8.56131 4.8529 8.66667 4.59855 8.66667 4.33333V3.8C8.66561 2.7925 8.26491 1.82657 7.5525 1.11416C6.84009 0.401755 5.87416 0.00105885 4.86667 0L3.8 0C2.7925 0.00105885 1.82657 0.401755 1.11416 1.11416C0.401755 1.82657 0.00105885 2.7925 0 3.8L0 12.2C0.00105857 13.2075 0.401755 14.1734 1.11416 14.8858C1.82657 15.5982 2.7925 15.9989 3.8 16H4.86667C5.87416 15.9989 6.84009 15.5982 7.5525 14.8858C8.26491 14.1734 8.66561 13.2075 8.66667 12.2V11.6667C8.66667 11.4015 8.56131 11.1471 8.37377 10.9596C8.18624 10.772 7.93188 10.6667 7.66667 10.6667Z"
                                                        fill="white" />
                                                    <path
                                                        d="M15.04 6.35008L11.9827 3.29275C11.8898 3.19991 11.7795 3.12627 11.6582 3.07604C11.5368 3.02581 11.4068 2.99997 11.2754 3C11.1441 3.00003 11.0141 3.02593 10.8927 3.07622C10.7714 3.1265 10.6612 3.2002 10.5683 3.29308C10.3808 3.48068 10.2755 3.73508 10.2756 4.00032C10.2756 4.13165 10.3015 4.26169 10.3518 4.38302C10.4021 4.50434 10.4758 4.61457 10.5687 4.70742L12.8427 6.98142L4.66602 7.00008C4.4008 7.00008 4.14645 7.10544 3.95891 7.29298C3.77137 7.48051 3.66602 7.73487 3.66602 8.00008C3.66602 8.2653 3.77137 8.51966 3.95891 8.70719C4.14645 8.89473 4.4008 9.00008 4.66602 9.00008L12.878 8.98142L10.5667 11.2928C10.3791 11.4803 10.2737 11.7346 10.2736 11.9998C10.2735 12.2651 10.3788 12.5195 10.5663 12.7071C10.7539 12.8947 11.0082 13.0001 11.2734 13.0002C11.5387 13.0002 11.7931 12.8949 11.9807 12.7074L15.038 9.65008C15.4751 9.21233 15.7208 8.61911 15.7211 8.0005C15.7215 7.38189 15.4766 6.78837 15.04 6.35008Z"
                                                        fill="white" />
                                                </g>
                                            </svg>
                                        </div>
                                        {{ __('logout') }}
                                    </a>
                                </li>
                            </ul>
                        </div>
                    @else
                        <a href="javascript:void(0)" class="solid__btn"
                            onclick="ajaxModal('modal-md', '{{ route('login') }}')"> {{ __('login') }} </a>
                    @endif
                </div>
                <div class="header__btn d-sm-block d-none">
                    @if (!auth()->user())
                        <a href="{{ route('packages') }}" class="btn btn-primary"> {{ __('subscribe') }} </a>
                    @endif
                </div>
                <!-- Header Toggle Start -->
                <div class="header__toggle">
                    <div class="bar"></div>
                </div>
                <!-- Header Toggle End -->
            </div>
            <!-- Header Meta End -->
        </div>
    </div>
</header>
<!-- Header End -->


<!-- Header Flyout Menu Start -->
<div class="flyoutMenu">
    <div class="flyout__flip">
        <div class="flyout__inner">
            <div class="menu__header-top">
                <div class="brand__logo">
                    <a href="{{ route('home') }}">
                        <img src="{{ ($logo = json_decode(get_config('light_logo'), true)) && isset($logo['original_image']) && is_file_exists($logo['original_image']) ? get_media($logo['original_image']) : get_media('images/default/logo/logo.png') }}"
                            alt="logo" />
                    </a>
                </div>
                <!-- Close -->
                <div class="closest__btn">
                    <i class="ri-close-large-fill"></i>
                </div>
                <!-- Close -->
            </div>

            <div class="flyout__menu">
                <form action="{{ isset($is_tv_series) ? route('all.tv.series') : route('movies') }}" method="get"
                    class="header__search mw-100">
                    <button type="submit"><i class="ri-search-line"></i></button>
                    <input type="search" name="search" value="{{ $search ?? '' }}" class="form-control"
                        placeholder="{{ __('search_movies,_tv_&_more') }}" />
                </form>

                <ul class="flyout-main__menu">
                    <li><a href="{{ route('home') }}" class="nav__link">{{ __('home') }}</a></li>
                    <li class="has__dropdown">
                        <a href="{{ route('movies', ['type' => 'new']) }}"
                            class="nav__link">{{ __('movies') }}</a>
                        <ul class="sub__menu mega__sub">
                            <li class="inner__wrapper">
                                <a href="javascript:void(0)" class="title">{{ __('popular') }}</a>
                                <ul>
                                    <li><a
                                            href="{{ route('movies', ['type' => 'trending']) }}">{{ __('trending_movies') }}</a>
                                    </li>
                                    <li><a
                                            href="{{ route('movies', ['type' => 'new']) }}">{{ __('new_released') }}</a>
                                    </li>
                                    <li><a
                                            href="{{ route('movies', ['type' => 'recommended']) }}">{{ __('recommended') }}</a>
                                    </li>
                                    <li><a
                                            href="{{ route('movies', ['type' => 'featured']) }}">{{ __('featured') }}</a>
                                    </li>
                                    <li><a href="{{ route('movies') }}"
                                            class="btn btn-gray">{{ __('view_all') }}</a></li>
                                </ul>
                            </li>
                            <li class="inner__wrapper">
                                <a href="javascript:void(0)" class="title">{{ __('explore_by_genre') }}</a>
                                <div class="inner__grid">
                                    @php
                                        $genres = get_all_genres();
                                        $firstColumn = $genres->take(6);
                                        $secondColumn = $genres->slice(6, 5);
                                        $remaining = $genres->slice(11);
                                    @endphp
                                    <ul>
                                        @foreach ($firstColumn as $item)
                                            <li><a
                                                    href="{{ route('movies', ['genre' => $item->slug]) }}">{{ $item->name }}</a>
                                            </li>
                                        @endforeach
                                        <div class="more-genres d-none">
                                            @if ($remaining && $remaining->isNotEmpty())
                                                @foreach ($remaining->chunk(2)->first() as $item)
                                                    <li><a
                                                            href="{{ route('movies', ['genre' => $item->slug]) }}">{{ $item->name }}</a>
                                                    </li>
                                                @endforeach
                                            @endif
                                        </div>
                                    </ul>
                                    <ul>
                                        @foreach ($secondColumn as $item)
                                            <li><a
                                                    href="{{ route('movies', ['genre' => $item->slug]) }}">{{ $item->name }}</a>
                                            </li>
                                        @endforeach
                                        <div class="more-genres pb-3 d-none">
                                            @if ($remaining && $remaining->isNotEmpty())
                                                @foreach ($remaining->chunk(2)->last() as $item)
                                                    <li><a
                                                            href="{{ route('movies', ['genre' => $item->slug]) }}">{{ $item->name }}</a>
                                                    </li>
                                                @endforeach
                                            @endif
                                        </div>
                                        <li>
                                            <a href="javascript:void(0);"
                                                onclick="document.querySelectorAll('.more-genres').forEach(el => el.classList.toggle('d-none')); let btn = this; btn.textContent = btn.textContent.trim() === '{{ __('view_all') }}' ? '{{ __('show_less') }}' : '{{ __('view_all') }}';"
                                                class="btn btn-gray">
                                                {{ __('view_all') }}
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </li>
                            <li class="inner__wrapper">
                                <a href="javascript:void(0)" class="title">{{ __('explore_by_country') }}</a>
                                <div class="inner__grid">
                                    @php
                                        $countries = get_all_countries();
                                        $firstColumn = $countries->take(6);
                                        $secondColumn = $countries->slice(6, 5);
                                        $remaining = $countries->slice(11);
                                    @endphp
                                    <ul>
                                        @foreach ($firstColumn as $item)
                                            <li><a
                                                    href="{{ route('movies', ['country' => $item->slug]) }}">{{ $item->name }}</a>
                                            </li>
                                        @endforeach
                                        <div class="more-countries d-none">
                                            @if ($remaining && $remaining->isNotEmpty())
                                                @foreach ($remaining->chunk(2)->first() as $item)
                                                    <li><a
                                                            href="{{ route('movies', ['country' => $item->slug]) }}">{{ $item->name }}</a>
                                                    </li>
                                                @endforeach
                                            @endif
                                        </div>
                                    </ul>
                                    <ul>
                                        @foreach ($secondColumn as $item)
                                            <li><a
                                                    href="{{ route('movies', ['country' => $item->slug]) }}">{{ $item->name }}</a>
                                            </li>
                                        @endforeach
                                        <div class="more-countries pb-3 d-none">
                                            @if ($remaining && $remaining->isNotEmpty())
                                                @foreach ($remaining->chunk(2)->last() as $item)
                                                    <li><a
                                                            href="{{ route('movies', ['country' => $item->slug]) }}">{{ $item->name }}</a>
                                                    </li>
                                                @endforeach
                                            @endif
                                        </div>
                                        <li>
                                            <a href="javascript:void(0);"
                                                onclick="document.querySelectorAll('.more-countries').forEach(el => el.classList.toggle('d-none')); let btn = this; btn.textContent = btn.textContent.trim() === '{{ __('view_all') }}' ? '{{ __('show_less') }}' : '{{ __('view_all') }}';"
                                                class="btn btn-gray">
                                                {{ __('view_all') }}
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </li>
                            @if (count(trending_movies()) > 0)
                                <li class="mega__slider">
                                    <a href="javascript:void(0)" class="title">{{ __('feature_movies') }}</a>
                                    <div class="position-relative">
                                        <div class="swiper megaMovie__slider">
                                            <div class="swiper-wrapper">
                                                @foreach (trending_movies() as $item)
                                                    <div class="swiper-slide">
                                                        <div class="video__card">
                                                            <a href="{{ route('movie.details', ['slug' => $item->slug]) }}"
                                                                class="video__thumb">
                                                                <img src="{{ getFileLink('thumbnail', $item->thumbnail, 'movies', '500x750') }}"
                                                                    alt="movie" />
                                                                <div class="video__btn">
                                                                    <i class="ri-play-fill"></i>
                                                                </div>
                                                            </a>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                        <div class="swiper__navigation">
                                            <div class="megMovie-swipe-prev swiper-button-prev">
                                                <i class="ri-arrow-left-s-line"></i>
                                            </div>
                                            <div class="megMovie-swipe-next swiper-button-next">
                                                <i class="ri-arrow-right-s-line"></i>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            @endif
                        </ul>
                    </li>
                    <li class="has__dropdown">
                        <a href="{{ route('all.tv.series', ['type' => 'new']) }}"
                            class="nav__link">{{ __('series') }}</a>
                        <ul class="sub__menu mega__sub">
                            <li class="inner__wrapper">
                                <a href="javascript:void(0)" class="title">{{ __('series') }}</a>
                                <ul>
                                    <li><a
                                            href="{{ route('all.tv.series', ['type' => 'blockbuster']) }}">{{ __('blockbuster_tv_shows') }}</a>
                                    </li>
                                    <li><a
                                            href="{{ route('all.tv.series', ['type' => 'new-release']) }}">{{ __('new_release') }}</a>
                                    </li>
                                    <li><a
                                            href="{{ route('all.tv.series', ['type' => 'recommended']) }}">{{ __('recommended') }}</a>
                                    </li>
                                    <li><a
                                            href="{{ route('all.tv.series', ['type' => 'featured']) }}">{{ __('featured') }}</a>
                                    </li>
                                    <li><a
                                            href="{{ route('all.tv.series', ['type' => 'real-life-story']) }}">{{ __('real_life_story') }}</a>
                                    </li>
                                </ul>
                            </li>
                            @if (count(new_tv_shows()) > 0)
                                <li class="mega__slider">
                                    <a href="javascript:void(0)" class="title">{{ __('new_tv_shows') }}</a>
                                    <div class="position-relative">
                                        <div class="swiper megaTvShow__slider">
                                            <div class="swiper-wrapper">
                                                @forelse(new_tv_shows() as $item)
                                                    <div class="swiper-slide">
                                                        <div class="video__card">
                                                            <a href="{{ route('series.details', ['slug' => $item->slug]) }}"
                                                                class="video__thumb">
                                                                <img src="{{ getFileLink('thumbnail', $item->thumbnail, 'movies', '500x750') }}"
                                                                    alt="movie" />
                                                                <div class="video__btn">
                                                                    <i class="ri-play-fill"></i>
                                                                </div>
                                                            </a>
                                                        </div>
                                                    </div>
                                                @empty
                                                    <p>{{ __('no_data_available') }}!!</p>
                                                @endforelse
                                            </div>
                                        </div>
                                        <div class="swiper__navigation">
                                            <div class="megaTvShow-swipe-prev swiper-button-prev">
                                                <i class="ri-arrow-left-s-line"></i>
                                            </div>
                                            <div class="megaTvShow-swipe-next swiper-button-next">
                                                <i class="ri-arrow-right-s-line"></i>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            @endif

                            @if (count(blockbuster_tv_shows()) > 0)
                                <li class="mega__slider">
                                    <a href="javascript:void(0)" class="title">{{ __('blockbuster_tv_shows') }}</a>
                                    <div class="position-relative">
                                        <div class="swiper megaTrending__slider">
                                            <div class="swiper-wrapper">
                                                @forelse(blockbuster_tv_shows() as $item)
                                                    <div class="swiper-slide">
                                                        <div class="video__card">
                                                            <a href="{{ route('series.details', ['slug' => $item->slug]) }}"
                                                                class="video__thumb">
                                                                <img src="{{ getFileLink('thumbnail', $item->thumbnail, 'movies', '500x750') }}"
                                                                    alt="movie" />
                                                                <div class="video__btn">
                                                                    <i class="ri-play-fill"></i>
                                                                </div>
                                                            </a>
                                                        </div>
                                                    </div>
                                                @empty
                                                    <p>{{ __('no_data_available') }}!!</p>
                                                @endforelse
                                            </div>
                                        </div>
                                        <div class="swiper__navigation">
                                            <div class="megaTrending-swipe-prev swiper-button-prev">
                                                <i class="ri-arrow-left-s-line"></i>
                                            </div>
                                            <div class="megaTrending-swipe-next swiper-button-next">
                                                <i class="ri-arrow-right-s-line"></i>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            @endif
                        </ul>
                    </li>
                    <li class="has__dropdown">
                        <a href="javascript:void(0)" class="nav__link">{{ __('live_tv') }}
                            <span>{{ __('live') }}</span></a>
                        <ul class="sub__menu mega__sub">
                            <li class="inner__wrapper">
                                <a href="javascript:void(0)" class="title">{{ __('popular_tv_categories') }}</a>
                                <ul>
                                    @foreach (liveTvCategories() as $key => $category)
                                        <li>
                                            <a href="javascript:void(0)">
                                                {{ $category->live_tv_category }}
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>
                            </li>
                            @if (count(liveTvs()))
                                <li class="mega__slider">
                                    <a href="javascript:void(0)" class="title">{{ __('best_live_tv') }}</a>
                                    <div class="position-relative">
                                        <div class="swiper liveTv__slider">
                                            <div class="swiper-wrapper">
                                                @forelse(liveTvs() as $liveTv)
                                                    <div class="swiper-slide">
                                                        <a href="{{ route('live.tv.details', ['slug' => $liveTv->slug]) }}"
                                                            class="channel__card">
                                                            <div class="card__thumb">
                                                                <img src="{{ getFileLink('live_tv', $liveTv->thumbnail, 'live_tv_thumbs', '400x320') }}"
                                                                    alt="channel" />
                                                            </div>
                                                        </a>
                                                    </div>
                                                @empty
                                                    <p>{{ __('no_data_available') }}!!</p>
                                                @endforelse
                                            </div>
                                        </div>
                                        <div class="swiper__navigation">
                                            <div class="liveTv-swipe-prev swiper-button-prev">
                                                <i class="ri-arrow-left-s-line"></i>
                                            </div>
                                            <div class="liveTv-swipe-next swiper-button-next">
                                                <i class="ri-arrow-right-s-line"></i>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            @endif
                        </ul>
                    </li>
                    <li><a href="{{ route('blogs') }}">{{ __('blogs') }}</a></li>
                    <li><a href="javascript:void(0);" data-bs-toggle="modal"
                            data-bs-target="#movieRequestModal">{{ __('movie_request') }}</a></li>
                </ul>
                <div class="flyout__btn">
                    @if (auth()->user())
                        <a href="{{ route('user.dashboard', ['tab' => 'subscription']) }}"
                            class="btn btn-primary w-100">{{ __('subscription') }}</a>
                    @else
                        <a href="javascript:void(0)" class="btn btn-outline w-100"
                            onclick="ajaxModal('modal-md', '{{ route('login') }}')">{{ __('login') }}</a>
                        <a href="{{ route('packages') }}"
                            class="btn btn-primary w-100">{{ __('subscription') }}</a>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Header Flyout Menu End -->
