<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <title>{{ get_config('system_name') }}</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">

    @include('website.component.meta')

    @php
        $icon = json_decode(get_config('favicon'));
    @endphp

    @if ($icon)
        @php
            // Helper to check file existence
            function favicon_exists($path)
            {
                return $path && file_exists(public_path($path));
            }
        @endphp

        <link rel="apple-touch-icon" sizes="57x57"
            href="{{ favicon_exists($icon->image_57x57_url ?? '') ? static_asset($icon->image_57x57_url) : static_asset('images/default/favicon/favicon-57x57.png') }}">
        <link rel="apple-touch-icon" sizes="60x60"
            href="{{ favicon_exists($icon->image_60x60_url ?? '') ? static_asset($icon->image_60x60_url) : static_asset('images/default/favicon/favicon-60x60.png') }}">
        <link rel="apple-touch-icon" sizes="72x72"
            href="{{ favicon_exists($icon->image_72x72_url ?? '') ? static_asset($icon->image_72x72_url) : static_asset('images/default/favicon/favicon-72x72.png') }}">
        <link rel="apple-touch-icon" sizes="76x76"
            href="{{ favicon_exists($icon->image_76x76_url ?? '') ? static_asset($icon->image_76x76_url) : static_asset('images/default/favicon/favicon-76x76.png') }}">
        <link rel="apple-touch-icon" sizes="114x114"
            href="{{ favicon_exists($icon->image_114x114_url ?? '') ? static_asset($icon->image_114x114_url) : static_asset('images/default/favicon/favicon-114x114.png') }}">
        <link rel="apple-touch-icon" sizes="120x120"
            href="{{ favicon_exists($icon->image_120x120_url ?? '') ? static_asset($icon->image_120x120_url) : static_asset('images/default/favicon/favicon-120x120.png') }}">
        <link rel="apple-touch-icon" sizes="144x144"
            href="{{ favicon_exists($icon->image_144x144_url ?? '') ? static_asset($icon->image_144x144_url) : static_asset('images/default/favicon/favicon-144x144.png') }}">
        <link rel="apple-touch-icon" sizes="152x152"
            href="{{ favicon_exists($icon->image_152x152_url ?? '') ? static_asset($icon->image_152x152_url) : static_asset('images/default/favicon/favicon-152x152.png') }}">
        <link rel="apple-touch-icon" sizes="180x180"
            href="{{ favicon_exists($icon->image_180x180_url ?? '') ? static_asset($icon->image_180x180_url) : static_asset('images/default/favicon/favicon-180x180.png') }}">
        <link rel="icon" type="image/png" sizes="192x192"
            href="{{ favicon_exists($icon->image_192x192_url ?? '') ? static_asset($icon->image_192x192_url) : static_asset('images/default/favicon/favicon-192x192.png') }}">
        <link rel="icon" type="image/png" sizes="32x32"
            href="{{ favicon_exists($icon->image_32x32_url ?? '') ? static_asset($icon->image_32x32_url) : static_asset('images/default/favicon/favicon-32x32.png') }}">
        <link rel="icon" type="image/png" sizes="96x96"
            href="{{ favicon_exists($icon->image_96x96_url ?? '') ? static_asset($icon->image_96x96_url) : static_asset('images/default/favicon/favicon-96x96.png') }}">
        <link rel="icon" type="image/png" sizes="16x16"
            href="{{ favicon_exists($icon->image_16x16_url ?? '') ? static_asset($icon->image_16x16_url) : static_asset('images/default/favicon/favicon-16x16.png') }}">
        <link rel="manifest" href="{{ static_asset('images/default/favicon/manifest.json') }}">

        <meta name="msapplication-TileColor" content="#ffffff">
        <meta name="msapplication-TileImage"
            content="{{ favicon_exists($icon->image_144x144_url ?? '') ? static_asset($icon->image_144x144_url) : static_asset('images/default/favicon/favicon-144x144.png') }}">
    @else
        <link rel="shortcut icon" href="{{ static_asset('images/default/favicon/favicon-96x96.png') }}">
    @endif

    <!-- Remix Icon -->
    <link rel="stylesheet" href="{{ static_asset('website/css/remixicon.css') }}" />
    <!-- bootstraph -->
    <link rel="stylesheet" href="{{ static_asset('website/css/bootstrap.min.css') }}" />
    <!-- Swiper Slider -->
    <link rel="stylesheet" href="{{ static_asset('website/css/swiper-bundle.min.css') }}" />
    <!-- FancyBox -->
    <link rel="stylesheet" href="{{ static_asset('website/css/jquery.fancybox.min.css') }}" />
    <!-- Plyr Css -->
    <link rel="stylesheet" href="{{ static_asset('website/css/plyr.css') }}" />
    <!-- Select 2  -->
    <link rel="stylesheet" href="{{ static_asset('website/css/select2.min.css') }}" />
    <!-- User's CSS Here -->
    <link rel="stylesheet" href="{{ static_asset('website/css/style.css') }}" />
    <link rel="stylesheet" href="{{ static_asset('admin/css/toastr.min.css') }}">

    <style>
        .fl-wrapper[data-position$="-right"],
        .fl-wrapper[data-position$="-left"],
        #toast-container {
            z-index: 999999 !important;
            position: fixed !important;
            pointer-events: auto;
        }
    </style>
</head>

<body>

    @yield('base.content')

    <!-- Save Playlist Modal -->
    <div class="modal fade custom__popup" id="savePlaylistModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close ms-auto" data-bs-dismiss="modal"
                        aria-label="{{ __('close') }}">
                        <i class="ri-close-large-line"></i>
                    </button>
                </div>
                <div class="modal-body p-0">
                    <div class="form__wrapper p-5">
                        <form id="saveToPlaylistForm" method="POST" action="{{ route('playlist.addmovie') }}">
                            @csrf
                            <input type="hidden" name="movie_id" id="selectedMovieId" value="">
                            <div class="heading__content">
                                <h2 class="title2"><i class="ri-list-unordered"></i>{{ __('save_video_to_playlist') }}
                                </h2>
                            </div>
                            <hr />
                            <div class="form-group" id="playlist-radio-list">
                                @foreach (playlists() as $playlist)
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="playlist_ids[]"
                                            id="playlist_id_{{ $playlist->id }}" value="{{ $playlist->id }}" />
                                        <label class="form-check-label" for="playlist_id_{{ $playlist->id }}">
                                            {{ $playlist->name }}
                                        </label>
                                    </div>
                                @endforeach
                            </div>
                            <hr />
                            <div class="btn__group d-flex align-items-center justify-content-end gap-3">
                                <button type="button" data-bs-target="#playlistModal" data-bs-toggle="modal"
                                    name="btn" class="btn btn-dark">
                                    {{ __('create_new') }}
                                </button>
                                <button type="submit" class="btn btn-dark">
                                    {{ __('save_to_playlist') }}
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Create Playlist Modal -->
    <div class="modal fade custom__popup" id="playlistModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close ms-auto" data-bs-dismiss="modal"
                        aria-label="{{ __('close') }}">
                        <i class="ri-close-large-line"></i>
                    </button>
                </div>
                <div class="modal-body p-0">
                    <div class="form__wrapper p-5">
                        <form id="createPlaylistForm" method="POST">
                            @csrf
                            <input type="hidden" name="user_id" value="{{ auth()->user()->id ?? '' }}"
                                id="">
                            <div class="heading__content">
                                <h2 class="title2"><i class="ri-play-list-add-line"></i>
                                    {{ __('create_new_playlist') }}
                                </h2>
                            </div>
                            <div class="form-group mt-3">
                                <label for="playlist_name">{{ __('name') }}</label>
                                <input type="text" class="form-control" name="name" id="playlist_name"
                                    required />
                            </div>
                            <div class="btn__group d-flex justify-content-end gap-2 mt-4">
                                <button type="submit" class="btn btn-dark">{{ __('create_playlist') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Share Modal (duplicate, can be removed or unified) -->
    <div class="modal fade custom__popup" id="shareModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close ms-auto" data-bs-dismiss="modal"
                        aria-label="{{ __('close') }}">
                        <i class="ri-close-large-line"></i>
                    </button>
                </div>
                <div class="modal-body p-0">
                    <div class="form__wrapper p-5">
                        <div class="heading__content">
                            <h2 class="title2">{{ __('share_video') }}</h2>
                        </div>
                        <hr />
                        <div class="shareContent d-flex align-items-center">
                            <div class="icon me-2"><i class="ri-global-line"></i></div>
                            <span>{{ __('url') }}: <a href="javascript:void(0)" class="share-link"
                                    target="_blank"></a></span>
                            <button class="copyBtn ms-auto" title="{{ __('copy_link') }}"><i
                                    class="ri-file-copy-line"></i></button>
                        </div>
                        <div class="shareIcons mt-4">
                            <div class="title">{{ __('share_link_via') }}</div>
                            <div class="icons mt-2">
                                <a href="javascript:void(0)"><i class="ri-facebook-fill"></i></a>
                                <a href="javascript:void(0)"><i class="ri-twitter-x-line"></i></a>
                                <a href="javascript:void(0)"><i class="ri-pinterest-line"></i></a>
                                <a href="javascript:void(0)"><i class="ri-instagram-line"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- movie request modal -->
    <div class="modal fade custom__popup" id="movieRequestModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close ms-auto" data-bs-dismiss="modal" aria-label="Close">
                        <i class="ri-close-large-line"></i>
                    </button>
                </div>
                <div class="modal-body p-0">
                    <div class="form__wrapper p-5">
                        <form action="{{ route('movie.request.store') }}" method="post">
                            @csrf

                            <div class="heading__content">
                                <h2 class="title2">{{ __('movie_request') }}</h2>
                            </div>

                            <hr />

                            <div class="form-group">
                                <label for="yName">{{ __('your_name') }}<span class="required">*</span></label>
                                <input type="text" name="name" class="form-control" id="yName"
                                    placeholder="{{ __('your_name') }}" />
                            </div>

                            <div class="form-group">
                                <label for="yEmail">{{ __('your_email') }}<span class="required">*</span></label>
                                <input type="email" name="email" class="form-control" id="yEmail"
                                    placeholder="{{ __('your_email') }}" />
                            </div>

                            <div class="form-group">
                                <label for="movie_Name">{{ __('movie_name') }}<span class="required">*</span></label>
                                <input type="text" name="movie_name" class="form-control" id="movie_Name"
                                    placeholder="{{ __('movie_name') }}" />
                            </div>

                            <div class="form-group">
                                <label for="movie_message">{{ __('your_message') }}</label>
                                <textarea name="message" class="form-control" id="movie_message" cols="30" rows="4"
                                    placeholder="{{ __('write_your_message_here') }}"></textarea>
                            </div>

                            <hr />
                            @if (get_config('is_recaptcha_activated') && get_config('recaptcha_site_key'))
                                <div class="mb-30">
                                    <div id="html_element" class="g-recaptcha"
                                        data-sitekey="{{ get_config('recaptcha_site_key') }}"></div>
                                </div>
                            @endif
                            <div class="btn__group d-flex align-items-center justify-content-end gap-3">
                                <button type="submit" name="btn"
                                    class="btn btn-primary">{{ __('make_request') }}</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- report modal -->
    <!-- movie report modal -->
    <div class="modal fade custom__popup" id="reportModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close ms-auto" data-bs-dismiss="modal" aria-label="Close">
                        <i class="ri-close-large-line"></i>
                    </button>
                </div>
                <div class="modal-body p-0">
                    <div class="form__wrapper p-5">
                        <form action="{{ route('movie.report') }}" method="post">
                            @csrf

                            <div class="heading__content">
                                <h2 class="title2">{{ __('report_movie') }}</h2>
                            </div>

                            <hr />

                            <input type="hidden" name="reportable_id" id="reportable_id">
                            <input type="hidden" name="reportable_type" id="reportable_type">
                            <h4 class="title2">Please help us to describe the issue so we can fix it asap.</h4>
                            <span class="text-danger">*</span>
                            <span class="fs-5"> Note: This feature used to report issue for current movie, not used
                                for
                                requesting new
                                subtitle/audio in another
                                language.</span>
                            <div class="card">
                                <div class="card-body">
                                    <div class="form-group">
                                        <label class="d-block">{{ __('video_issues') }}</label>
                                        <div class="d-flex gap-3 flex-wrap">
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="video_issue"
                                                    value="broken" id="videoBroken">
                                                <label class="form-check-label"
                                                    for="videoBroken">{{ __('broken') }}</label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="video_issue"
                                                    value="wrong_movie" id="videoWrong">
                                                <label class="form-check-label"
                                                    for="videoWrong">{{ __('wrong_movie') }}</label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="video_issue"
                                                    value="others" id="videoOther">
                                                <label class="form-check-label"
                                                    for="videoOther">{{ __('others') }}</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="d-block">{{ __('audio_issues') }}</label>
                                        <div class="d-flex gap-3 flex-wrap">
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="audio_issue"
                                                    value="not_synced" id="audioSync">
                                                <label class="form-check-label"
                                                    for="audioSync">{{ __('not_synced') }}</label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="audio_issue"
                                                    value="wrong_audio" id="audioWrong">
                                                <label class="form-check-label"
                                                    for="audioWrong">{{ __('wrong_audio') }}</label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="audio_issue"
                                                    value="others" id="audioOther">
                                                <label class="form-check-label"
                                                    for="audioOther">{{ __('others') }}</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="d-block">{{ __('subtitle_issues') }}</label>
                                        <div class="d-flex gap-3 flex-wrap">
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="subtitle_issue"
                                                    value="not_synced" id="subSync">
                                                <label class="form-check-label"
                                                    for="subSync">{{ __('not_synced') }}</label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="subtitle_issue"
                                                    value="wrong_subtitle" id="subWrong">
                                                <label class="form-check-label"
                                                    for="subWrong">{{ __('wrong_subtitle') }}</label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="subtitle_issue"
                                                    value="others" id="subOther">
                                                <label class="form-check-label"
                                                    for="subOther">{{ __('others') }}</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="report_message">{{ __('your_message') }}</label>
                                        <textarea name="message" class="form-control" id="report_message" cols="30" rows="4"
                                            placeholder="{{ __('describe_the_issue_here_optional') }}"></textarea>
                                    </div>
                                </div>
                            </div>
                            <hr />
                            @if (get_config('is_recaptcha_activated') && get_config('recaptcha_site_key'))
                                <div class="mb-30">
                                    <div id="html_element" class="g-recaptcha"
                                        data-sitekey="{{ get_config('recaptcha_site_key') }}"></div>
                                </div>
                            @endif
                            <div class="btn__group d-flex align-items-center justify-content-end gap-3">
                                <button type="submit" class="btn btn-primary">{{ __('report') }}</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>

    @if (isset($movie->downloadLinks))
        <!-- download modal -->
        <div class="modal fade custom__popup" id="downloadModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close ms-auto" data-bs-dismiss="modal"
                            aria-label="{{ __('close') }}">
                            <i class="ri-close-large-line"></i>
                        </button>
                    </div>
                    <div class="modal-body p-0">
                        <div class="form__wrapper p-5">
                            <div class="heading__content">
                                <h2 class="title2">{{ __('available_downloads') }}</h2>
                            </div>
                            <hr />
                            @forelse($movie->downloadLinks as $link)
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div>
                                        <strong>{{ $link->title }}</strong><br>
                                        @if ($link->resolution)
                                            <small>{{ __('resolution') }}: {{ $link->resolution }}</small><br>
                                        @endif
                                        @if ($link->file_size)
                                            <small>{{ __('size') }}: {{ $link->file_size }}</small>
                                        @endif
                                    </div>
                                    <a href="{{ $link->link }}" class="btn btn-dark" target="_blank" download>
                                        {{ __('download') }}
                                    </a>
                                </div>
                            @empty
                                <p>{{ __('no_download_links_available') }}</p>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- JS -->
    <script src="{{ static_asset('website/js/jquery-3.7.1.min.js') }}"></script>
    <script src="{{ static_asset('website/js/popper.min.js') }}"></script>
    <script src="{{ static_asset('website/js/bootstrap.min.js') }}"></script>
    <script src="{{ static_asset('website/js/smooth-scroll.js') }}"></script>
    <script src="{{ static_asset('website/js/swiper-bundle.min.js') }}"></script>
    <script src="{{ static_asset('website/js/plyr.js') }}"></script>
    <script src="{{ static_asset('website/js/jquery.fancybox.min.js') }}"></script>
    <script src="{{ static_asset('website/js/jquery-ui.min.js') }}"></script>
    <script src="{{ static_asset('website/js/select2.min.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="{{ static_asset('website/js/scripts.js') }}"></script>
    <script src="{{ static_asset('admin/js/toastr.min.js') }}"></script>
    <!--====== ReCAPTCHA ======-->
    <script src="https://www.google.com/recaptcha/api.js?onload=onloadCallback&render=explicit" async defer></script>

    @if (get_config('is_recaptcha_activated') && get_config('recaptcha_site_key'))
        <script type="text/javascript">
            var onloadCallback = function() {
                grecaptcha.render('html_element', {
                    'sitekey': '{{ get_config('recaptcha_site_key') }}',
                    'size': 'md'
                });
            };
        </script>
    @endif

    @if (session('success_message'))
        <script>
            "use strict";
            toastr.success("{{ session('success_message') }}");
        </script>
    @endif
    @if (session('error_message'))
        <script>
            "use strict";
            toastr.error("{{ session('error_message') }}");
        </script>
    @endif
    @if ($errors->any())
        <script>
            "use strict";
            @foreach ($errors->all() as $error)
                toastr.error("{{ $error }}");
            @endforeach
        </script>
    @endif

    @stack('js')
    <script>
        "use strict";
        $(document).ready(function(e) {
            $('.report-btn').on('click', function() {
                const id = $(this).data('id');
                const type = $(this).data('type');

                $('#reportable_id').val(id);
                $('#reportable_type').val(type);
            });


            let currentShareUrl = '';

            $('.share-btn').on('click', function() {
                currentShareUrl = $(this).data('url');
                $('.share-link').attr('href', currentShareUrl).text(currentShareUrl);
            });

            // Copy to clipboard
            $('.copyBtn').on('click', async function() {
                try {
                    await navigator.clipboard.writeText(currentShareUrl);
                    toastr.success('{{ __('link_copied_to_clipboard') }}');
                } catch (err) {
                    toastr.error('{{ __('failed_to_copy_the_link') }}');
                }
            });

            // Social sharing
            $('.shareIcons a').on('click', function(e) {
                e.preventDefault();
                const encodedUrl = encodeURIComponent(currentShareUrl);
                const iconClass = $(this).find('i').attr('class');
                let shareUrl = '';

                if (iconClass.includes('facebook')) {
                    shareUrl = `https://www.facebook.com/sharer/sharer.php?u=${encodedUrl}`;
                } else if (iconClass.includes('twitter')) {
                    shareUrl = `https://twitter.com/intent/tweet?url=${encodedUrl}`;
                } else if (iconClass.includes('pinterest')) {
                    shareUrl = `https://pinterest.com/pin/create/button/?url=${encodedUrl}`;
                } else if (iconClass.includes('instagram')) {
                    alert('{{ __('instagram_does_not_support_direct_web_sharing') }}');
                    return;
                }

                if (shareUrl) {
                    window.open(shareUrl, '_blank', 'width=600,height=400');
                }
            });

            $(document).on('click', '.open-save-playlist-modal', function() {
                $('#saveToPlaylistForm')[0].reset();

                const isLoggedIn = {{ auth()->check() ? 'true' : 'false' }};

                if (!isLoggedIn) {
                    toastr.error('{{ __('please_login_before_adding_to_playlist') }}');
                    return;
                }

                const movieId = $(this).data('movie-id');
                $('#selectedMovieId').val(movieId);

                var url = '{{ route('get.playlist.ids', ['movie' => '_movie_id']) }}';
                url = url.replace('_movie_id', movieId);

                $.ajax({
                    url: url,
                    type: 'GET',
                    success: function(response) {
                        const playlistIds = response.playlist_ids;

                        playlistIds.forEach(id => {
                            $('#playlist_id_' + id).prop('checked', true);
                        });

                        $('#savePlaylistModal').modal('show');
                    },
                    error: function() {
                        toastr.error('{{ __('failed_to_fetch_playlist_data') }}');
                    }
                });
            });

            $('#saveToPlaylistForm').on('submit', function(e) {
                e.preventDefault();

                $.ajax({
                    type: 'POST',
                    url: $(this).attr('action'),
                    data: $(this).serialize(),
                    success: function(res) {
                        $('#savePlaylistModal').modal('hide');
                        toastr.success(res.message);
                        $('#saveToPlaylistForm')[0].reset();
                    },
                    error: function(xhr) {
                        let msg = '{{ __('could_not_save_to_playlist') }}';
                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            msg = xhr.responseJSON.message;
                        }
                        toastr.error(msg);
                    }
                });
            });

            $('#createPlaylistForm').on('submit', function(e) {
                e.preventDefault();

                const formData = $(this).serialize();
                $.ajax({
                    url: '{{ route('playlists.store') }}',
                    method: 'POST',
                    data: formData,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                        'Accept': 'application/json',
                    },
                    success: function(res) {
                        $('#playlistModal').modal('hide');

                        const newPlaylist = res.data;

                        const newRadioHtml = `<div class="form-check">
                            <input class="form-check-input" type="checkbox" name="playlist_ids[]"
                            id="playlist_id_${newPlaylist.id}" value="${newPlaylist.id}" checked>
                            <label class="form-check-label" for="playlist_id_${newPlaylist.id}">
                                 ${newPlaylist.name}
                            </label>
                        </div>
                        `;

                        $('#playlist-radio-list').append(newRadioHtml);

                        $('#savePlaylistModal').modal('show');
                    },
                    error: function(xhr) {
                        console.error(xhr.responseJSON);
                        toastr.error('{{ __('error_creating_playlist') }}');
                    }
                });
            });

            $('.favorite-toggle-btn').click(function() {
                const itemId = $(this).data('id');
                const itemType = $(this).data('type');
                const button = $(this);

                $.ajax({
                    url: '{{ route('favorite.toggle') }}',
                    method: 'POST',
                    data: {
                        id: itemId,
                        type: itemType,
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        toastr.success(response.message);

                        if (response.toggle_status == 'added') {
                            button.css('background', '#D50055');
                            button.attr('title', '{{ __('remove_from_favorites') }}');
                        } else {
                            button.css('background', '#FFFFFF4D');
                            button.attr('title', '{{ __('add_to_favorites') }}');
                        }
                    },
                    error: function(xhr) {
                        let msg = '{{ __('could_not_update_favorite_list') }}';
                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            msg = xhr.responseJSON.message;
                        }

                        toastr.error(response.message);
                    }
                });
            });
        });
    </script>
</body>

</html>
