    @push('js')
        <script>
            "use strict";
            $(document).ready(function() {
                $('#star-rating a').on('click', function(e) {
                    e.preventDefault();

                    const rating = $(this).data('value');
                    $('#rating-value').val(rating);

                    // Optional: highlight stars visually
                    $('#star-rating a i').each(function(index) {
                        $(this).attr('class', index < rating ? 'ri-star-fill' : 'ri-star-line');
                    });
                });
            });

            $(document).on('click', '.like-btn', function(e) {
                e.preventDefault();
                var btn = $(this);
                var reviewId = btn.data('review-id');
                var url = '{{ route('review.like', ':id') }}'.replace(':id', reviewId);
                $.ajax({
                    url: url,
                    type: 'POST', // Use POST for like/unlike actions
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(data) {
                        btn.find('.like-count').text(data.count);
                        if (data.liked) {
                            btn.data('liked', 1);
                            btn.find('i').replaceWith('<i class="ri-thumb-up-fill text-primary"></i>');
                            toastr.success("{{ __('review_liked') }}");
                        } else {
                            btn.data('liked', 0);
                            btn.find('i').replaceWith('<i class="ri-thumb-up-line"></i>');
                            toastr.success("{{ __('review_unliked') }}");
                        }
                    },
                    error: function(xhr) {
                        if (xhr.status === 401) {
                            toastr.error("{{ __('login_to_like_review') }}");
                        }
                    }
                });
            });
        </script>
    @endpush
