@extends('website.layouts.master')
@section('title', __('home_page'))
@section('content')

    <!-- Breadcrumb Start -->
    <div class="breadcrumb__area">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="breadcrumb__title">
                        <ul class="link">
                            <li><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                            <li>{{ __('blogs') }}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- All Section Wrapper Start -->
    <section class="section__Wrapper pt-35 pb-80">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="all__filter">
                        <div class="showing">
                            <div class="icon"><i class="ri-apps-2-line"></i></div>

                            @include('website.blog.partials.showing')
                        </div>
                        <div class="filter__wrapper">
                            <a href="{{ route('blogs') }}" class="solid__btn gap-0">
                                {{ __('clear') }}<i class="ri-close-line fs-17px"></i></a>
                        </div>
                    </div>
                    <!-- Filter Flex Item -->
                    <div class="filter__flex d-flex align-items-start gap-5">

                        @include('website.blog.sidebar')

                        <!-- Main Wrapper Start -->
                        <div class="filter__inner flex-1">
                            <div class="filter__items mt-0">
                                <div class="inner__section">
                                    <div class="grid-5" id="blog-content">
                                        @include('website.blog.partials.blog_cards')
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Main Wrapper End -->
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12" id="paginations">
                    @include('website.blog.partials.pagination')
                </div>
            </div>
        </div>
    </section>
    <!-- All Section Wrapper End -->

@endsection

@push('js')
    <script>
        "use strict";

        function fetchBlogs(page = 1) {
            let search = $('#search').val();
            let categories = $('.category-checkbox:checked').map(function() {
                return $(this).val();
            }).get();

            let years = $('.year-checkbox:checked').map(function() {
                return $(this).val();
            }).get();

            $.ajax({
                url: "{{ route('blogs') }}",
                type: 'GET',
                data: {
                    search: search,
                    category_filter: categories,
                    year_filter: years,
                    page: page
                },
                beforeSend: function() {
                    $('#blog-content').html('<div class="text-center">Loading...</div>');
                },
                success: function(res) {
                    $('#blog-content').html(res.blogs);
                    $('#showing').html(res.showing);
                    $('#paginations').html(res.paginations);

                },
                error: function(err) {
                    console.error(err);
                }
            });
        }

        $(document).ready(function() {
            // On search
            $('#search').on('keyup', function() {
                fetchBlogs();
            });

            // On category/year checkbox change
            $('.category-checkbox, .year-checkbox').on('change', function() {
                fetchBlogs();
            });

            // Handle clear
            $('.solid__btn').on('click', function(e) {
                e.preventDefault();
                $('#search').val('');
                $('.category-checkbox, .year-checkbox').prop('checked', false);
                fetchBlogs();
            });

            // Handle pagination click (delegated because links are loaded dynamically)
            $(document).on('click', '.pagination a', function(e) {
                e.preventDefault();
                let page = $(this).attr('href').split('page=')[1];
                fetchBlogs(page);
            });
        });
    </script>
@endpush
