@extends('website.layouts.master')
@section('title', __('blog_details'))
@section('content')

    @php
        $blogUrl = urlencode(request()->fullUrl());
        $blogTitle = urlencode($blog->title ?? 'Check this out');
    @endphp

    <!-- Breadcrumb Start -->
    <div class="breadcrumb__area">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="breadcrumb__title">
                        <ul class="link">
                            <li><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                            <li><a href="{{ route('blogs') }}">{{ __('blogs') }}</a></li>
                            <li>{{ $slug }}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- All Section Wrapper Start -->
    <section class="blogSingle__section pt-35 pb-80">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="blogSingle__wrapper">
                        <div class="blog__inner">
                            <h4 class="blog__title"> {{ $blog->title }} </h4>
                            <ul class="blog__meta">
                                <li class="date"><i
                                        class="ri-calendar-line"></i>{{ date('d M Y', strtotime($blog->created_at)) }}</li>
                                <li class="date"><i class="ri-chat-4-line"></i><a href="javascript:void(0)">{{get_review_count($blog->id)}}</a></li>
                                <li class="date"><i class="ri-user-3-line"></i><a
                                        href="javascript:void(0)">{{ adminInfo('first_name') . ' ' . adminInfo('last_name') }}</a>
                                </li>
                            </ul>
                            {!! $blog->description !!}
                        </div>
                        <div class="shareOption">
                            <div class="shareTitle"><i class="ri-share-line"></i>{{ __('share_with') }}</div>
                            <ul class="social__icon">
                                <li>
                                    <a href="https://www.facebook.com/sharer/sharer.php?u={{ $blogUrl }}"
                                        target="_blank">
                                        <img src="{{ static_asset('website/images/social-icon/facebook.svg') }}"
                                            alt="Facebook" />
                                    </a>
                                </li>
                                <li>
                                    <a href="https://twitter.com/intent/tweet?url={{ $blogUrl }}&text={{ $blogTitle }}"
                                        target="_blank">
                                        <img src="{{ static_asset('website/images/social-icon/twitter.svg') }}"
                                            alt="Twitter" />
                                    </a>
                                </li>
                                <li>
                                    <a href="https://www.linkedin.com/shareArticle?mini=true&url={{ $blogUrl }}&title={{ $blogTitle }}"
                                        target="_blank">
                                        <img src="{{ static_asset('website/images/social-icon/linkedin.svg') }}"
                                            alt="LinkedIn" />
                                    </a>
                                </li>
                                <li>
                                    <a
                                        href="mailto:?subject={{ urlencode($blog->title) }}&body={{ urlencode(request()->fullUrl()) }}">
                                        <img src="{{ static_asset('website/images/social-icon/mail.png') }}"
                                            alt="Email" />
                                    </a>
                                </li>
                                <li>
                                    <a href="https://t.me/share/url?url={{ urlencode(request()->fullUrl()) }}&text={{ urlencode($blog->title) }}"
                                        target="_blank">
                                        <img src="{{ static_asset('website/images/social-icon/telegram.png') }}"
                                            alt="Telegram" />
                                    </a>
                                </li>
                                <li>
                                    <a href="https://api.whatsapp.com/send?text={{ urlencode($blog->title . ' ' . request()->fullUrl()) }}"
                                        target="_blank">
                                        <img src="{{ static_asset('website/images/social-icon/whatsapp.png') }}"
                                            alt="WhatsApp" />
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <!-- Related Blog Post -->
                        <!-- Video Section Start -->
                        @if (count($related_blogs) > 0)    
                            <div class="related__area mb-40">
                                <div class="section__title">
                                    <h2 class="title">{{ __('related_blog') }}</h2>
                                </div>
                                <div class="position-relative">
                                    <div class="swiper blog__slider">
                                        <div class="swiper-wrapper">
                                            @foreach ($related_blogs as $related_blog)
                                                <!-- Slide -->
                                                <div class="swiper-slide">
                                                    <div class="blogCard">
                                                        @if ($blog->is_top > 0)
                                                            <div class="badge">{{ __('top_news') }}</div>
                                                        @endif
                                                        <a href="{{ route('blog.details', ['slug' => $related_blog->slug]) }}"
                                                            class="blogCard__thumb">
                                                            <img src="{{ getFileLink('image', $related_blog->image, 'blogs', '540x280') }}"
                                                                alt="blog" />
                                                        </a>
                                                        <div class="blogCard__content">
                                                            <h4 class="title">
                                                                <a
                                                                    href="{{ route('blog.details', ['slug' => $related_blog->slug]) }}">{{ $related_blog->title }}</a>
                                                            </h4>
                                                            <p class="desc"> {{ $related_blog->focus_keyword }} </p>
                                                            <div class="blogCard__meta">
                                                                <span><i
                                                                        class="ri-calendar-2-line"></i>{{ date('d M y', strtotime($related_blog->created_at)) }}</span>
                                                                <a href="javascript:void(0)"><i
                                                                        class="ri-user-3-line"></i>{{ adminInfo('first_name') . ' ' . adminInfo('last_name') }}</a>
                                                                <a href="javascript:void(0)"><i class="ri-film-line"></i>
                                                                    {{ $related_blog->category?->title }}
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                    <div class="swiper__navigation">
                                        <div class="blog-swipe-prev swiper-button-prev">
                                            <i class="ri-arrow-left-s-line"></i>
                                        </div>
                                        <div class="blog-swipe-next swiper-button-next">
                                            <i class="ri-arrow-right-s-line"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                        <!-- Video Section End -->
                        <!-- Related Blog Post -->
                        @if (!auth()->user()?->hasReviewed($blog))
                            <form action="{{ route('review.store.blog', $blog->id) }}" method="POST"
                                class="all__comments">
                                @csrf
                                <input type="hidden" name="reviewable_id" value="{{ $blog->id }}">
                                <input type="hidden" name="rating" id="rating-value" value="">

                                <div class="commentsRating">
                                    <h5 class="comments">{{ count($blog->reviews) }} {{ __('reviews') }}
                                    </h5>
                                    <div class="rating__inline">
                                        <span class="title">{{ __('submit_rating') }} :</span>
                                        <div class="rating" id="star-rating">
                                            @for ($i = 1; $i <= 10; $i++)
                                                <a href="javascript:void(0)" data-value="{{ $i }}"><i
                                                        class="ri-star-line"></i></a>
                                            @endfor
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <textarea name="review" class="form-control" cols="30" rows="8" placeholder="Write Something"></textarea>
                                </div>

                                <div class="submit-btn">
                                    <button type="submit" class="btn btn-primary">{{ __('post') }}</button>
                                </div>
                            </form>
                        @endif
                        <div class="clients__review">
                            <h4 class="review__title">{{ count($blog->reviews) }} {{ __('reviews') }}</h4>
                            <div class="review__wrapper">
                                @foreach ($blog->reviews as $review)
                                    <div class="review__item">
                                        <div class="d-flex justify-content-between">
                                            <div class="d-flex align-items-center gap-4">
                                                <div class="avatar">
                                                    <img src="{{ getFileLink('user', $review->user->image, 'users', '80x80') }}"
                                                        alt="avatar" />
                                                </div>
                                                <div class="review__content">
                                                    <h5>{{ $review->user->first_name . ' ' . $review->user->last_name }}
                                                    </h5>
                                                    <span>{{ $review->created_at->format('d F, Y') }}</span>
                                                </div>
                                            </div>
                                            <div>
                                                @php
                                                    $filled = $review->rating;
                                                    $empty = 10 - $filled;
                                                @endphp

                                                <span class="text-white">
                                                    <strong>{{ __('ratings') }}: </strong>
                                                    {!! str_repeat('★', $filled) !!}{!! str_repeat('☆', $empty) !!}
                                                </span>

                                            </div>
                                        </div>
                                        <p class="desc">
                                            {{ $review->review }}
                                        </p>

                                        @if ($review->reply)
                                            <div class="sub__replay">
                                                <div class="replay">
                                                    <a href="javascript:void(0)"><i
                                                            class="ri-corner-left-up-line"></i>{{ __('reply') }}</a>
                                                </div>
                                                <div class="review__item">
                                                    <div class="d-flex align-items-center gap-4">
                                                        <div class="avatar">
                                                            <img src="{{ asset('assets/images/user.png') }}"
                                                                alt="avatar" />
                                                        </div>
                                                        <div class="review__content">
                                                            <h5>{{ __('admin') }}</h5>
                                                            <span>{{ $review->updated_at->format('d F, Y') }}</span>
                                                        </div>
                                                    </div>
                                                    <p class="desc">
                                                        {{ $review->reply }}
                                                    </p>
                                                </div>
                                            </div>
                                        @endif

                                        <!-- Reaction meta -->
                                        <div class="reaction__meta">
                                            <a href="javascript:void(0)" class="avarage__reaction like-btn"
                                                data-review-id="{{ $review->id }}"
                                                data-liked="{{ auth()->check() && $review->isLikedBy(auth()->user()) ? '1' : '0' }}">
                                                @if (auth()->check() && $review->isLikedBy(auth()->user()))
                                                    <i class="ri-thumb-up-fill text-primary"></i>
                                                @else
                                                    <i class="ri-thumb-up-line"></i>
                                                @endif
                                                <span class="like-count">{{ $review->likes()->count() }}</span>
                                            </a>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- All Section Wrapper End -->


@endsection

@include('website.component.like_review')
