@if ($paginator->hasPages())
    <nav class="pagination__wrapper justify-content-end">
        {{-- <p class="pagination__show">Showing {{ $paginator->firstItem() }} to {{ $paginator->lastItem() }} of {{ $paginator->total() }} entries</p> --}}
        <ul class="pagination">
            {{-- Previous Page Link --}}
            @if ($paginator->onFirstPage())
                <li class="disabled"><span class="btn"><i class="ri-arrow-left-s-line"></i>Previous</span></li>
            @else
                <li><a href="{{ $paginator->previousPageUrl() }}" class="btn"><i class="ri-arrow-left-s-line"></i>Previous</a></li>
            @endif

            {{-- Pagination Elements --}}
            @foreach ($elements as $element)
                {{-- "Three Dots" Separator --}}
                @if (is_string($element))
                    <li class="disabled"><span>{{ $element }}</span></li>
                @endif

                {{-- Array Of Links --}}
                @if (is_array($element))
                    @foreach ($element as $page => $url)
                        @if ($page == $paginator->currentPage())
                            <li class="active"><a href="javascript:void(0)">{{ $page }}</a></li>
                        @else
                            <li><a href="{{ $url }}">{{ $page }}</a></li>
                        @endif
                    @endforeach
                @endif
            @endforeach

            {{-- Next Page Link --}}
            @if ($paginator->hasMorePages())
                <li><a href="{{ $paginator->nextPageUrl() }}" class="btn">Next<i class="ri-arrow-right-s-line"></i></a></li>
            @else
                <li class="disabled"><span class="btn">Next<i class="ri-arrow-right-s-line"></i></span></li>
            @endif
        </ul>
    </nav>
@endif
