<style>
    .custom__checkbox {
        cursor: pointer;
        padding: 5px 10px;
        border-radius: 4px;
        user-select: none;
        transition: background 0.3s ease;
    }

    .custom__checkbox.checked {
        color: #fff;
    }
</style>
<div class="userInfo__header">
    <h4 class="title">{{ __('payment_history') }}</h4>
    <div class="filter__wrapper">
        <div class="filter__dropdown">
            <div class="selected">{{ __(request('time_filter') ?? 'this_month') }}</div>
            <ul class="filter__list">
                <li class="custom__checkbox">
                    <input type="checkbox" name="chack" id="all" />
                    <label for="all">{{ __('all') }}</label>
                </li>
                <li class="custom__checkbox">
                    <input type="checkbox" name="chack" id="this_month" />
                    <label for="this_month">{{ __('this_month') }}</label>
                </li>
                <li class="custom__checkbox">
                    <input type="checkbox" name="chack" id="last_month" />
                    <label for="last_month">{{ __('last_month') }}</label>
                </li>
                <li class="custom__checkbox">
                    <input type="checkbox" name="chack" id="1_month_ago" />
                    <label for="1_month_ago">{{ __('1_month_ago') }}</label>
                </li>
                <li class="custom__checkbox">
                    <input type="checkbox" name="chack" id="2_month_ago" />
                    <label for="2_month_ago">{{ __('2_month_ago') }}</label>
                </li>
                <li class="custom__checkbox">
                    <input type="checkbox" name="chack" id="3_month_ago" />
                    <label for="3_month_ago">{{ __('3_month_ago') }}</label>
                </li>
            </ul>
        </div>
    </div>
</div>
<div class="payment__history mt-30">

    <!-- Payment Card -->
    @foreach ($paymentHistories as $paymentHistory)
        <a href="{{ route('packages') }}" class="paymentCard">
            <div class="left">
                <div class="icon">
                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                        xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_2233_9412)">
                            <path
                                d="M15.1773 3.044C14.9337 2.94252 14.6654 2.91585 14.4066 2.96738C14.1478 3.0189 13.9102 3.1463 13.724 3.33333L12 5.05733L8.94267 2C8.69263 1.75004 8.35355 1.60962 8 1.60962C7.64645 1.60962 7.30737 1.75004 7.05733 2L4 5.05733L2.276 3.33333C2.08953 3.14692 1.85198 3.01998 1.59338 2.96856C1.33477 2.91713 1.06673 2.94354 0.823127 3.04443C0.579528 3.14532 0.37131 3.31618 0.224798 3.53539C0.0782854 3.7546 5.62991e-05 4.01233 0 4.276L0 11.3333C0.00105857 12.2171 0.352588 13.0643 0.97748 13.6892C1.60237 14.3141 2.4496 14.6656 3.33333 14.6667H12.6667C13.5504 14.6656 14.3976 14.3141 15.0225 13.6892C15.6474 13.0643 15.9989 12.2171 16 11.3333V4.276C16.0001 4.01231 15.9219 3.75453 15.7755 3.53523C15.6291 3.31594 15.4209 3.14499 15.1773 3.044ZM14.6667 11.3333C14.6667 11.8638 14.456 12.3725 14.0809 12.7475C13.7058 13.1226 13.1971 13.3333 12.6667 13.3333H3.33333C2.8029 13.3333 2.29419 13.1226 1.91912 12.7475C1.54405 12.3725 1.33333 11.8638 1.33333 11.3333V4.276L3.52867 6.47133C3.65369 6.59632 3.82322 6.66653 4 6.66653C4.17678 6.66653 4.34631 6.59632 4.47133 6.47133L8 2.94267L11.5287 6.47133C11.6537 6.59632 11.8232 6.66653 12 6.66653C12.1768 6.66653 12.3463 6.59632 12.4713 6.47133L14.6667 4.276V11.3333Z"
                                fill="white" />
                        </g>
                    </svg>
                </div>
                <div class="content">
                    <h5 class="title">{{ $paymentHistory->package->name }}</h5>
                    @if ($paymentHistory->transaction_id)
                        <span>{{ __('transaction_id:') . ' ' . $paymentHistory->transaction_id }}</span>
                    @else
                        <span> {{ __('trx_id:') . ' ' . $paymentHistory->trx_id }}</span>
                    @endif
                </div>
            </div>
            <div class="right">
                <div class="content text-end">
                    <h5 class="title text-primary">{{ get_currency($paymentHistory->price) }}</h5>
                    <span>
                        {{ \Carbon\Carbon::parse($paymentHistory->created_at)->format('d/m/Y, h:i A') }}
                    </span>
                </div>
                <div class="arrow"><i class="ri-arrow-right-s-line"></i></div>
            </div>
        </a>
    @endforeach

    <nav class="pagination__wrapper justify-content-end">
        {{ $paymentHistories->appends(request()->query())->links('vendor.pagination.default') }}
    </nav>
</div>

@push('js')
    <script>
        "use strict";

        $(function() {
            $('.filter__list input[type="checkbox"]').on('change', function() {
                // Uncheck other checkboxes
                $('.filter__list input[type="checkbox"]').not(this).prop('checked', false);

                // Get the selected filter ID (e.g., this_month, last_month)
                let selected = $(this).attr('id');

                // Build URL with filter and redirect
                let url = new URL(window.location.href);
                url.searchParams.set('time_filter', selected);
                url.searchParams.set('tab', 'payment_history');
                window.location.href = url.toString();
            });

            // Auto-check checkbox based on URL
            let currentFilter = new URLSearchParams(window.location.search).get('time_filter');
            if (currentFilter) {
                $('#' + currentFilter).prop('checked', true);
            }
        });
    </script>
@endpush
