@php
    if ($history->watchable_type == 'movie') {
        $thumbnail = $history->movie->thumbnail;
        $title = $history->movie->title;
        $movie_id = $history->movie->id;
        if (is_rent_expire('movie', $movie_id) && is_rental('movie', $movie_id) || is_free('movie', $movie_id) || check_subscription() && !is_rental('movie', $movie_id) || is_admin()) {
            $video_url = route('watch.movie', ['slug' => $history->movie->slug]);
        }
    } elseif($history->watchable_type == 'episode') {
        $thumbnail = $history->episode->poster;
        $title = $history->episode->episode_name;
        $series_id = $history->episode->tv_show_id;
        $order = $history->episode->order;
        if (is_rent_expire('series', $series_id) && is_rental('series', $series_id) || is_free('series', $series_id) || check_subscription() && !is_rental('series', $series_id) || is_admin()) {
            $video_url = route('watch.episode', ['slug' => $history->episode->slug]);
        }
    }
@endphp

<div class="video__card">
    <a href="{{ isset($video_url) ? $video_url : route('packages') }}" class="video__thumb">
        <div class="imageCard">
            <img src="{{ getFileLink('thumbnail', $thumbnail, 'thumbnails', '500x750') }}" alt="imageCard" />
            <div class="video__btn">
                <i class="ri-play-fill"></i>
            </div>
            <div class="imageCard__content">
                <h4 class="title">{{ $title }}</h4>
                <span class="duration">{{ watch_history_duration($history->watchable_type, $history->duration, $history->watched_seconds, $order ?? 0) }}</span>
                <div class="bar">
                    <div class="{{ $history->completion_percentage > 0 ? 'bar__active' : '' }}"
                         style="width: {{ $history->completion_percentage > 0 ? $history->completion_percentage : 100 }}%">
                    </div>
                </div>
            </div>
        </div>
    </a>
</div>