<div class="p-5">
    <div class="heading__content">
        <h2 class="title">{{ __('login_with_phone!') }}</h2>
        <p class="desc">{{ __('please_enter_your_otp') }}</p>
    </div>
    <div class="form-group">
        <label for="login-phone">
            {{ __('otp') }}
            <span class="required">*</span>
        </label><input type="hidden" id="phone" value="{{ request('phone') }}">
        <input type="text" class="form-control" name="otp" id="otp" placeholder="{{ __('your_otp') }}" />
        <span id="error-otp"></span>
    </div>

    <button type="button" id="verifyOTP" name="btn" class="btn btn-primary w-100">{{ __('verify') }}</button>
</div>

<script>
    "use strict";
    $('#verifyOTP').on('click', function() {
        const phone = $('#phone').val();
        const otp = $('#otp').val();
        if (!phone) {
            $('#error-otp').text("{{ __('otp_is_required') }}");
            return;
        }
        $.ajax({
            url: 'auth/verify-otp-post',
            type: 'POST',
            data: {
                _token: $('meta[name="csrf-token"]').attr('content'),
                phone: '+' + phone,
                otp: otp
            },
            success: function(res) {
                toastr.success(res.success);
                // ✅ Redirect to dashboard or any route returned
                if (res.redirect) {
                    window.location.href = res.redirect;
                }
            },
            error: function(xhr) {
                toastr.error(xhr.responseJSON.error);
            }
        });
    });
</script>
