@extends('website.layouts.master')
@section('title', __('home_page'))
@section('content')

    <!-- Movie Request Modal Start -->
    <div class="custom__popup pt-150 pb-80">
        <div class="modal-dialog ">
            <div class="modal-content">
                <div class="modal-body p-0">
                    <div class="form__wrapper p-5">
                        <form action="{{ route('password.store') }}" enctype="multipart/form-data" id="resetPasswordForm"
                            method="post">
                            @csrf
                            <input type="hidden" name="email" value="{{ $request->email }}">
                            <div class="heading__content">
                                <h2 class="title2">{{ __('reset_password') }}</h2>
                            </div>
                            <hr />
                            <div class="form-group">
                                <label for="new_password">{{ __('new_password') }}</label>
                                <input type="password" name="password" class="form-control" id="password"
                                    placeholder="{{ __('new_password') }}" />
                                <span class="text-danger" id="error-password"></span>
                            </div>
                            <div class="form-group">
                                <label for="confirm_password">{{ __('confirm_password') }}</label>
                                <input type="password" name="password_confirmation" class="form-control"
                                    id="confirm_password" placeholder="{{ __('confirm_password') }}" />
                                <span class="text-danger" id="error-confirm_password"></span>
                            </div>

                            <div class="btn__group d-flex align-items-center justify-content-end gap-3">
                                <button type="button" name="btn" class="btn btn-primary"
                                    onclick="submitResetPasswordForm()">{{ __('confirm') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Movie Request Modal End-->

    <script>
        "use strict";

        function submitResetPasswordForm() {
            const form = $('#resetPasswordForm');
            const formData = new FormData(form[0]);
            // Clear previous error messages
            $('#error-password, #error-confirm_password').html('');

            $.ajax({
                url: form.attr('action'),
                method: form.attr('method'),
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    window.location.href = "{{ route('home') }}"
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        const errors = xhr.responseJSON.errors;
                        if (errors.password) {
                            $('#error-password').html(errors.password[0]);
                        }
                        if (errors.confirm_password) {
                            $('#error-confirm_password').html(errors.confirm_password[0]).addClass(
                                'text-danger');
                        }
                    } else {
                        alert('{{ __('unexpected_error_try_again') }}');
                    }
                }
            });
        }
    </script>

@endsection
