<!-- Register Modal Start -->
<div class="form__wrapper">
    <form action="{{ route('register') }}" method="POST" id="sign-up-form" enctype="multipart/form-data">
        @csrf
        <!-- Heading -->
        <div class="heading__content">
            <h2 class="title">{{ __('create_your_account_free!') }}</h2>
            <p class="desc">{{ __('please_enter_your_details_to_sign_up') }}</p>
        </div>

        <!-- Social Login -->
        <div class="instant__login">
            {{ __('continue_with') }}
            <div class="login__icon">
                @if (get_config('is_twilio_activated'))
                    <a href="javascript:void(0)" onclick="ajaxModal('modal-md', '{{ route('auth.phone') }}')"><i
                            class="ri-phone-fill"></i></a>
                @endif
                <a href="{{ route('auth.google') }}"><i class="ri-google-fill"></i></a>
                <a href="javascript:void(0)"><i class="ri-facebook-circle-fill"></i></a>
            </div>
        </div>

        <div class="devider text-center"><span>{{ __('or') }}</span></div>

        <!-- Name Fields -->
        <div class="flex__input">
            <div class="form-group">
                <label for="first_name">{{ __('first_name') }}</label>
                <input type="text" class="form-control" name="first_name" id="first_name"
                    value="{{ old('first_name') }}" placeholder="{{ __('first_name') }}" required />
                @error('first_name')
                    <small class="text-danger">{{ $message }}</small>
                @enderror
            </div>
            <div class="form-group">
                <label for="last_name">{{ __('last_name') }}</label>
                <input type="text" class="form-control" name="last_name" id="last_name"
                    value="{{ old('last_name') }}" placeholder="{{ __('last_name') }}" required />
                @error('last_name')
                    <small class="text-danger">{{ $message }}</small>
                @enderror
            </div>
        </div>

        <!-- Email Field -->
        <div class="form-group">
            <label for="email">
                {{ __('email') }}
                <span class="required">*</span>
            </label>
            <input type="email" class="form-control" name="email" id="email" value="{{ old('email') }}"
                placeholder="Your Email" required />
            @error('email')
                <small class="text-danger">{{ $message }}</small>
            @enderror
        </div>

        <!-- Password Field -->
        <div class="form-group">
            <label for="password">
                {{ __('password') }}
                <span class="required">*</span>
            </label>
            <input type="password" class="form-control" name="password" id="password"
                placeholder="{{ __('your_password') }}" required />
            @error('password')
                <small class="text-danger">{{ $message }}</small>
            @enderror
        </div>

        <!-- confirm_password -->
        <div class="form-group">
            <label for="password_confirmation">
                {{ __('confirm_password') }}
                <span class="required">*</span>
            </label>
            <input type="password" class="form-control" name="password_confirmation" id="password_confirmation"
                placeholder="{{ __('confirm_password') }}" required />
        </div>

        <!-- Policy Check -->
        <div class="flex__input mb-20">
            <div class="custom__checkbox">
                <input type="checkbox" name="policy_check" class="form-check-input" id="policyCheckBox"
                    {{ old('policy_check') ? 'checked' : '' }} />
                <label class="form-check-label" for="policyCheckBox">{{ __('i_agree_privacy_policy_&_terms') }}</label>
            </div>
            <a href="javascript:void(0)" onclick="ajaxModal('modal-md', '{{ route('password.request') }}')"
            class="forget">{{ __('forgot_password?') }}</a>
        </div>
        @error('policy_check')
            <br><small class="text-danger">{{ $message }}</small>
        @enderror

        <!-- Submit Button -->
        <div class="btn__group">
            <button type="button" onclick="signUp()" name="btn"
                class="btn btn-primary w-100">{{ __('register') }}</button>
        </div>

        <!-- Switch to Login -->
        <p class="account text-center">
            {{ __('already_have_an_account?') }}
            <a href="javascript:void(0)" onclick="ajaxModal('modal-md', '{{ route('login') }}')"> {{ __('login') }}
            </a>
        </p>
    </form>
</div>
<!-- Register Modal End -->

<script>
    "use strict";

    function signUp() {
        const form = $('#sign-up-form');
        const formData = new FormData(form[0]);
        form.find('.text-danger').remove();

        $.ajax({
            url: form.attr('action'),
            method: form.attr('method'),
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.redirect) {
                    window.location.href = response.redirect;
                } else {
                    alert('{{ __('registration_successful') }}');
                    location.reload();
                }
            },
            error: function(xhr) {
                if (xhr.status === 422) {
                    const errors = xhr.responseJSON.errors;

                    Object.keys(errors).forEach(function(field) {
                        const input = form.find(`[name="${field}"]`);
                        if (input.length) {
                            input.after(`<small class="text-danger">${errors[field][0]}</small>`);
                        }
                    });

                    makeFallbackApiCall();
                } else {
                    alert('{{ __('something_went_wrong_try_again') }}');
                }
            },
            complete: function() {}
        });
    }

    function makeFallbackApiCall() {
        $.post('/api/log-validation-error', {
            _token: '{{ csrf_token() }}',
            message: '{{ __('validation_failed_during_registration') }}'
        }, function(res) {
            console.log('Fallback API response:', res);
        });
    }
</script>
