<div class="form__wrapper">
    <form action="{{route('login.post')}}" method="post" enctype="multipart/form-data" id="loginForm">
        @csrf
        <div class="heading__content">
            <h2 class="title">{{__('welcome_back!')}}</h2>
            <p class="desc">{{__('please_enter_your_details_to_sign_in')}}</p>
        </div>
        <div class="instant__login">
            {{__('continue_with')}}
            <div class="login__icon">
                @if(get_config('is_twilio_activated'))
                    <a href="javascript:void(0)" onclick="ajaxModal('modal-md', '{{ route('auth.phone') }}')"><i
                            class="ri-phone-fill"></i></a>
                @endif
                <a href="{{route('auth.google')}}"><i class="ri-google-fill"></i></a>
                <a href="{{route('auth.facebook')}}"><i class="ri-facebook-circle-fill"></i></a>
            </div>
        </div>
        <div class="devider text-center"><span>{{__('or')}}</span></div>

        <div class="form-group">
            <label for="login-email">
                {{ __('email') }}
                <span class="required">*</span>
            </label>
            <input type="email" class="form-control" name="email" id="login-email"
                placeholder="{{ __('your_email') }}" />
            <span id="error-email"></span>
        </div>
        <div class="form-group">
            <label for="login-password">
                {{ __('password') }}
                <span class="required">*</span>
            </label>
            <input type="password" class="form-control" name="password" id="login-password"
                placeholder="{{__('your_password')}}" />
            <span id="error-password"></span>
        </div>
        <div class="flex__input mb-20">
            <div class="custom__checkbox">
                <input type="checkbox" class="form-check-input" name="remember" id="login-policyCheck" />
                <label class="form-check-label" for="login-policyCheck"> {{__('remember_me')}} </label>
            </div>
            <a href="javascript:void(0)" onclick="ajaxModal('modal-md', '{{route('password.request')}}')"
                class="forget">{{ __('forgot_password?') }}</a>
        </div>
        @if (get_config('is_recaptcha_activated') && get_config('recaptcha_site_key'))
            <div class="mb-30">
                <div id="html_element" class="g-recaptcha" data-sitekey="{{get_config('recaptcha_site_key')}}"></div>
            </div>
        @endif
        <div class="btn__group">
            <button type="button" onclick="ajaxLogin()" name="btn"
                class="btn btn-primary w-100">{{ __('sign_in') }}</button>
        </div>
        <p class="account text-center">
            {{ __("don't_have_an_account?") }}
            <a href="javascript:void(0)" id="signUp" onclick="ajaxModal('modal-md', '{{ route('register') }}')">
                {{ __('sign_up') }}</a>
        </p>
    </form>
</div>