@extends('admin.layouts.master')
@section('title', __('website_seo'))
@section('content')
    <section class="oftions">
        <div class="container-fluid">
            <div class="row">
                @include('admin.website.sidebar_component')
                <div class="col-xxl-9 col-lg-8 col-md-8">
                    <h3 class="section-title">{{ __('seo_setting') }}</h3>
                    <div class="bg-white redious-border p-20 p-sm-30">

                        <form action="{{ route('admin.theme.options.post') }}" method="POST" class="form">@csrf
                            <div class="row gx-20">
                                <div class="col-lg-12">
                                    <div class="mb-4">
                                        <label for="authorName" class="form-label">{{ __('author_name') }}</label>
                                        <input type="text" class="form-control rounded-2" id="authorName"
                                            value="{{ get_config('author_name') }}" name="author_name"
                                            placeholder="{{ __('enter_author_name') }}">
                                        <div class="nk-block-des text-danger">
                                            <p class="author_name_error error"></p>
                                        </div>
                                    </div>
                                </div>
                                @include('admin.website.component.meta-fields', [
                                    'meta_title' => get_config('meta_title'),
                                    'meta_description' => get_config('meta_description'),
                                    'meta_keywords' => get_config('meta_keywords'),
                                    'meta_image' => get_config('meta_image'),
                                    'is_input' => 1
                                ])
                               @include('admin.website.component.og-fields', [
                                'og_title' => get_config('og_title'),
                                'og_description' => get_config('og_description'),
                                'og_image' => get_config('og_image')
                            ])
                                <!-- End Meta Image -->
                                <div class="d-flex justify-content-between align-items-center mt-30">
                                        <button type="submit" class="btn sg-btn-primary">{{ __('update') }}</button>
                                            @include('admin.common.loading-btn', [
                                                'class' => 'btn sg-btn-primary',
                                            ])
                                        </div>

                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
@endsection

