@extends('admin.layouts.master')
@section('title', __('legal_pages_settings'))
@section('content')
    <section class="oftions">
        <div class="container-fluid">
            <div class="row">
                @include('admin.website.sidebar_component')
                <div class="col-xxl-9 col-lg-8 col-md-8">
                    <h3 class="section-title">{{ __('legal_pages') }}</h3>
                    <div
                        class="default-tab-list default-tab-list-v2  bg-white redious-border website-setting-social-link p-20 p-sm-30">
                        @include('admin.website.component.footer_setting_sidebar')
                        <form action="{{ route('footer.update-setting') }}" method="POST" class="form">@csrf
                            <div class="row gx-20">
                                <div class="d-flex gap-12 sandbox_mode_div mb-4">
                                    <input type="hidden" name="show_legal_page_links"
                                        value="{{ get_config('show_legal_page_links') == 1 ? 1 : 0 }}">
                                    <label class="form-label" for="show_legal_page_links">{{ __('show_legal_page_links')
                                                            }}</label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" id="show_legal_page_links" class="sandbox_mode" {{
        get_config('show_legal_page_links') == 1 ? 'checked' : '' }}>
                                        <label for="show_legal_page_links"></label>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="mb-4">
                                        <label for="terms_and_conditions" class="form-label">{{__('terms_&_conditions')
                                                                }}</label>
                                        <input type="text" class="form-control rounded-2" id="terms_and_conditions"
                                            name="terms_and_conditions"
                                            placeholder="{{ __('enter_terms_and_conditions_link') }}"
                                            value="{{ get_config('terms_and_conditions') }}">
                                        <div class="nk-block-des text-danger">
                                            <p class="terms_and_conditions_error error"></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="mb-4">
                                        <label for="privacy_policy_link" class="form-label">{{__('privacy_policy_link')
                                                                }}</label>
                                        <input type="text" class="form-control rounded-2" id="privacy_policy_link"
                                            name="privacy_policy_link" placeholder="{{ __('enter_privacy_policy_link') }}"
                                            value="{{ get_config('privacy_policy_link') }}">
                                        <div class="nk-block-des text-danger">
                                            <p class="privacy_policy_link_error error"></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="mb-4">
                                        <label for="payment_policy_link" class="form-label">{{__('payment_policy_link')
                                                                }}</label>
                                        <input type="text" class="form-control rounded-2" id="payment_policy_link"
                                            name="payment_policy_link" placeholder="{{ __('enter_payment_policy_link') }}"
                                            value="{{ get_config('payment_policy_link') }}">
                                        <div class="nk-block-des text-danger">
                                            <p class="payment_policy_link_error error"></p>
                                        </div>
                                    </div>
                                </div>

                                <div class="d-flex justify-content-between align-items-center mt-30">

                                    <button type="submit" class="btn sg-btn-primary">{{ __('update') }}</button>
                                    @include('admin.common.loading-btn', ['class' => 'btn sg-btn-primary'])
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    @include('admin.website.component.new_menu')
@endsection