@extends('admin.layouts.master')
@section('title', __('help_center_settings'))
@section('content')
    <section class="oftions">
        <div class="container-fluid">
            <div class="row">
                @include('admin.website.sidebar_component')
                <div class="col-xxl-9 col-lg-8 col-md-8">
                    <h3 class="section-title">{{ __('help_center') }}</h3>
                    <div
                        class="default-tab-list default-tab-list-v2  bg-white redious-border website-setting-social-link p-20 p-sm-30">
                        @include('admin.website.component.footer_setting_sidebar')
                        <form action="{{ route('footer.update-setting') }}" method="POST" class="form">@csrf
                            <div class="row gx-20">
                                <div class="d-flex gap-12 sandbox_mode_div mb-4">
                                    <input type="hidden" name="show_help_center_links"
                                        value="{{ get_config('show_help_center_links') == 1 ? 1 : 0 }}">
                                    <label class="form-label"
                                        for="show_help_center_links">{{ __('show_help_center_links') }}</label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" id="show_help_center_links" class="sandbox_mode" {{ get_config('show_help_center_links') == 1 ? 'checked' : '' }}>
                                        <label for="show_help_center_links"></label>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="mb-4">
                                        <label for="faqs" class="form-label">{{__('faqs') }}</label>
                                        <input type="text" class="form-control rounded-2" id="faqs" name="faqs_link"
                                            disabled placeholder="{{ __('enter_faqs_link') }}" value="{{ url('faqs') }}">
                                        <div class="nk-block-des text-danger">
                                            <p class="faqs_link_error error"></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="mb-4">
                                        <label for="contact" class="form-label">{{__('contact') }}</label>
                                        <input type="text" class="form-control rounded-2" id="contact" name="contact_link"
                                            placeholder="{{ __('enter_contact_link') }}" value="{{ url('contact-us') }}"
                                            disabled>
                                        <div class="nk-block-des text-danger">
                                            <p class="contact_error error"></p>
                                        </div>
                                    </div>
                                </div>

                                <div class="d-flex justify-content-between align-items-center mt-30">

                                    <button type="submit" class="btn sg-btn-primary">{{ __('update') }}</button>
                                    @include('admin.common.loading-btn', ['class' => 'btn sg-btn-primary'])
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    @include('admin.website.component.new_menu')
@endsection