@extends('admin.layouts.master')
@section('title', __('copyright_settings'))
@section('content')
    <section class="oftions">
        <div class="container-fluid">
            <div class="row">
                @include('admin.website.sidebar_component')
                <div class="col-xxl-9 col-lg-8 col-md-8">
                    <h3 class="section-title">{{ __('copyright_settings') }}</h3>
                    <div class="default-tab-list default-tab-list-v2  bg-white redious-border website-setting-social-link p-20 p-sm-30">
                        @include('admin.website.component.footer_setting_sidebar')
                        <form action="{{ route('footer.update-setting') }}" method="POST" class="form">@csrf

                            <div class="row gx-20">
                                <div class="d-flex gap-12 sandbox_mode_div mb-4">
                                    <input type="hidden" name="show_copyright" value="{{ get_config('show_copyright') == 1 ? 1 : 0 }}">
                                    <label class="form-label"
                                        for="show_copyright">{{ __('show_copyright') }}</label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" id="show_copyright"
                                            class="sandbox_mode" {{ get_config('show_copyright') == 1 ? 'checked' : '' }}>
                                        <label for="show_copyright"></label>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="mb-4">
                                        <label for="title" class="form-label">{{__('copyright_title') }}</label>
                                        <input type="text" class="form-control rounded-2" id="title" name="copyright_title"
                                            value="{{ get_config('copyright_title')}}">
                                        <div class="nk-block-des text-danger">
                                            <p class="title_error error"></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-start align-items-center mt-30">
                                    <button type="submit" class="btn sg-btn-primary">{{ __('update') }}</button>
                                    @include('admin.common.loading-btn',['class' => 'btn sg-btn-primary'])
                                </div>

                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    @include('admin.common.gallery-modal')
@endsection
@push('css_asset')
<link rel="stylesheet" href="{{ static_asset('admin/css/dropzone.min.css') }}">
@endpush
@push('js_asset')
<!--====== media.js ======-->

@endpush
@push('js')

@endpush