<form action="{{ route('admin.episode.store') }}" method="post" enctype="multipart/form-data" class="form-validate form">
    @csrf
    <div class="row">
        <div class="col-md-6 mb-2">
            <label for="tv_series_id" class="form-label"> {{ __('tv_series') }} <span class="text-danger">*</span> </label>
            <select class="form-select form-select-lg mb-3 with_search select2" name="tv_series_id" id="tv_series_id" required>
                <option value=""> {{ __('select_tv_show') }} </option>
                @foreach ($tv_series as $series)
                    <option value="{{ $series->id }}">{{ $series->title }}</option>
                @endforeach
            </select>
            <div class="nk-block-des text-danger">
                <p class="error">{{ $errors->first('tv_series_id') }}</p>
            </div>
        </div>
        <div class="col-md-6 mb-2">
            <label for="season_id" class="form-label"> {{ __('season') }} <span class="text-danger">*</span> </label>
            <select class="form-select form-select-lg mb-3 with_search select2" name="season_id" id="season_id" required>
                <option value=""> {{ __('select_season') }} </option>
                @foreach ($seasons as $season)
                    <option value="{{ $season->id }}">{{ $season->season_name }}</option>
                @endforeach
            </select>
            <div class="nk-block-des text-danger">
                <p class="error">{{ $errors->first('season_id') }}</p>
            </div>
        </div>
    </div>
    <div class="mb-2">
        <label for="episode_name" class="form-label"> {{ __('episode_name(unique)') }} <span
                class="text-danger">*</span>
        </label>
        <input type="text" class="form-control rounded-2" id="episode_name" name="episode_name"
            value="{{ old('episode_name') }}" placeholder="{{ __('enter_episode_name') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('episode_name') }}</p>
        </div>
    </div>
    <div class="mb-2">
        <label for="description" class="form-label"> {{ __('episode_description') }} </label>
        <textarea name="description" id="description" cols="30" rows="4" class="form-control rounded-2"
            placeholder="{{ __('enter_description') }}">{{ old('description') }}</textarea>
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('description') }}</p>
        </div>
    </div>
    <div class="mb-4">
        <label for="runtime" class="form-label"> {{ __('runtime(in_minutes)') }} <span
                class="text-danger">*</span> </label>
        <input type="number" class="form-control rounded-2 timepicker" id="runtime"
            name="runtime" value="{{ old('runtime') }}"
            placeholder="{{ __('minute_duration') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('runtime') }}</p>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 mb-2">
            <label for="order" class="form-label"> {{ __('episode_order') }} <span
                    class="text-danger">*</span></label>
            <input type="number" class="form-control rounded-2" id="order" name="order"
                value="{{ old('order') }}" placeholder="{{ __('enter_episode_order') }}">
            <div class="nk-block-des text-danger">
                <p class="error">{{ $errors->first('order') }}</p>
            </div>
        </div>
        <div class="col-md-6 mb-2">
            <label for="source_type" class="form-label">{{ __('source_type') }} <span
                    class="text-danger">*</span></label>
            <select class="form-select form-select-lg mb-3 with_search select2" name="source_type" id="source_type" required>
                <option value=""> {{ __('select_video_source') }} </option>
                <option value="gdrive"> {{ __('google_drive') }} </option>
                <option value="youtube">{{ __('youtube') }}</option>
                <option value="video">{{ __('local_video_file') }}</option>
                <option value="amazone">{{ __('amazone_S3') }}</option>
                <option value="mp4">{{ __('mp4_from_url') }}</option>
                <option value="mkv">{{ __('mkv_from_url') }}</option>
                <option value="webm">{{ __('webm_from_url') }}</option>
                <option value="m3u8">{{ __('m3u8_from_url') }}</option>
                <option value="embed">{{ __('embed_url') }}</option>
            </select>
            <div class="nk-block-des text-danger">
                <p class="error">{{ $errors->first('source_type') }}</p>
            </div>
        </div>
    </div>


    <div class="mb-2">
        <label for="file_url" class="form-label"> {{ __('file_url') }} <span class="text-danger">*</span> </label>
        <input type="url" class="form-control rounded-2" id="file_url" name="file_url"
            value="{{ old('file_url') }}" placeholder="{{ __('enter_file_url') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('file_url') }}</p>
        </div>
    </div>
    <div class="video_file_input mb-2 d-none">
        <label for="file" class="form-label"> {{ __('video_file') }} <span class="text-danger">*</span> </label>
        <input type="file" class="form-control rounded-2" id="file" name="file"
            placeholder="{{ __('select_video_file') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('file') }}</p>
        </div>
    </div>

    <div class="input_file_div d-flex align-items-center gap-3 mb-2">
        <div class="mb-3 w-75">
            <label for="posterUpload" class="form-label mb-1">{{ __('episode_thumbnail_(500x750)') }}</label>
            <label for="posterUpload" class="file-upload-text">{{ __('select_file_from_device') }}</label>
            <input class="d-none file_picker" type="file" name="poster" id="posterUpload" accept=".jpg,.png">
            <div class="nk-block-des text-danger">
                <p class="error"></p>
            </div>
        </div>
        <div class="selected-files d-flex flex-wrap gap-20">
            <div class="selected-files-item">
                <img class="selected-img" src="{{ getFileLink('thumbnail', [], 'episodes', '500x750') }}"
                    alt="poster">
            </div>
        </div>
    </div>

    <button type="submit" class="btn sg-btn-primary">{{ __('submit') }}</button>
    @include('layouts.loading_button', ['class' => 'btn sg-btn_primary'])
</form>
<script>
    "use strict";
    $('.with_search').select2({
        dropdownParent: $('#ajaxModal') // Ensure dropdown appears inside modal
    });

    $(document).ready(function() {
        // Initially set field visibility based on default or old value
        toggleSourceFields($('#source_type').val());

        // On change of source_type
        $('#source_type').on('change', function() {
            toggleSourceFields($(this).val());
        });

        function toggleSourceFields(sourceType) {
            if (sourceType === 'video') {
                // Show video file input, hide URL input
                $('.video_file_input').removeClass('d-none');
                $('#file_url').closest('.mb-2').addClass('d-none');
            } else {
                // Hide video file input, show URL input
                $('.video_file_input').addClass('d-none');
                $('#file_url').closest('.mb-2').removeClass('d-none');
            }
        }
    });
</script>
