@extends('admin.layouts.master')
@section('title', __('add_new_tv_show'))
@section('content')

    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <h3 class="section-title">{{ __('add_tv_show') }}</h3>
                <form action="{{ route('admin.tv.show.store') }}" method="post" enctype="multipart/form-data"
                    class="crud-form">
                    @csrf
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30">
                                <h3 class="section-title"> {{ __('tv_show_information') }} </h3>
                                <div class="mb-4">
                                    <label for="title" class="form-label"> {{ __('tv_show_title') }} <span
                                            class="text-danger">*</span> </label>
                                    <input type="text" class="form-control rounded-2" id="title" name="title"
                                        value="{{ old('title') }}" placeholder="{{ __('tv_show_title') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('title') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="slug" class="form-label"> {{ __('tv_show_slug') }} <span
                                            class="text-danger">*</span> </label>
                                    <input type="text" class="form-control rounded-2" id="slug" name="slug"
                                        value="{{ old('slug') }}" placeholder="{{ __('tv_show_slug') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('slug') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="tv_show_description" class="form-label d-flex justify-content-between">
                                        <span>{{ __('tv_show_description') }}</span>
                                        <small class="generate-button">
                                            <button data-url="{{ route('ai-helper') }}" data-type="tv_series_description"
                                                data-title="" data-id="tv_show_description"
                                                class="generate-content text-decoration-none text-danger">
                                                <span><i class="las la-robot"></i></span>
                                            </button>
                                        </small>
                                    </label>
                                    <textarea name="description" id="tv_show_description" cols="30" rows="4" class="form-control rounded-2"
                                        placeholder="{{ __('tv_show_description') }}">{{ old('description') }}</textarea>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('description') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="actor" class="form-label">{{ __('actors') }} <span
                                            class="text-danger">*</span></label>
                                    <select class="form-select form-select-lg mb-3 with_search" name="actor[]"
                                        id="actor" multiple>
                                        @foreach ($stars as $actor)
                                            @php
                                                if ($actor->star_type != 'actor') {
                                                    continue;
                                                }
                                            @endphp
                                            <option value="{{ $actor->id }}"
                                                {{ old('actor') && in_array($actor->id, old('actor')) ? 'selected' : '' }}>
                                                {{ $actor->star_name }} </option>
                                        @endforeach
                                    </select>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('actor') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="director" class="form-label">{{ __('director') }} <span
                                            class="text-danger">*</span></label>
                                    <select class="form-select form-select-lg mb-3 with_search" name="director[]"
                                        id="director" multiple>
                                        @foreach ($stars as $director)
                                            @php
                                                if ($director->star_type != 'director') {
                                                    continue;
                                                }
                                            @endphp
                                            <option value="{{ $director->id }}"
                                                {{ old('director') && in_array($director->id, old('director')) ? 'selected' : '' }}>
                                                {{ $director->star_name }} </option>
                                        @endforeach
                                    </select>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('director') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="writer" class="form-label">{{ __('writer') }} <span
                                            class="text-danger">*</span></label>
                                    <select class="form-select form-select-lg mb-3 with_search" name="writer[]"
                                        id="writer" multiple>
                                        @foreach ($stars as $writer)
                                            @php
                                                if ($writer->star_type != 'writer') {
                                                    continue;
                                                }
                                            @endphp
                                            <option value="{{ $writer->id }}"
                                                {{ old('writer') && in_array($writer->id, old('writer')) ? 'selected' : '' }}>
                                                {{ $writer->star_name }} </option>
                                        @endforeach
                                    </select>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('writer') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="imdb_rating" class="form-label"> {{ __('imdb_rating') }} </label>
                                    <input type="number" class="form-control rounded-2" id="imdb_rating" name="imdb_rating"
                                        value="{{ old('imdb_rating') }}" placeholder="{{ __('00') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('imdb_rating') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="date" class="form-label"> {{ __('release_date') }} <span
                                            class="text-danger">*</span></label>
                                    <input type="date" class="form-control rounded-2 datetimePicker" id="date"
                                        name="release_date" value="{{ old('date') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('release_date') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="country" class="form-label">{{ __('country') }} <span
                                            class="text-danger">*</span></label>
                                    <select class="form-select form-select-lg mb-3 with_search" name="country[]"
                                        id="country" multiple>
                                        <option value=""> {{ __('select_tv_show_country') }} </option>
                                        @foreach ($countries as $country)
                                            <option value="{{ $country->id }}"
                                                {{ old('country') && in_array($country->id, old('country')) ? 'selected' : '' }}>
                                                {{ $country->name }} </option>
                                        @endforeach
                                    </select>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('country') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="genre" class="form-label">{{ __('genre') }} <span
                                            class="text-danger">*</span></label>
                                    <select class="form-select form-select-lg mb-3 with_search" name="genre[]"
                                        id="genre" multiple>
                                        <option value=""> {{ __('select_genre') }} </option>
                                        @foreach ($genres as $genre)
                                            <option value="{{ $genre->id }}"
                                                {{ old('genre') && in_array($genre->id, old('genre')) ? 'selected' : '' }}>
                                                {{ $genre->name }} </option>
                                        @endforeach
                                    </select>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('genre') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="language" class="form-label">{{ __('language') }} <span
                                            class="text-danger">*</span></label>
                                    <select class="form-select form-select-lg mb-3 with_search" name="language[]"
                                        id="language" multiple>
                                        <option value=""> {{ __('select_tv_show_language') }} </option>
                                        @foreach ($languages as $language)
                                            <option value="{{ $language->id }}"
                                                {{ old('language') && in_array($language->id, old('language')) ? 'selected' : '' }}>
                                                {{ $language->name }} </option>
                                        @endforeach
                                    </select>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('language') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="video_type" class="form-label">{{ __('video_type') }} <span
                                            class="text-danger">*</span></label>
                                    <select class="form-select form-select-lg mb-3 with_search" name="video_type"
                                        id="video_type">
                                        <option value=""> {{ __('select_video_category') }} </option>
                                        @foreach ($categories as $category)
                                            <option value="{{ $category->id }}"
                                                {{ $category->id == old('video_type') ? 'selected' : '' }}>
                                                {{ $category->video_type }} </option>
                                        @endforeach
                                    </select>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('video_type') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="runtime" class="form-label"> {{ __('runtime(in_minutes)') }} <span
                                            class="text-danger">*</span> </label>
                                    <input type="text" class="form-control rounded-2 timepicker" id="runtime"
                                        name="runtime" value="{{ old('runtime') }}"
                                        placeholder="{{ __('minute_duration') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('runtime') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="video_quality" class="form-label">{{ __('video_quality') }} <span
                                            class="text-danger">*</span></label>
                                    <select class="form-select form-select-lg mb-3 with_search" name="video_quality"
                                        id="video_quality">
                                        <option value=""> {{ __('select_video_quality') }}</option>
                                        @foreach ($video_qualities as $quality)
                                            <option value="{{ $quality->id }}"
                                                {{ $quality->id == old('video_quality') ? 'selected' : '' }}>
                                                {{ $quality->quality }} </option>
                                        @endforeach
                                    </select>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('video_quality') }}</p>
                                    </div>
                                </div>

                                <div
                                    class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                    <input type="hidden" name="status" value="{{ old('status') ?? 1 }}">
                                    <label class="form-label" for="status"> {{ __('status') }} </label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" id="status"
                                            {{ old('status') > 0 ? 'checked' : 'checked' }} class="sandbox_mode">
                                        <label for="status"></label>
                                    </div>
                                </div>
                                <div
                                    class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                    <input type="hidden" name="enable_download"
                                        value="{{ old('enable_download') ?? 0 }}">
                                    <label class="form-label" for="enable_download"> {{ __('enable_download') }} </label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" id="enable_download"
                                            {{ old('enable_download') > 0 ? 'checked' : '' }} class="sandbox_mode">
                                        <label for="enable_download"></label>
                                    </div>
                                </div>
                                <div
                                    class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                    <input type="hidden" name="is_original" value="{{ old('is_original') ?? 0 }}">
                                    <label class="form-label" for="is_original"> {{ __('original') }} </label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" id="is_original"
                                            {{ old('is_original') > 0 ? 'checked' : '' }} class="sandbox_mode">
                                        <label for="is_original"></label>
                                    </div>
                                </div>
                                <div
                                    class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                    <input type="hidden" name="is_featured" value="{{ old('is_featured') ?? 0 }}">
                                    <label class="form-label" for="is_featured"> {{ __('is_featured') }} </label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" id="is_featured"
                                            {{ old('is_featured') > 0 ? 'checked' : '' }} class="sandbox_mode">
                                        <label for="is_featured"></label>
                                    </div>
                                </div>
                                <div
                                    class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                    <input type="hidden" name="is_blockbuster"
                                        value="{{ old('is_blockbuster') ?? 0 }}">
                                    <label class="form-label" for="is_blockbuster"> {{ __('blockbuster') }} </label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" id="is_blockbuster"
                                            {{ old('is_blockbuster') > 0 ? 'checked' : '' }} class="sandbox_mode">
                                        <label for="is_blockbuster"></label>
                                    </div>
                                </div>
                                <div
                                    class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                    <input type="hidden" name="is_recommended"
                                        value="{{ old('is_recommended') ?? 0 }}">
                                    <label class="form-label" for="is_recommended"> {{ __('blockbuster') }} </label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" id="is_recommended"
                                            {{ old('is_recommended') > 0 ? 'checked' : '' }} class="sandbox_mode">
                                        <label for="is_recommended"></label>
                                    </div>
                                </div>
                                <div
                                    class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                    <input type="hidden" name="is_real_life_story"
                                        value="{{ old('is_real_life_story') ?? 0 }}">
                                    <label class="form-label" for="is_real_life_story"> {{ __('real_life_story') }}
                                    </label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" id="is_real_life_story"
                                            {{ old('is_real_life_story') > 0 ? 'checked' : '' }} class="sandbox_mode">
                                        <label for="is_real_life_story"></label>
                                    </div>
                                </div>
                                <div
                                    class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                    <input type="hidden" name="is_popular" value="{{ old('is_popular') }}">
                                    <label class="form-label" for="is_popular"> {{ __('is_popular') }}
                                    </label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" id="is_popular"
                                            {{ old('is_popular') > 0 ? 'checked' : '' }} class="sandbox_mode">
                                        <label for="is_popular"></label>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="trailer_youtube_source" class="form-label">
                                        {{ __('trailer_url(mp4_url_only)') }} </label>
                                    <input type="text" class="form-control rounded-2 timepicker"
                                        id="trailer_youtube_source" name="trailer_youtube_source"
                                        value="{{ old('trailer_youtube_source') }}"
                                        placeholder="{{ __('mp4_url_only') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('trailer_youtube_source') }}</p>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30">
                                <h3 class="section-title"> {{ __('poster_and_thumbnail') }} </h3>
                                <div class="input_file_div d-flex align-items-center gap-3">
                                    <div class="mb-3 w-75">
                                        <label for="thumbUpload"
                                            class="form-label mb-1">{{ __('tv_show_thumbnail_(500x750)') }}</label>
                                        <label for="thumbUpload"
                                            class="file-upload-text">{{ __('select_file_from_device') }}</label>
                                        <input class="d-none file_picker" type="file" name="thumbnail"
                                            id="thumbUpload" accept=".jpg,.png">
                                        <div class="nk-block-des text-danger">
                                            <p class="error"></p>
                                        </div>
                                    </div>
                                    <div class="selected-files d-flex flex-wrap gap-20">
                                        <div class="selected-files-item">
                                            <img class="selected-img"
                                                src="{{ getFileLink('thumbnail', [], 'tv_series', '500x750') }}"
                                                alt="thumbnail">
                                        </div>
                                    </div>
                                </div>
                                <div class="input_file_div d-flex align-items-center gap-3">
                                    <div class="mb-3 w-75">
                                        <label for="posterUpload"
                                            class="form-label mb-1">{{ __('tv_show_poster_(1920x1080)') }}</label>
                                        <label for="posterUpload"
                                            class="file-upload-text">{{ __('select_file_from_device') }}</label>
                                        <input class="d-none file_picker" type="file" name="poster"
                                            id="posterUpload" accept=".jpg,.png">
                                        <div class="nk-block-des text-danger">
                                            <p class="error"></p>
                                        </div>
                                    </div>
                                    <div class="selected-files d-flex flex-wrap gap-20">
                                        <div class="selected-files-item">
                                            <img class="selected-img"
                                                src="{{ getFileLink('poster', [], 'tv_series', '1920x1080') }}"
                                                alt="poster">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="default-tab-list default-tab-list-v2 mt-3 bg-white redious-border p-20 p-sm-30">
                                <h3 class="section-title mb-3">{{ __('monetization_and_revenue') }}</h3>

                                {{-- Free Access --}}
                                <div class="d-flex gap-12 align-items-center justify-content-between mb-4">
                                    <input type="hidden" name="is_free" value="0">
                                    <label class="form-label mb-0"
                                        for="is_free">{{ __('make_this_movie_free_for_all_users') }}</label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" name="is_free" id="is_free"
                                            {{ old('is_free') ? 'checked' : '' }} class="access-control">
                                        <label for="is_free"></label>
                                    </div>
                                </div>

                                {{-- Rental Access --}}
                                <div class="d-flex gap-12 align-items-center justify-content-between mb-4">
                                    <input type="hidden" name="is_rental" value="0">
                                    <label class="form-label mb-0"
                                        for="is_rental">{{ __('allow_users_to_rent_this_movie') }}</label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" name="is_rental" id="is_rental"
                                            {{ old('is_rental') ? 'checked' : '' }} class="access-control">
                                        <label for="is_rental"></label>
                                    </div>
                                </div>

                                {{-- Rental Fields --}}
                                <div id="rental-fields"
                                    class="{{ old('is_rental') ? '' : 'd-none' }} d-flex align-items-center gap-3 flex-wrap">
                                    <div class="mb-3">
                                        <label for="rental_price" class="form-label">{{ __('rental_price') }}</label>
                                        <input type="number" step="0.01" class="form-control" name="rental_price"
                                            id="rental_price" placeholder="{{ __('rental_price') }}"
                                            value="{{ old('rental_price') }}">
                                    </div>
                                    <div class="mb-3">
                                        <label for="rental_duration"
                                            class="form-label">{{ __('rental_duration') }}</label>
                                        <input type="number" class="form-control" name="rental_duration"
                                            id="rental_duration" placeholder="{{ __('rental_duration') }}"
                                            value="{{ old('rental_duration') }}">
                                    </div>
                                    <div class="mb-3">
                                        <label for="rental_price" class="form-label">{{ __('rental_type') }}</label>
                                        <select class="form-select form-select-lg mb-3 with_search" name="rental_type"
                                            id="rental_type">
                                            <option value=""> {{ __('select_rental_type') }}</option>
                                            <option value="hours">{{ __('hours') }}</option>
                                            <option value="day">{{ __('day') }}</option>
                                            <option value="month">{{ __('month') }}</option>
                                            <option value="year">{{ __('year') }}</option>
                                        </select>

                                        <div class="nk-block-des text-danger">
                                            <p class="error">{{ $errors->first('rental_type') }}</p>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30 mt-3">
                                <h3 class="section-title"> {{ __('seo_and_marketing') }} </h3>
                                <div class="mb-4">
                                    <label for="seo_title" class="form-label"> {{ __('seo_title') }} </label>
                                    <input type="text" class="form-control rounded-2" id="seo_title" name="seo_title"
                                        value="{{ old('seo_title') }}" placeholder="{{ __('seo_title') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('seo_title') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="meta_description" class="form-label d-flex justify-content-between">
                                        <span>{{ __('meta_description') }}</span>
                                        <small class="generate-button">
                                            <button data-url="{{ route('ai-helper') }}"
                                                data-type="tv_series_meta_description" data-title=""
                                                data-id="meta_description"
                                                class="generate-content text-decoration-none text-danger">
                                                <span><i class="las la-robot"></i></span>
                                            </button>
                                        </small>
                                    </label>
                                    <textarea name="meta_description" id="meta_description" cols="30" rows="3"
                                        class="form-control rounded-2" placeholder="{{ __('meta_description') }}">{{ old('meta_description') }}</textarea>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('meta_description') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="focus_keyword" class="form-label"> {{ __('focus_keyword') }} </label>
                                    <input type="text" class="form-control rounded-2" id="focus_keyword"
                                        name="focus_keyword" value="{{ old('focus_keyword') }}"
                                        placeholder="{{ __('focus_focus_keyword') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('focus_keyword') }}</p>
                                    </div>
                                    <p class="text-muted">({{ __('use_comma_to_separate_focus_keyword') }})</p>
                                </div>
                                <div class="mb-4">
                                    <label for="tags" class="form-label"> {{ __('tags') }} </label>
                                    <input type="text" class="form-control rounded-2" id="tags" name="tags"
                                        value="{{ old('tags') }}" placeholder="{{ __('tags') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('tags') }}</p>
                                    </div>
                                    <p class="text-muted">({{ __('use_comma_to_separate_tags') }})</p>
                                </div>

                                <div
                                    class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                    <input type="hidden" name="email_notify" value="0">
                                    <label class="form-label" for="email_notify">
                                        {{ __('send_email_newslatter_to_subscriber') }} </label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" id="email_notify" class="sandbox_mode">
                                        <label for="email_notify"></label>
                                    </div>
                                </div>

                                <button type="submit" class="btn sg-btn-primary">{{ __('submit') }}</button>
                            </div>
                        </div>
                </form>
            </div>
        </div>
    </div>

@endsection
@push('js')
    <script>
        "use strict";
        $('#description').summernote({
            height: 210,
        });

        flatpickr(".datetimePicker", {
            defaultDate: new Date(),
            enableTime: true,
            enableSeconds: true,
            dateFormat: "Y-m-d",
            time_24hr: true,
        });

        $("#title").keyup(function() {
            var Text = $(this).val();
            Text = Text.toLowerCase();
            Text = Text.replace(/[^\w ]+/g, '');
            Text = Text.replace(/ +/g, '-');
            $("#slug").val(Text);
            
        });

        function toggleAccessFields() {
            const isFree = document.getElementById('is_free').checked;
            const isRental = document.getElementById('is_rental').checked;

            // Only one can be selected
            if (isFree) {
                document.getElementById('is_rental').checked = false;
            } else if (isRental) {
                document.getElementById('is_free').checked = false;
                document.getElementById('rental-fields').classList.remove('d-none');
            }

            // Show rental fields if rental is selected
            if (!isFree) {
                document.getElementById('rental-fields').classList.toggle('d-none', !isRental);
            }
        }

        document.querySelectorAll('.access-control').forEach(cb => {
            cb.addEventListener('change', toggleAccessFields);
        });

        // Initialize on page load
        document.addEventListener('DOMContentLoaded', toggleAccessFields);
    </script>
@endpush
