<form action="{{ route('admin.star.store') }}" method="post" enctype="multipart/form-data" class="form-validate form">
    @csrf
    <div class="row">
        <div class="col-md-12 mb-2">
            <label for="star_name" class="form-label"> {{ __('star_name') }} <span class="text-danger">*</span> </label>
            <input type="text" class="form-control rounded-2" id="star_name" name="star_name"
                value="{{ old('star_name') }}" placeholder="{{ __('enter_star_name') }}">
            <div class="nk-block-des text-danger">
                <p class="error">{{ $errors->first('star_name') }}</p>
            </div>
        </div>
        <div class="col-md-6 mb-4 ">
            <label for="star_type" class="form-label">{{ __('star_type') }} <span class="text-danger">*</span></label>
            <select class="select2 with_search" name="star_type" id="star_type">
                <option value=""> {{ __('select_star_type') }} </option>
                <option value="actor"> {{ __('actor') }} </option>
                <option value="director"> {{ __('director') }} </option>
                <option value="writer"> {{ __('writer') }} </option>
            </select>
            <div class="nk-block-des text-danger">
                <p class="error">{{ $errors->first('language') }}</p>
            </div>
        </div>


        <div class="col-md-6 mb-4">
            <label for="country_id" class="form-label"> {{ __('country_id') }} </label>
            <select class="form-control rounded-2 select2 with_search" id="country_id" name="country_id">
                <option value="">{{ __('select_country') }}</option>
                @foreach (get_all_countries() as $country)
                    <option value="{{ $country->id }}" {{ old('country_id') == $country->id ? 'selected' : '' }}>
                        {{ $country->name }}
                    </option>
                @endforeach
            </select>
            <div class="nk-block-des text-danger">
                <p class="error">{{ $errors->first('country_id') }}</p>
            </div>
        </div>
        <div class="col-md-6 mb-4">
            <label for="star_dob" class="form-label"> {{ __('star_dob') }} </label>
            <input type="date" class="form-control rounded-2 datetimePicker" id="star_dob" name="star_dob"
                value="{{ old('star_dob') }}">
            <div class="nk-block-des text-danger">
                <p class="error">{{ $errors->first('star_dob') }}</p>
            </div>
        </div>

        <div class="col-md-6 mb-4">
            <label for="ranking" class="form-label"> {{ __('ranking') }} </label>
            <input type="text" class="form-control rounded-2" id="ranking" name="ranking"
                value="{{ old('ranking') }}" placeholder="{{ __('enter_ranking') }}">
            <div class="nk-block-des text-danger">
                <p class="error">{{ $errors->first('ranking') }}</p>
            </div>
        </div>

        <div class="col-md-6 mb-4">
            <label for="gender" class="form-label"> {{ __('gender') }} </label>
            <input type="text" class="form-control rounded-2" id="gender" name="gender"
                value="{{ old('gender') }}" placeholder="{{ __('enter_gender') }}">
            <div class="nk-block-des text-danger">
                <p class="error">{{ $errors->first('gender') }}</p>
            </div>
        </div>
        <div class="col-md-6 mb-4">
            <label for="industries" class="form-label"> {{ __('industries') }} </label>
            <select class="form-control rounded-2 select2 with_search" id="industries" name="industries[]" multiple>
                <option value="">{{ __('select_industries') }}</option>
                @foreach (movieIndustries() as $industry)
                    <option value="{{ $industry->id }}"
                        {{ collect(old('industries'))->contains($industry->id) ? 'selected' : '' }}>
                        {{ $industry->name }}
                    </option>
                @endforeach
            </select>
            <div class="nk-block-des text-danger">
                <p class="error">{{ $errors->first('industries') }}</p>
            </div>
        </div>

        <div class="col-md-6 mb-4">
            <label for="facebook" class="form-label"> {{ __('facebook') }} </label>
            <input type="url" class="form-control rounded-2" id="facebook" name="facebook"
                value="{{ old('facebook') }}" placeholder="{{ __('enter_facebook_link') }}">
            <div class="nk-block-des text-danger">
                <p class="error">{{ $errors->first('facebook') }}</p>
            </div>
        </div>
        <div class="col-md-6 mb-4">
            <label for="twitter" class="form-label"> {{ __('twitter(x)') }} </label>
            <input type="url" class="form-control rounded-2" id="twitter" name="twitter"
                value="{{ old('twitter') }}" placeholder="{{ __('enter_twitter(x)_link') }}">
            <div class="nk-block-des text-danger">
                <p class="error">{{ $errors->first('twitter') }}</p>
            </div>
        </div>
        <div class="col-md-6 mb-4">
            <label for="instagram" class="form-label"> {{ __('instagram') }} </label>
            <input type="url" class="form-control rounded-2" id="instagram" name="instagram"
                value="{{ old('instagram') }}" placeholder="{{ __('enter_instagram_link') }}">
            <div class="nk-block-des text-danger">
                <p class="error">{{ $errors->first('instagram') }}</p>
            </div>
        </div>

        <div class="col-md-6 mb-4 ">

            <div class="input_file_div d-flex align-items-center gap-3">
                <div class="mb-3 w-100">
                    <label for="star_imageUpload" class="form-label mb-1">{{ __('Star Image (100x100)') }}</label>
                    <label for="star_imageUpload" class="file-upload-text"></label>
                    <input class="d-none file_picker" type="file" name="star_image" id="star_imageUpload"
                        accept=".jpg,.png">
                    <div class="nk-block-des text-danger">
                        <p class="error"></p>
                    </div>
                </div>

            </div>
        </div>
        <div class="col-md-12 mb-4 ">
            <label for="star_desc" class="form-label"> {{ __('star_bio') }} </label>
            <textarea name="star_desc" id="star_desc" cols="30" rows="4" class="form-control rounded-2"
                placeholder="{{ __('star_description') }}">{{ old('star_desc') }}</textarea>
            <div class="nk-block-des text-danger">
                <p class="error">{{ $errors->first('star_desc') }}</p>
            </div>
        </div>
    </div>
    <button type="submit" class="btn sg-btn-primary">{{ __('submit') }}</button>
    @include('layouts.loading_button', ['class' => 'btn sg-btn-primary'])
</form>
<script>
    "use strict";
    $('.with_search').select2({
        dropdownParent: $('#ajaxModal') // Ensure dropdown appears inside modal
    });

    // Start date-time picker
    flatpickr(".datetimePicker", {
        defaultDate: new Date(),
        enableTime: true,
        enableSeconds: true,
        dateFormat: "Y-m-d H:i:S",
        time_24hr: true,
        minDate: "today"
    });
</script>
