@extends('admin.layouts.master')
@section('title', __('system_settings'))
@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <h3 class="section-title">{{ __('system_settings') }}</h3>
                <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30">
                    <form action="{{ route('admin.setting.update') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="col-md-6 col-lg-4 mb-2">
                                <label for="system_name" class="form-label"> {{ __('system_name') }} </label>
                                <input type="text" class="form-control rounded-2" id="system_name" name="system_name"
                                    value="{{ get_config('system_name') }}" placeholder="{{ __('system_name') }}">
                                <div class="nk-block-des text-danger">
                                    <p class="error">{{ $errors->first('system_name') }}</p>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-4 mb-2">
                                <label for="google_api_key" class="form-label"> {{ __('google_api_key') }} </label>
                                <input type="text" class="form-control rounded-2" id="google_api_key" name="google_api_key"
                                    value="{{ get_config('google_api_key') }}" placeholder="{{ __('google_api_key') }}">
                                <div class="nk-block-des text-danger">
                                    <p class="error">{{ $errors->first('google_api_key') }}</p>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-4 mb-2">
                                <label for="default_time_zone" class="form-label">{{ __('default_time_zone') }} </label>
                                <select class="form-select form-select-lg mb-3 with_search" name="default_time_zone"
                                    id="default_time_zone">
                                    @foreach ($timezones as $timezone)
                                        <option value="{{ $timezone->id }}" {{ $timezone->id == get_config('default_time_zone') ? 'selected' : '' }}>
                                            ({{__('UTC')}}
                                            {{ $timezone->gmt_offset > 0 ? '+' . $timezone->gmt_offset : $timezone->gmt_offset }})
                                            {{ $timezone->timezone }}
                                        </option>
                                    @endforeach
                                </select>
                                <div class="nk-block-des text-danger">
                                    <p class="error">{{ $errors->first('default_time_zone') }}</p>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-4 mb-2">
                                <label for="default_language" class="form-label">{{ __('default_language') }} </label>
                                <select class="form-select form-select-lg mb-3 with_search" name="default_language"
                                    id="default_language">
                                    @foreach ($system_languages as $language)
                                        <option value="{{ $language->id }}" {{ $language->id == get_config('default_language') ? 'selected' : '' }}>
                                            {{ $language->name . ' (' . $language->locale . ')' }}
                                        </option>
                                    @endforeach
                                </select>
                                <div class="nk-block-des text-danger">
                                    <p class="error">{{ $errors->first('default_language') }}</p>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-4 mb-2">
                                <label for="default_currency" class="form-label">{{ __('default_currency') }} </label>
                                <select class="form-select form-select-lg mb-3 with_search" name="default_currency"
                                    id="default_currency">
                                    @foreach ($currencies as $currency)
                                        <option value="{{ $currency->id }}" {{ $currency->id == get_config('default_currency') ? 'selected' : '' }}>
                                            {{ $currency->country . ' - (' . $currency->currency . ')' }}
                                        </option>
                                    @endforeach
                                </select>
                                <div class="nk-block-des text-danger">
                                    <p class="error">{{ $errors->first('default_currency') }}</p>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-4 mb-2">
                                <label for="currency_symbol" class="form-label">{{ __('currency_symbol') }} </label>
                                <select class="form-select form-select-lg mb-3 with_search" name="currency_symbol"
                                    id="currency_symbol">
                                    @foreach ($currencies as $currency)
                                        <option value="{{ $currency->id }}" {{ $currency->id == get_config('currency_symbol') ? 'selected' : '' }}>
                                            {{ $currency->country . ' - (' . $currency->symbol . ')' }}
                                        </option>
                                    @endforeach
                                </select>
                                <div class="nk-block-des text-danger">
                                    <p class="error">{{ $errors->first('currency_symbol') }}</p>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-4 mb-2">
                                <label for="currency_symbol_position"
                                    class="form-label">{{ __('currency_symbol_position') }}</label>

                                <select class="form-select form-select-lg mb-3 with_search" name="currency_symbol_position"
                                    id="currency_symbol_position">
                                    <option value="right" {{ get_config('currency_symbol_position') == 'right' ? 'selected' : '' }}> {{ __('amount_before_symbol(e.g., 100$)') }}
                                    </option>
                                    <option value="right_with_space" {{ get_config('currency_symbol_position') == 'right_with_space' ? 'selected' : '' }}>
                                        {{ __('amount_before_symbol_with_space(e.g., 100 $)') }}
                                    </option>
                                    <option value="left" {{ get_config('currency_symbol_position') == 'left' ? 'selected' : '' }}> {{ __('symbol_before_amount(e.g., $100)') }}
                                    </option>
                                    <option value="left_with_space" {{ get_config('currency_symbol_position') == 'left_with_space' ? 'selected' : '' }}>
                                        {{ __('symbol_before_amount_with_space(e.g., $ 100)') }}
                                    </option>
                                </select>

                                <div class="nk-block-des text-danger">
                                    <p class="error">{{ $errors->first('currency_symbol_position') }}</p>
                                </div>
                            </div>

                            <div class="col-md-6 col-lg-4 mb-2">
                                <label for="exchange_rate" class="form-label">{{ __('exchange_rate') }} </label>
                                <input type="number" class="form-control rounded-2" id="exchange_rate" name="exchange_rate"
                                    value="{{ get_config('exchange_rate') }}" placeholder="{{ __('exchange_rate') }}">
                                <div class="nk-block-des text-danger">
                                    <p class="error">{{ $errors->first('exchange_rate') }}</p>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-4 mb-2">
                                <label for="system_email" class="form-label">{{ __('system_email') }} </label>
                                <input type="text" class="form-control rounded-2" id="system_email" name="system_email"
                                    value="{{ get_config('system_email') }}" placeholder="{{ __('system_email') }}">
                                <div class="nk-block-des text-danger">
                                    <p class="error">{{ $errors->first('system_email') }}</p>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-4 mb-2">
                                <label for="business_address" class="form-label">{{ __('business_address') }} </label>
                                <input type="text" class="form-control rounded-2" id="business_address"
                                    name="business_address" value="{{ get_config('business_address') }}"
                                    placeholder="{{ __('business_address') }}">
                                <div class="nk-block-des text-danger">
                                    <p class="error">{{ $errors->first('business_address') }}</p>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-4 mb-2">
                                <label for="business_phone" class="form-label">{{ __('business_phone') }} </label>
                                <input type="text" class="form-control rounded-2" id="business_phone" name="business_phone"
                                    value="{{ get_config('business_phone') }}" placeholder="{{ __('business_phone') }}">
                                <div class="nk-block-des text-danger">
                                    <p class="error">{{ $errors->first('business_phone') }}</p>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-4 mb-2">
                                <label for="contact_email" class="form-label">{{ __('contact_email') }} </label>
                                <input type="text" class="form-control rounded-2" id="contact_email" name="contact_email"
                                    value="{{ get_config('contact_email') }}" placeholder="{{ __('contact_email') }}">
                                <div class="nk-block-des text-danger">
                                    <p class="error">{{ $errors->first('contact_email') }}</p>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-6 mb-2">
                                <label for="openai_secret_key" class="form-label">{{ __('openai_secret_key') }} </label>
                                <input type="text" class="form-control rounded-2" id="openai_secret_key" name="openai_secret_key"
                                    value="{{ get_config('openai_secret_key') }}" placeholder="{{ __('openai_secret_key') }}">
                                <div class="nk-block-des text-danger">
                                    <p class="error">{{ $errors->first('openai_secret_key') }}</p>
                                </div>
                            </div>
                            

                        </div>

                        <button type="submit" class="btn sg-btn-primary">{{ __('submit') }}</button>
                        @include('layouts.loading_button', ['class' => 'btn sg-btn-primary'])
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection