@extends('admin.layouts.master')
@section('title', __('sms_gateway_settings'))

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <h3 class="section-title">{{ __('sms_gateways') }}</h3>
                <div class="bg-white redious-border p-20 p-sm-30 pt-sm-30">
                    <div class="row align-items-center g-20">

                        <!-- Twilio Box -->
                        <div class="col-xxl-4 col-xl-6 col-lg-6 col-md-12">
                            <div class="payment-box">
                                <div class="payment-icon">
                                    <img src="{{ asset('images/gateways/twilio.svg') }}" alt="Twilio">
                                    <span class="title">{{ __('twilio') }}</span>
                                </div>
                                <div class="payment-settings">
                                    <div class="payment-settings-btn">
                                        <a href="javascript:void(0)" class="btn btn-md sg-btn-outline-primary" data-bs-toggle="modal"
                                            data-bs-target="#twilio"><i class="las la-cog"></i>
                                            <span>{{ __('setting') }}</span></a>
                                    </div>
                                    <div class="setting-check">
                                        <input type="checkbox" id="is_twilio_activated"
                                            value="setting-status-change/is_twilio_activated" class="status-change" {{ get_config('is_twilio_activated') ? 'checked' : '' }}>
                                        <label for="is_twilio_activated"></label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Twilio Modal -->
                        <div class="modal fade" id="twilio" tabindex="-1" aria-labelledby="smsGatewayLabel"
                            aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered">
                                <div class="modal-content p-4">
                                    <h6 class="sub-title">{{ __('twilio_configuration') }}</h6>
                                    <button type="button" class="btn-close modal-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                    <form action="{{ route('admin.setting.update') }}" method="POST" class="form">
                                        @csrf
                                        <div class="row gx-20">

                                            <!-- Account SID -->
                                            <div class="col-12">
                                                <div class="mb-4">
                                                    <label class="form-label">{{ __('twilio_account_sid') }}</label>
                                                    <input type="text" class="form-control rounded-2"
                                                        name="twilio_client_id" placeholder="{{ __('enter_account_sid') }}"
                                                        value="{{ old('twilio_client_id') }}">
                                                    <p class="twilio_client_id_error error text-danger"></p>
                                                </div>
                                            </div>

                                            <!-- Auth Token -->
                                            <div class="col-12">
                                                <div class="mb-4">
                                                    <label class="form-label">{{ __('twilio_auth_token') }}</label>
                                                    <input type="text" class="form-control rounded-2"
                                                        name="twilio_client_secret"
                                                        placeholder="{{ __('enter_auth_token') }}"
                                                        value="{{ old('twilio_client_secret') }}">
                                                    <p class="twilio_client_secret_error error text-danger"></p>
                                                </div>
                                            </div>

                                            <!-- Twilio Phone Number -->
                                            <div class="col-12">
                                                <div class="mb-4">
                                                    <label class="form-label">{{ __('twilio_phone_number') }}</label>
                                                    <input type="text" class="form-control rounded-2"
                                                        name="twilio_phone_number"
                                                        placeholder="{{ __('enter_twilio_phone_number') }}"
                                                        value="{{ old('twilio_phone_number') }}">
                                                    <p class="twilio_phone_number_error error text-danger"></p>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="d-flex justify-content-end align-items-center mt-30">
                                            <button type="submit" class="btn sg-btn-primary">{{ __('save') }}</button>
                                            <button class="btn sg-btn-primary loading_button d-none" type="button" disabled>
                                                <span class="spinner-border spinner-border-sm" role="status"
                                                    aria-hidden="true"></span>
                                                {{ __('loading') }}
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <!-- End Twilio Modal -->

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection