@extends('admin.layouts.master')
@section('title', __('mobile_ads_settings'))
@section('content')

    <div class="container-fluid">
        <div class="row justify-content-md-center">
            <div class="col col-lg-8 col-md-9">
                <h3 class="section-title">{{ __('mobile_ads_settings') }}</h3>
                <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30">
                    <form action="{{ route('admin.setting.update') }}" method="post" enctype="multipart/form-data">
                        @csrf

                        <h4>{{__('banner_ads')}}</h4>
                        <hr>
                        <div class="mb-2">
                            <label for="banner_ads" class="form-label">{{ __('banner_ads') }} </label>
                            <select class="form-select form-select-lg mb-3 with_search select2" name="banner_ads"
                                id="banner_ads">
                                 <option value="disable" {{get_config('banner_ads') == 'disable' ? 'selected':''}}>{{__('disable')}}</option>
                                <option value="admob" {{get_config('banner_ads') == 'admob' ? 'selected':''}}>{{__('admob')}}</option>
                            </select>
                            <div class="nk-block-des text-danger">
                                <p class="error">{{ $errors->first('banner_ads') }}</p>
                            </div>
                        </div>
                        <div class="mb-2">
                            <label for="banner_ads_id" class="form-label"> {{ __('banner_ads_id') }} </label>
                            <input type="text" class="form-control rounded-2" id="banner_ads_id" name="banner_ads_id"
                                value="{{ get_config('banner_ads_id') }}" placeholder="{{ __('banner_ads_id') }}">
                            <div class="nk-block-des text-danger">
                                <p class="error">{{ $errors->first('banner_ads_id') }}</p>
                            </div>
                        </div>


                        <h4 class="mt-3">{{__('interstitial_ads')}}</h4>
                        <hr>
                        <div class="mb-2">
                            <label for="interstitial_ads" class="form-label">{{ __('interstitial_ads') }} </label>
                            <select class="form-select form-select-lg mb-3 with_search select2" name="interstitial_ads"
                                id="interstitial_ads">
                                <option value="disable" {{get_config('interstitial_ads') == 'disable' ? 'selected':''}}>{{__('disable')}}</option>
                                <option value="admob" {{get_config('interstitial_ads') == 'admob' ? 'selected':''}}>{{__('admob')}}</option>
                            </select>
                            <div class="nk-block-des text-danger">
                                <p class="error">{{ $errors->first('banner_ads') }}</p>
                            </div>
                        </div>
                        <div class="mb-2">
                            <label for="interstitial_ads_id" class="form-label"> {{ __('interstitial_ads_id') }} </label>
                            <input type="text" class="form-control rounded-2" id="interstitial_ads_id" name="interstitial_ads_id"
                                value="{{ get_config('interstitial_ads_id') }}" placeholder="{{ __('interstitial_ads_id') }}">
                            <div class="nk-block-des text-danger">
                                <p class="error">{{ $errors->first('interstitial_ads_id') }}</p>
                            </div>
                        </div>


                        <h4 class="mt-3">{{__('admob')}}</h4>
                        <hr>
                        <div class="mb-2">
                            <label for="admob_publisher_id" class="form-label"> {{ __('admob_publisher_id') }} </label>
                            <input type="text" class="form-control rounded-2" id="admob_publisher_id" name="admob_publisher_id"
                                value="{{ get_config('admob_publisher_id') }}" placeholder="{{ __('admob_publisher_id') }}">
                            <div class="nk-block-des text-danger">
                                <p class="error">{{ $errors->first('admob_publisher_id') }}</p>
                            </div>
                        </div>

                        <button type="submit" class="btn sg-btn-primary mt-2">{{ __('submit') }}</button>
                        @include('layouts.loading_button', ['class' => 'btn sg-btn-primary'])
                    </form>
                </div>
            </div>
        </div>
    </div>


@endsection
