<form action="{{ route('admin.movie.file.update', ['id' => $file->id]) }}" method="POST" enctype="multipart/form-data"
    class="form">
    @csrf

    {{-- Label --}}
    <div class="mb-3">
        <label for="label" class="form-label">{{ __('video_label') }} <span class="text-danger">*</span></label>
        <input type="text" name="label" id="label" class="form-control" value="{{ old('label', $file->label) }}"
            required>
        @error('label')
            <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>

    {{-- Order --}}
    <div class="mb-3">
        <label for="order" class="form-label">{{ __('video_order') }} <span class="text-danger">*</span></label>
        <input type="number" name="order" id="order" class="form-control"
            value="{{ old('order', $file->order) }}" required>
        @error('order')
            <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>

    {{-- Source Selector --}}
    <div class="mb-3">
        <label for="source" class="form-label">{{ __('video_source') }} <span class="text-danger">*</span></label>

        <select class="form-select form-select-lg mb-3 with_search select2" name="source" id="source">
            <option value=""> {{ __('select_video_source') }} </option>
            <option value="local" {{ $file->source_type == 'local' ? 'selected' : '' }}> {{ __('local_video') }}
            </option>
            <option value="gdrive" {{ $file->source_type == 'gdrive' ? 'selected' : '' }}> {{ __('google_drive') }}
            </option>
            <option value="youtube" {{ $file->source_type == 'youtube' ? 'selected' : '' }}>{{ __('youtube') }}
            </option>
            <option value="amazone" {{ $file->source_type == 'amazone' ? 'selected' : '' }}>{{ __('amazone_S3') }}
            </option>
            <option value="mp4" {{ $file->source_type == 'mp4' ? 'selected' : '' }}>{{ __('mp4_from_url') }}
            </option>
            <option value="mkv" {{ $file->source_type == 'mkv' ? 'selected' : '' }}>{{ __('mkv_from_url') }}
            </option>
            <option value="webm" {{ $file->source_type == 'webm' ? 'selected' : '' }}>{{ __('webm_from_url') }}
            </option>
            <option value="m3u8" {{ $file->source_type == 'm3u8' ? 'selected' : '' }}>{{ __('m3u8_from_url') }}
            </option>
            <option value="embed" {{ $file->source_type == 'embed' ? 'selected' : '' }}>{{ __('embed_url') }}</option>
        </select>
        @error('source')
            <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>

    {{-- Local File Upload --}}
    <div class="mb-3 {{ $file->source_type === 'local' ? '' : 'd-none' }}" id="file_input_group">
        <label for="video_file" class="form-label">{{ __('upload_video_file') }} <span
                class="text-danger">*</span></label>
        <input type="file" class="form-control" name="video_file" id="video_file" accept="video/*">
        @error('video_file')
            <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>

    {{-- Remote File URL --}}
    <div class="mb-3 {{ $file->source_type !== 'local' ? '' : 'd-none' }}" id="url_input_group">
        <label for="file_url" class="form-label">{{ __('video_url') }} <span class="text-danger">*</span></label>
        <input type="url" class="form-control" id="file_url" name="file_url"
            value="{{ $file->source_type !== 'local' ? $file->file_url : '' }}"
            placeholder="{{ __('video_file_url') }}">
        @error('file_url')
            <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>

    {{-- Submit --}}
    <button type="submit" class="btn btn-primary">{{ __('submit') }}</button>
</form>

{{-- JS: Toggle fields based on source --}}
<script>
    "use strict";
    $(document).ready(function() {
        // Initialize select2
        $('.with_search').select2({
            dropdownParent: $('#ajaxModal') // Optional: only needed if used in a modal
        });

        // Listen to change event on Select2 dropdown
        $('#source').on('change', function() {
            toggleSourceFields();
        });

        // Initial toggle on page load
        toggleSourceFields();

        // Main toggle logic
        function toggleSourceFields() {
            const source = $('#source').val();
            const fileUrlInput = $('#file_url');
            const videoFileInput = $('#video_file');
            const urlGroup = $('#url_input_group');
            const fileGroup = $('#file_input_group');

            if (source === 'local') {
                fileGroup.removeClass('d-none');
                urlGroup.addClass('d-none');
                fileUrlInput.prop('required', false);
            } else {
                urlGroup.removeClass('d-none');
                fileUrlInput.prop('required', true);

                fileGroup.addClass('d-none');
                videoFileInput.prop('required', false);
            }
        }
    });
</script>
