@extends('admin.layouts.master')
@section('title', __('edit_new_movie'))
@section('content')

    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <h3 class="section-title">{{ __('edit_movie') }}</h3>
                <form action="{{ route('admin.movie.update', ['id' => $movie->id]) }}" method="post"
                    enctype="multipart/form-data" class="crud-form">
                    @csrf
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30">
                                <h3 class="section-title"> {{ __('movie_information') }} </h3>
                                <div class="mb-4">
                                    <label for="title" class="form-label"> {{ __('movie_title') }} <span
                                            class="text-danger">*</span> </label>
                                    <input type="text" class="form-control rounded-2" id="title" name="title"
                                        value="{{ $movie->title }}" placeholder="{{ __('movie_title') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('title') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="slug" class="form-label"> {{ __('movie_slug') }} <span
                                            class="text-danger">*</span> </label>
                                    <input type="text" class="form-control rounded-2" id="slug" name="slug"
                                        value="{{ $movie->slug }}" placeholder="{{ __('movie_slug') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('slug') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="movie-add-description" class="form-label d-flex justify-content-between">
                                        <span>{{ __('movie_description') }}</span>
                                        <small class="generate-button">
                                            <button data-url="{{ route('ai-helper') }}" data-type="movie_description" data-title="" data-id="movie-add-description" class="generate-content text-decoration-none text-danger">
                                                <span><i class="las la-robot"></i></span>
                                            </button>
                                        </small>
                                        </label>
                                    <textarea name="description" id="movie-add-description" cols="30" rows="4" class="form-control rounded-2"
                                        placeholder="{{ __('movie_description') }}">{{ $movie->description }}</textarea>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('description') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="actor" class="form-label">{{ __('actors') }} <span
                                            class="text-danger">*</span></label>
                                    <select class="form-select form-select-lg mb-3 with_search" name="actor[]"
                                        id="actor" multiple>
                                        @foreach ($stars as $actor)
                                            @php
                                                if ($actor->star_type != 'actor') {
                                                    continue;
                                                }
                                            @endphp
                                            <option value="{{ $actor->id }}"
                                                {{ isset($movie->stars) && in_array($actor->id, json_decode($movie->stars)) ? 'selected' : '' }}>
                                                {{ $actor->star_name }} </option>
                                        @endforeach
                                    </select>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('actor') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="director" class="form-label">{{ __('director') }} <span
                                            class="text-danger">*</span></label>
                                    <select class="form-select form-select-lg mb-3 with_search" name="director[]"
                                        id="director" multiple>
                                        @foreach ($stars as $director)
                                            @php
                                                if ($director->star_type != 'director') {
                                                    continue;
                                                }
                                            @endphp
                                            <option value="{{ $director->id }}"
                                                {{ isset($movie->director) && in_array($director->id, json_decode($movie->director)) ? 'selected' : '' }}>
                                                {{ $director->star_name }} </option>
                                        @endforeach
                                    </select>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('director') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="writer" class="form-label">{{ __('writer') }} <span
                                            class="text-danger">*</span></label>
                                    <select class="form-select form-select-lg mb-3 with_search" name="writer[]"
                                        id="writer" multiple>
                                        @foreach ($stars as $writer)
                                            @php
                                                if ($writer->star_type != 'writer') {
                                                    continue;
                                                }
                                            @endphp
                                            <option value="{{ $writer->id }}"
                                                {{ isset($movie->writer) && in_array($writer->id, json_decode($movie->writer)) ? 'selected' : '' }}>
                                                {{ $writer->star_name }} </option>
                                        @endforeach
                                    </select>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('writer') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="imdb_rating" class="form-label"> {{ __('imdb_rating') }} </label>
                                    <input type="number" class="form-control rounded-2" id="imdb_rating" name="imdb_rating"
                                        value="{{ $movie->imdb_rating }}" placeholder="{{ __('00') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('imdb_rating') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="date" class="form-label"> {{ __('release_date') }} <span
                                            class="text-danger">*</span> </label>
                                    <input type="date" class="form-control rounded-2" id="date" name="date"
                                        value="{{ $movie->release }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('date') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="country" class="form-label">{{ __('country') }} <span
                                            class="text-danger">*</span></label>
                                    <select class="form-select form-select-lg mb-3 with_search" name="country[]"
                                        id="country" multiple>
                                        <option value=""> {{ __('select_movie_country') }} </option>
                                        @foreach ($countries as $country)
                                            <option value="{{ $country->id }}"
                                                {{ isset($movie->country) && in_array($country->id, json_decode($movie->country)) ? 'selected' : '' }}>
                                                {{ $country->name }} </option>
                                        @endforeach
                                    </select>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('country') }}</p>
                                    </div>
                                </div>

                                <div class="mb-4">
                                    <label for="genre" class="form-label">{{ __('genre') }} <span
                                            class="text-danger">*</span></label>
                                    <select class="form-select form-select-lg mb-3 with_search" name="genre[]"
                                        id="genre" multiple>
                                        <option value=""> {{ __('select_genre') }} </option>
                                        @foreach ($genres as $genre)
                                            <option value="{{ $genre->id }}"
                                                {{ !empty($movie->genre) && in_array($genre->id, json_decode($movie->genre)) ? 'selected' : '' }}>
                                                {{ $genre->name }} </option>
                                        @endforeach
                                    </select>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('genre') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="language" class="form-label">{{ __('language') }} <span
                                            class="text-danger">*</span></label>
                                    <select class="form-select form-select-lg mb-3 with_search" name="language[]"
                                        id="language" multiple>
                                        <option value=""> {{ __('select_movie_language') }} </option>
                                        @foreach ($languages as $language)
                                            <option value="{{ $language->id }}"
                                                {{ isset($movie->language) && in_array($language->id, json_decode($movie->language)) ? 'selected' : '' }}>
                                                {{ $language->name }} </option>
                                        @endforeach
                                    </select>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('language') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="video_type" class="form-label">{{ __('video_type') }} <span
                                            class="text-danger">*</span></label>
                                    <select class="form-select form-select-lg mb-3 with_search" name="video_type"
                                        id="video_type">
                                        <option value=""> {{ __('select_video_type') }} </option>
                                        @foreach ($categories as $category)
                                            <option value="{{ $category->id }}"
                                                {{ $category->id == $movie->video_type ? 'selected' : '' }}>
                                                {{ $category->video_type }} </option>
                                        @endforeach
                                    </select>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('video_type') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="runtime" class="form-label"> {{ __('runtime(in_minutes)') }} <span
                                            class="text-danger">*</span><span class="text-danger">*</span> </label>
                                    <input type="text" class="form-control rounded-2 timepicker" id="runtime"
                                        name="runtime" value="{{ $movie->runtime }}"
                                        placeholder="{{ __('minute_duration') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('runtime') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="video_quality" class="form-label">{{ __('video_quality') }} <span
                                            class="text-danger">*</span></label>
                                    <select class="form-select form-select-lg mb-3 with_search" name="video_quality"
                                        id="video_quality">
                                        <option value=""> {{ __('select_video_quality') }}</option>
                                        @foreach ($video_qualities as $quality)
                                            <option value="{{ $quality->id }}"
                                                {{ $quality->id == $movie->video_quality ? 'selected' : '' }}>
                                                {{ $quality->quality }} </option>
                                        @endforeach
                                    </select>

                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('video_quality') }}</p>
                                    </div>
                                </div>

                                <div
                                    class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                    <input type="hidden" name="status" value="{{ $movie->status }}">
                                    <label class="form-label" for="status"> {{ __('status') }} </label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" {{ $movie->status == 1 ? 'checked' : '' }}
                                            id="status" class="sandbox_mode">
                                        <label for="status"></label>
                                    </div>
                                </div>
                                <div
                                    class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                    <input type="hidden" name="enable_download" value="{{ $movie->enable_download }}">
                                    <label class="form-label" for="enable_download"> {{ __('enable_download') }} </label>
                                    <div class="setting-check">
                                        <input type="checkbox" {{ $movie->enable_download == 1 ? 'checked' : '' }}
                                            value="1" id="enable_download" class="sandbox_mode">
                                        <label for="enable_download"></label>
                                    </div>
                                </div>
                                <div
                                    class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                    <input type="hidden" name="is_original" value="{{ $movie->is_original }}">
                                    <label class="form-label" for="is_original"> {{ __('original') }} </label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1"
                                            {{ $movie->is_original == 1 ? 'checked' : '' }} id="is_original"
                                            class="sandbox_mode">
                                        <label for="is_original"></label>
                                    </div>
                                </div>
                                <div
                                    class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                    <input type="hidden" name="is_blockbuster" value="{{ $movie->is_blockbuster }}">
                                    <label class="form-label" for="is_blockbuster"> {{ __('blockbuster') }} </label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1"
                                            {{ $movie->is_blockbuster == 1 ? 'checked' : '' }} id="is_blockbuster"
                                            class="sandbox_mode">
                                        <label for="is_blockbuster"></label>
                                    </div>
                                </div>
                                <div
                                    class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                    <input type="hidden" name="is_real_life_story"
                                        value="{{ $movie->is_real_life_story }}">
                                    <label class="form-label" for="is_real_life_story"> {{ __('real_life_story') }}
                                    </label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1"
                                            {{ $movie->is_real_life_story == 1 ? 'checked' : '' }} id="is_real_life_story"
                                            class="sandbox_mode">
                                        <label for="is_real_life_story"></label>
                                    </div>
                                </div>
                                <div
                                    class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                    <input type="hidden" name="is_trending" value="{{ $movie->is_trending }}">
                                    <label class="form-label" for="is_trending"> {{ __('is_trending') }}
                                    </label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" id="is_trending"
                                            {{ $movie->is_trending == 1 ? 'checked' : '' }} class="sandbox_mode">
                                        <label for="is_trending"></label>
                                    </div>
                                </div>
                                <div
                                    class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                    <input type="hidden" name="is_featured" value="{{ $movie->is_featured }}">
                                    <label class="form-label" for="is_featured"> {{ __('is_featured') }}
                                    </label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" id="is_featured"
                                            {{ $movie->is_featured == 1 ? 'checked' : '' }} class="sandbox_mode">
                                        <label for="is_featured"></label>
                                    </div>
                                </div>
                                <div
                                    class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                    <input type="hidden" name="is_recommended" value="{{ $movie->is_recommended }}">
                                    <label class="form-label" for="is_recommended"> {{ __('is_recommended') }}
                                    </label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" id="is_recommended"
                                            {{ $movie->is_recommended == 1 ? 'checked' : '' }} class="sandbox_mode">
                                        <label for="is_recommended"></label>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="trailer_youtube_source" class="form-label">
                                        {{ __('trailer_url(mp4_url_only)') }} <span class="text-danger">*</span> </label>
                                    <input type="url" class="form-control rounded-2" id="trailer_youtube_source"
                                        name="trailer_youtube_source" value="{{ $movie->trailler_youtube_source }}"
                                        placeholder="{{ __('mp4_url') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('trailer_youtube_source') }}</p>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30">
                                <h3 class="section-title"> {{ __('poster_and_thumbnail') }} </h3>
                                <div class="input_file_div d-flex align-items-center gap-3">
                                    <div class="mb-3 w-75">
                                        <label for="thumbUpload"
                                            class="form-label mb-1">{{ __('movie_thumbnail_(500x750)') }}</label>
                                        <label for="thumbUpload"
                                            class="file-upload-text">{{ __('select_file_from_device') }}</label>
                                        <input class="d-none file_picker" type="file" name="thumbnail"
                                            id="thumbUpload" accept=".jpg,.png">
                                        <div class="nk-block-des text-danger">
                                            <p class="error">{{ $errors->first('thumbnail') }}</p>
                                        </div>
                                    </div>
                                    <div class="selected-files d-flex flex-wrap gap-20">
                                        <div class="selected-files-item">
                                            <img class="selected-img"
                                                src="{{ getFileLink('thumbnail', $movie->thumbnail, 'movies', '500x750') }}"
                                                alt="thumbnail">
                                        </div>
                                    </div>
                                </div>
                                <div class="input_file_div d-flex align-items-center gap-3">
                                    <div class="mb-3 w-75">
                                        <label for="posterUpload"
                                            class="form-label mb-1">{{ __('movie_poster_(1920x1080)') }}</label>
                                        <label for="posterUpload"
                                            class="file-upload-text">{{ __('select_file_from_device') }}</label>
                                        <input class="d-none file_picker" type="file" name="poster"
                                            id="posterUpload" accept=".jpg,.png">
                                        <div class="nk-block-des text-danger">
                                            <p class="error">{{ $errors->first('poster') }}</p>
                                        </div>
                                    </div>
                                    <div class="selected-files d-flex flex-wrap gap-20">
                                        <div class="selected-files-item">
                                            <img class="selected-img"
                                                src="{{ getFileLink('poster', $movie->poster, 'movies', '1920x1080') }}"
                                                alt="poster">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="default-tab-list default-tab-list-v2 mt-3 bg-white redious-border p-20 p-sm-30">
                                <h3 class="section-title mb-3">{{ __('monetization_and_revenue') }}</h3>

                                {{-- Free Access --}}
                                <div class="d-flex gap-12 align-items-center justify-content-between mb-4">
                                    <input type="hidden" name="is_free" value="{{ $movie->is_free }}"
                                        id="is_free_status">
                                    <label class="form-label mb-0"
                                        for="is_free">{{ __('make_this_movie_free_for_all_users') }}</label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" name="is_free" id="is_free"
                                            {{ old('is_free', $movie->is_free) ? 'checked' : '' }}
                                            class="access-control">
                                        <label for="is_free"></label>
                                    </div>
                                </div>

                                {{-- Rental Access --}}
                                <div class="d-flex gap-12 align-items-center justify-content-between mb-4">
                                    <input type="hidden" name="is_rental" value="{{ $movie->is_rental }}"
                                        id="is_rental_status">
                                    <label class="form-label mb-0"
                                        for="is_rental">{{ __('allow_users_to_rent_this_movie') }}</label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" name="is_rental" id="is_rental"
                                            {{ old('is_rental', $movie->is_rental) ? 'checked' : '' }}
                                            class="access-control">
                                        <label for="is_rental"></label>
                                    </div>
                                </div>

                                {{-- Rental Fields --}}
                                <div id="rental-fields"
                                    class="{{ old('is_rental', $movie->is_rental) ? '' : 'd-none' }} d-flex align-items-center gap-3 flex-wrap">
                                    <div class="mb-3">
                                        <label for="rental_price" class="form-label">{{ __('Rental Price') }}</label>
                                        <input type="number" step="0.01" class="form-control" name="rental_price"
                                            id="rental_price" placeholder="{{ __('rental_price') }}"
                                            value="{{ old('rental_price', $movie->rental_price) }}">
                                    </div>
                                    <div class="mb-3">
                                        <label for="rental_duration"
                                            class="form-label">{{ __('Rental Duration (in hours)') }}</label>
                                        <input type="number" class="form-control" name="rental_duration"
                                            id="rental_duration" placeholder="{{ __('rental_duration') }}"
                                            value="{{ old('rental_duration', $movie->rental_duration) }}">
                                    </div>
                                    <div class="mb-3">
                                        <label for="rental_price" class="form-label">{{ __('Rental type') }}</label>
                                        <select class="form-select form-select-lg mb-3 with_search" name="rental_type"
                                            id="rental_type">
                                            <option value=""> {{ __('select_rental_type') }}</option>
                                            <option value="hours"
                                                {{ $movie->rental_type == 'hours' ? 'selected' : '' }}>
                                                {{ __('hours') }}</option>
                                            <option value="day" {{ $movie->rental_type == 'day' ? 'selected' : '' }}>
                                                {{ __('day') }}</option>
                                            <option value="month"
                                                {{ $movie->rental_type == 'month' ? 'selected' : '' }}>
                                                {{ __('month') }}</option>
                                            <option value="year" {{ $movie->rental_type == 'year' ? 'selected' : '' }}>
                                                {{ __('year') }}</option>
                                        </select>

                                        <div class="nk-block-des text-danger">
                                            <p class="error">{{ $errors->first('rental_type') }}</p>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30 mt-3">
                                <h3 class="section-title"> {{ __('seo_and_marketing') }} </h3>
                                <div class="mb-4">
                                    <label for="seo_title" class="form-label"> {{ __('seo_title') }} </label>
                                    <input type="text" class="form-control rounded-2" id="seo_title" name="seo_title"
                                        value="{{ $movie->seo_title }}" placeholder="{{ __('seo_title') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('seo_title') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="meta_description" class="form-label d-flex justify-content-between">
                                        <span>{{ __('meta_description') }}</span>
                                        <small class="generate-button">
                                            <button data-url="{{ route('ai-helper') }}" data-type="movie_meta_description" data-title="" data-id="meta_description" class="generate-content text-decoration-none text-danger" id="movie-description">
                                                <span><i class="las la-robot"></i></span>
                                            </button>
                                        </small>
                                    </label>
                                    <textarea name="meta_description" id="meta_description" cols="30" rows="3"
                                        class="form-control rounded-2" placeholder="{{ __('meta_description') }}">{{ $movie->meta_description }}</textarea>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('meta_description') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="focus_keyword" class="form-label"> {{ __('focus_keyword') }} </label>
                                    <input type="text" class="form-control rounded-2" id="focus_keyword"
                                        name="focus_keyword" value="{{ $movie->focus_keyword }}"
                                        placeholder="{{ __('focus_focus_keyword') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('focus_keyword') }}</p>
                                    </div>
                                    <p class="text-muted">({{ __('use_comma_to_separate_focus_keyword') }})</p>
                                </div>
                                <div class="mb-4">
                                    <label for="tags" class="form-label"> {{ __('tags') }} </label>
                                    <input type="text" class="form-control rounded-2" id="tags" name="tags"
                                        value="{{ $movie->tags }}" placeholder="{{ __('tags') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('tags') }}</p>
                                    </div>
                                    <p class="text-muted">({{ __('use_comma_to_separate_tags') }})</p>
                                </div>

                                <div
                                    class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                    <input type="hidden" name="email_notify" value="{{ $movie->email_notify }}">
                                    <label class="form-label" for="email_notify">
                                        {{ __('send_email_newslatter_to_subscriber') }} </label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1"
                                            {{ $movie->email_notify == 1 ? 'checked' : '' }} id="email_notify"
                                            class="sandbox_mode">
                                        <label for="email_notify"></label>
                                    </div>
                                </div>

                                <button type="submit" class="btn sg-btn-primary">{{ __('submit') }}</button>
                            </div>
                        </div>
                </form>
            </div>
        </div>
    </div>

@endsection
@push('js')
    <script>
        "use strict";
        $('#description').summernote({
            height: 210,
        });
        $("#title").keyup(function() {
            var Text = $(this).val();
            Text = Text.toLowerCase();
            Text = Text.replace(/[^\w ]+/g, '');
            Text = Text.replace(/ +/g, '-');
            $("#slug").val(Text);
        });

        function toggleAccessFields() {
            const isFree = document.getElementById('is_free').checked;
            const isRental = document.getElementById('is_rental').checked;

            // Only one can be selected
            if (isFree) {
                document.getElementById('is_rental').checked = false;
                document.getElementById('is_rental_status').value = 0;
            } else {
                document.getElementById('is_free_status').value = 0;
            }
            if (isRental) {
                document.getElementById('is_free').checked = false;
                document.getElementById('is_free_status').value = 0;
            } else {
                document.getElementById('is_rental_status').value = 0;
            }

            // Show rental fields if rental is selected
            if (!isFree) {
                document.getElementById('rental-fields').classList.toggle('d-none', !isRental);
            }
        }

        document.querySelectorAll('.access-control').forEach(cb => {
            cb.addEventListener('change', toggleAccessFields);
        });

        // Initialize on page load
        document.addEventListener('DOMContentLoaded', toggleAccessFields);
    </script>
@endpush
