<ul class="d-flex gap-30 justify-content-end align-items-center">
    @can('admin.movie.edit')
    <li><a href="{{ route('admin.movie.edit', ['id' => $movie->id]) }}" title="{{ __('edit') }}"><i class="las la-edit"
                title="{{ __('edit') }}"></i></a></li>
    @endcan
    @can('admin.movie.delete')
    <li><a onclick="delete_row('{{ route('admin.movie.delete', $movie->id) }}','{{ $movie->id }}', 'true')"
            href="javascript:void(0)" title="{{ __('delete') }}"><i class="las la-trash-alt"></i></a></li>
    @endcan
    <div class="dropdown">
        <a class="dropdown-toggle" href="javascript:void(0)" role="button" data-bs-toggle="dropdown" aria-expanded="false">
            <i class="las la-ellipsis-v"></i>
        </a>
        <ul class="dropdown-menu">

            @can('admin.download.links')
            <li>
                <a class="dropdown-item text-muted" href="{{route('admin.download.links', ['type' => 'movie', 'videoId' => $movie->id])}}" title="{{ __('manage_download_links') }}"> {{ __('manage_download_links') }}</a>
            </li>
            @endcan
            @can('admin.movie.upload.downloads')
            <li>
                <a class="dropdown-item text-muted" href="{{route('admin.movie.upload.downloads',['movie_id' => $movie->id])}}" title="{{ __('manage_uploads_file') }}"> {{ __('manage_uploads_file') }}</a>
            </li>
            @endcan
            @can('movie.details')
            <li>
                <a class="dropdown-item text-muted" target="_blank" href="{{route('movie.details',['slug' => $movie->slug])}}" title="{{ __('upload_&_downloads') }}"> {{ __('view') }}</a>
            </li>
            @endcan

        </ul>
    </div>
</ul>