<form action="{{ route('admin.movie_industry.update', ['id' => $movieIndustry->id]) }}" method="post"
    class="form-validate form">
    @csrf
    <div class="row">
        <div class="col-md-12 mb-2">
            <label for="name" class="form-label"> {{ __('name') }} <span class="text-danger">*</span> </label>
            <input type="text" class="form-control rounded-2" id="name" name="name"
                value="{{ $movieIndustry->name }}" placeholder="{{ __('enter_name') }}">
            <div class="nk-block-des text-danger">
                <p class="error">{{ $errors->first('name') }}</p>
            </div>
        </div>

        <div class="col-md-12 mb-4">
            <label for="country_id" class="form-label"> {{ __('country_id') }} </label>
            <select class="form-control rounded-2 select2" id="country_id" name="country_id">
                <option value="">{{ __('select_country') }}</option>
                @foreach (get_all_countries() as $country)
                    <option value="{{ $country->id }}"
                        {{ old('country_id', $movieIndustry->country_id ?? '') == $country->id ? 'selected' : '' }}>
                        {{ $country->name }}
                    </option>
                @endforeach
            </select>
            <div class="nk-block-des text-danger">
                <p class="error">{{ $errors->first('country_id') }}</p>
            </div>
        </div>
        <div class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
            <input type="hidden" name="status" value="{{ $movieIndustry->status }}">
            <label class="form-label" for="status"> {{ __('status') }} </label>
            <div class="setting-check">
                <input type="checkbox" value="1" {{ $movieIndustry->status == 1 ? 'checked' : '' }} id="status"
                    class="sandbox_mode">
                <label for="status"></label>
            </div>
        </div>
    </div>
    <button type="submit" class="btn sg-btn-primary">{{ __('submit') }}</button>
    @include('layouts.loading_button', ['class' => 'btn sg-btn-primary'])
</form>
<script>
    "use strict";
    $('.with_search').select2({
        dropdownParent: $('#ajaxModal')
    });
</script>
