<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <base href="{{ url('/') }}">
    <title> @yield('title') | {{ get_config('system_name') }} </title>
    @php
        $icon = json_decode(get_config('favicon'));
    @endphp

    @if ($icon)
        @php
            // Helper to check file existence
            function favicon_exists($path)
            {
                return $path && file_exists(public_path($path));
            }
        @endphp

        <link rel="apple-touch-icon" sizes="57x57"
            href="{{ favicon_exists($icon->image_57x57_url ?? '') ? static_asset($icon->image_57x57_url) : static_asset('images/default/favicon/favicon-57x57.png') }}">
        <link rel="apple-touch-icon" sizes="60x60"
            href="{{ favicon_exists($icon->image_60x60_url ?? '') ? static_asset($icon->image_60x60_url) : static_asset('images/default/favicon/favicon-60x60.png') }}">
        <link rel="apple-touch-icon" sizes="72x72"
            href="{{ favicon_exists($icon->image_72x72_url ?? '') ? static_asset($icon->image_72x72_url) : static_asset('images/default/favicon/favicon-72x72.png') }}">
        <link rel="apple-touch-icon" sizes="76x76"
            href="{{ favicon_exists($icon->image_76x76_url ?? '') ? static_asset($icon->image_76x76_url) : static_asset('images/default/favicon/favicon-76x76.png') }}">
        <link rel="apple-touch-icon" sizes="114x114"
            href="{{ favicon_exists($icon->image_114x114_url ?? '') ? static_asset($icon->image_114x114_url) : static_asset('images/default/favicon/favicon-114x114.png') }}">
        <link rel="apple-touch-icon" sizes="120x120"
            href="{{ favicon_exists($icon->image_120x120_url ?? '') ? static_asset($icon->image_120x120_url) : static_asset('images/default/favicon/favicon-120x120.png') }}">
        <link rel="apple-touch-icon" sizes="144x144"
            href="{{ favicon_exists($icon->image_144x144_url ?? '') ? static_asset($icon->image_144x144_url) : static_asset('images/default/favicon/favicon-144x144.png') }}">
        <link rel="apple-touch-icon" sizes="152x152"
            href="{{ favicon_exists($icon->image_152x152_url ?? '') ? static_asset($icon->image_152x152_url) : static_asset('images/default/favicon/favicon-152x152.png') }}">
        <link rel="apple-touch-icon" sizes="180x180"
            href="{{ favicon_exists($icon->image_180x180_url ?? '') ? static_asset($icon->image_180x180_url) : static_asset('images/default/favicon/favicon-180x180.png') }}">
        <link rel="icon" type="image/png" sizes="192x192"
            href="{{ favicon_exists($icon->image_192x192_url ?? '') ? static_asset($icon->image_192x192_url) : static_asset('images/default/favicon/favicon-192x192.png') }}">
        <link rel="icon" type="image/png" sizes="32x32"
            href="{{ favicon_exists($icon->image_32x32_url ?? '') ? static_asset($icon->image_32x32_url) : static_asset('images/default/favicon/favicon-32x32.png') }}">
        <link rel="icon" type="image/png" sizes="96x96"
            href="{{ favicon_exists($icon->image_96x96_url ?? '') ? static_asset($icon->image_96x96_url) : static_asset('images/default/favicon/favicon-96x96.png') }}">
        <link rel="icon" type="image/png" sizes="16x16"
            href="{{ favicon_exists($icon->image_16x16_url ?? '') ? static_asset($icon->image_16x16_url) : static_asset('images/default/favicon/favicon-16x16.png') }}">
        <link rel="manifest" href="{{ static_asset('images/default/favicon/manifest.json') }}">

        <meta name="msapplication-TileColor" content="#ffffff">
        <meta name="msapplication-TileImage"
            content="{{ favicon_exists($icon->image_144x144_url ?? '') ? static_asset($icon->image_144x144_url) : static_asset('images/default/favicon/favicon-144x144.png') }}">
    @else
        <link rel="shortcut icon" href="{{ static_asset('images/default/favicon/favicon-96x96.png') }}">
    @endif

    <!-- CSS Files -->
    <!--====== LineAwesome ======-->
    <link rel="stylesheet" href="{{ static_asset('admin/css/line-awesome.min.css') }}">
    <!--====== select2 CSS ======-->
    <link rel="stylesheet" href="{{ static_asset('admin/css/select2.min.css') }}">
    <!--====== Nestable CSS ======-->
    <link rel="stylesheet" href="{{ static_asset('admin/css/nestable.css') }}">
    <!--====== Summernote CSS ======-->
    <link rel="stylesheet" href="{{ static_asset('admin/css/summernote-lite.min.css') }}">
    <!--====== datatable ======-->
    <link href="{{ static_asset('admin/css/jquery.dataTables.min.css') }}" rel="stylesheet">
    <!--====== Flatpicker ======-->
    <link href="{{ static_asset('admin/css/flatpickr.min.css') }}" rel="stylesheet">

    <!--====== AppCSS ======-->
    @stack('css_asset')
    <link rel="stylesheet" href="{{ static_asset('admin/css/toastr.min.css') }}">
    <link rel="stylesheet" href="{{ static_asset('admin/css/app.css') }}?v=2.2.0">
    <link rel="stylesheet" href="{{ static_asset('admin/css/responsive.min.css') }}">
    @stack('css')

    @if (Auth::check() && auth()->user()->role_id == 3)
        @if (setting('is_google_analytics_activated') && setting('tracking_code'))
            {!! base64_decode(setting('tracking_code')) !!}
        @endif
    @endif
</head>

<body
    class="{{ request()->routeIs('client.chat.index') || request()->is('client/flow-builders/*') ? 'chat_sidebar_collapse ' : '' }}">
    <input type="hidden" class="base_url" value="{{ url('/') }}">
    @yield('base.content')
    <script src="{{ static_asset('admin/js/jquery.min.js') }}"></script>
    <!--====== Bootstrap & Popper JS ======-->
    <script src="{{ static_asset('admin/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ static_asset('admin/js/popper.min.js') }}"></script>
    <script src="{{ static_asset('admin/js/jquery.dataTables.min.js') }}"></script>
    <script src="{{ static_asset('admin/js/dataTables.responsive.min.js') }}"></script>
    <!--====== NiceScroll ======-->
    <script src="{{ static_asset('admin/js/jquery.nicescroll.min.js') }}"></script>
    <!--====== Summernote JS ======-->
    <script src="{{ static_asset('admin/js/summernote-lite.min.js') }}"></script>
    <!--====== select2 JS ======-->
    <script src="{{ static_asset('admin/js/select2.min.js') }}"></script>
    <!--====== Chart JS ======-->
    <script src="{{ static_asset('admin/js/custom/dashboard/chart.min.js') }}"></script>

    <!--====== Flatpicker ======-->
    <script src="{{ static_asset('admin/js/flatpickr.js') }}"></script>

    <!--====== MainJS ======-->
    <script src="{{ static_asset('admin/js/app.js') }}"></script>
    <script src="{{ static_asset('admin/js/toastr.min.js') }}"></script>

    <script src="{{ static_asset('admin/js/sweetalert211.min.js') }}"></script>

    @if (session('toastr_success'))
        <script>
            "use strict";
            toastr.success("{{ session('toastr_success') }}");
        </script>
    @endif
    @if (session('toastr_error'))
        <script>
            "use strict";
            toastr.error("{{ session('toastr_error') }}");
        </script>
    @endif
    <!-- Display Toastr message -->
    @include('layouts.delete')
    @include('layouts.modal')
    @include('layouts.script')
    @stack('js')

</body>

</html>
