<form action="{{route('admin.genre.store')}}" method="post" enctype="multipart/form-data" class="form-validate form">
    @csrf
    <div class="mb-2">
        <label for="name" class="form-label"> {{ __('genre_name') }} <span
                class="text-danger">*</span> </label>
        <input type="text" class="form-control rounded-2" id="name" name="name" value="{{ old('name') }}" placeholder="{{ __('genre_name') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('name') }}</p>
        </div>
    </div>
    <div class="mb-4">
        <label for="description" class="form-label"> {{ __('genre_description') }} </label>
        <textarea name="description" id="description" cols="30" rows="4" class="form-control rounded-2"
            placeholder="{{ __('genre_description') }}">{{ old('description') }}</textarea>
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('description') }}</p>
        </div>
    </div>

    <div class="input_file_div d-flex align-items-center gap-3">
        <div class="mb-3 w-100">
            <label for="iconUpload"
                class="form-label mb-1">{{ __('genre_icon_(80x80)') }}</label>
            <label for="iconUpload" class="file-upload-text"></label>
            <input class="d-none file_picker" type="file" name="icon"
                id="iconUpload" accept=".jpg,.png">
            <div class="nk-block-des text-danger">
                <p class="error"></p>
            </div>
        </div>
    </div>

    <div class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
        <input type="hidden" name="featured" value="0">
        <label class="form-label" for="featured"> {{__('is_featured')}} </label>
        <div class="setting-check">
            <input type="checkbox" value="1" id="featured" class="sandbox_mode">
            <label for="featured"></label>
        </div>
    </div>

    <div class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
        <input type="hidden" name="status" value="1">
        <label class="form-label" for="status"> {{__('genre_status')}} </label>
        <div class="setting-check">
            <input type="checkbox" value="1" id="status" checked class="sandbox_mode">
            <label for="status"></label>
        </div>
    </div>
    
    <button type="submit" class="btn sg-btn-primary">{{ __('submit') }}</button>
    @include('layouts.loading_button',['class' => 'btn sg-btn-primary'])
</form>