<form action="{{ route('admin.faq.store') }}" method="post" enctype="multipart/form-data" class="form-validate form">
    @csrf
    <div class="mb-2">
        <label for="question" class="form-label"> {{ __('question') }} <span class="text-danger">*</span> </label>
        <input type="text" class="form-control rounded-2" id="question" name="question" value="{{ old('question') }}"
            placeholder="{{ __('faq_question') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('question') }}</p>
        </div>
    </div>
    <div class="mb-4">
        <label for="answer" class="form-label"> {{ __('answer') }} </label>
        <textarea name="answer" id="answer" cols="30" rows="4" class="form-control rounded-2"
            placeholder="{{ __('faq_answer') }}">{{ old('answer') }}</textarea>
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('answer') }}</p>
        </div>
    </div>

    <div class="mb-4">
        <label for="type" class="form-label">{{ __('faq_type') }} </label>
        <select class="form-select form-select-lg mb-3 select2 with_search" name="type" id="type">
            <option value=""> {{ __('select_faq_type') }}</option>
            <option value="payment"> {{ __('purchase_&_payment') }} </option>
            <option value="order"> {{ __('order_&_return') }} </option>
        </select>
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('type') }}</p>
        </div>
    </div>

    <div class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
        <input type="hidden" name="status" value="1">
        <label class="form-label" for="status"> {{ __('faq_status') }} </label>
        <div class="setting-check">
            <input type="checkbox" value="1" id="status" checked class="sandbox_mode">
            <label for="status"></label>
        </div>
    </div>

    <button type="submit" class="btn sg-btn-primary">{{ __('submit') }}</button>
    @include('layouts.loading_button', ['class' => 'btn sg-btn-primary'])
</form>
<script>
    "use strict";
    $('.with_search').select2({
        dropdownParent: $('#ajaxModal') // Ensure dropdown appears inside modal
    });
</script>
