<table class="table table-borderless best-selling-courses recent-transactions">
    <thead>
        <tr>
            <th>{{ __('plan') }}</th>
            <th>{{ __('price') }}</th>
            <th>{{ __('subscriptions') }}</th>
        </tr>
    </thead>

    <tbody>
        @forelse ($best_selling_plans ?? [] as $plan_id => $total)
            @php
                $plan = App\Models\Package::find($plan_id);
            @endphp
            <tr>
                <td>{{ $plan->name ?? 'N/A' }}</td>
                <td>{{ get_currency(number_format($plan->price ?? 0, 2)) }}</td>
                <td>{{ $total }}</td>
            </tr>
        @empty
            <tr>
                <td colspan="3">{{ __('no_best_selling_plans_found') }}</td>
            </tr>
        @endforelse
    </tbody>
</table>
