@extends('admin.layouts.master')
@section('title', __('customer_query'))
@section('content')

    <section class="oftions">
        <div class="container-fluid">
            <div class="row">
                <div class="col col-md-12">
                    <div class="header-top d-flex justify-content-between align-items-center">
                        <h3 class="section-title">{{ __('query_details') }}</h3>
                        <a href="{{ route('admin.customer_queries.index') }}" class="btn sg-btn-secondary">
                            <i class="las la-arrow-left"></i> {{ __('back_to_list') }}
                        </a>
                    </div>

                    <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30 mt-4">
                        <div class="row mb-4">
                            <div class="col-lg-6">
                                <h5><strong>{{ __('name') }}:</strong> {{ $query->name }}</h5>
                                <h5><strong>{{ __('email') }}:</strong> {{ $query->email }}</h5>
                                <h5><strong>{{ __('subject') }}:</strong> {{ $query->subject }}</h5>
                            </div>
                            <div class="col-lg-6 text-end">
                                <span class="badge {{ $query->status == 1 ? 'bg-success' : 'bg-warning' }}">
                                    {{ $query->status == 1 ? __('Replied') : __('Pending') }}
                                </span>
                            </div>
                        </div>

                        <div class="mb-4">
                            <h5><strong>{{ __('message') }}:</strong></h5>
                            <p>{{ $query->message }}</p>
                        </div>

                        @if ($query->status == 0)
                            {{-- Reply Form --}}
                            <form action="{{ route('admin.customer_queries.reply', $query->id) }}" method="POST">
                                @csrf
                                <div class="form-group mb-4">
                                    <label for="reply">{{ __('your_reply') }}</label>
                                    <textarea name="reply" id="reply" class="form-control" rows="5"
                                        required>{{ old('reply') }}</textarea>
                                    @error('reply')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                                <button type="submit" class="btn sg-btn-primary">
                                    <i class="las la-paper-plane"></i> {{ __('send_reply') }}
                                </button>
                            </form>
                        @else
                            {{-- Show existing reply --}}
                            <div class="mt-4">
                                <h5><strong>{{ __('admin_reply') }}:</strong></h5>
                                <div class="bg-light p-3 rounded">
                                    {!! nl2br(e($query->latestReply?->reply)) !!}
                                </div>
                                <div class="text-muted mt-2 text-end">
                                    <small>{{ __('replied_at') }}:
                                        {{ $query->latestReply?->created_at->format('d M Y, h:i A') }}</small>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection